<?php
class User {
	private $user_id;
	private $username;
  	private $permission = array();

  	public function __construct($registry) {
		$this->db = $registry->get('db');
		$this->request = $registry->get('request');
		$this->session = $registry->get('session');
		
    	if (isset($this->session->data['user_id'])) {
			$user_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "user WHERE user_id = '" . (int)$this->session->data['user_id'] . "' AND status = '1'");
			
			if ($user_query->num_rows) {
				$this->user_id = $user_query->row['user_id'];
				$this->username = $user_query->row['username'];
				
      			$this->db->query("UPDATE " . DB_PREFIX . "user SET ip = '" . $this->db->escape($this->request->server['REMOTE_ADDR']) . "' WHERE user_id = '" . (int)$this->session->data['user_id'] . "'");

      			$user_group_query = $this->db->query("SELECT permission FROM " . DB_PREFIX . "user_group WHERE user_group_id = '" . (int)$user_query->row['user_group_id'] . "'");
				
	  			$permissions = unserialize($user_group_query->row['permission']);

				if (is_array($permissions)) {
	  				foreach ($permissions as $key => $value) {
	    				$this->permission[$key] = $value;
	  				}
				}
			} else {
				$this->logout();
			}
    	}
  	}
		
  	public function login($username, $password) {
    	$user_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "user WHERE username = '" . $this->db->escape($username) . "' AND (password = SHA1(CONCAT(salt, SHA1(CONCAT(salt, SHA1('" . $this->db->escape($password) . "'))))) OR password = '" . $this->db->escape(md5($password)) . "') AND status = '1'");

    	if ($user_query->num_rows) {
			$this->session->data['user_id'] = $user_query->row['user_id'];
			$this->session->data['user_group_id'] = $user_query->row['user_group_id'];
			
			$this->user_id = $user_query->row['user_id'];
			$this->username = $user_query->row['username'];			

      		$user_group_query = $this->db->query("SELECT permission FROM " . DB_PREFIX . "user_group WHERE user_group_id = '" . (int)$user_query->row['user_group_id'] . "'");

	  		$permissions = unserialize($user_group_query->row['permission']);

			if (is_array($permissions)) {
				foreach ($permissions as $key => $value) {
					$this->permission[$key] = $value;
				}
			}
		
      		return true;
    	} else {
      		return false;
    	}
  	}

  	public function logout() {
		unset($this->session->data['user_id']);
		unset($this->session->data['user_group_id']);
	
		$this->user_id = '';
		$this->username = '';
		
		session_destroy();
  	}

  	public function hasPermission($key, $value) {
    	if (isset($this->permission[$key])) {
	  		return in_array($value, $this->permission[$key]);
		} else {
	  		return false;
		}
  	}
  
  	public function isLogged() {
    	return $this->user_id;
  	}
  
  	public function getId() {
    	return $this->user_id;
  	}
	
  	public function getUserName() {
    	return $this->username;
  	}	

  	public function genericLogCommandsFunc($id,$status,$log_target_level,$log_target,$command_id,$resend_status,$p_no ='-1'){ 

  		if($log_target_level==1){

  			$opr_id = $this->db->query("SELECT operator_id FROM " . DB_PREFIX . "stb WHERE stb_no = '" . $log_target . "'");

  			$this->db->query("INSERT INTO " . DB_PREFIX . "logCasCommands SET tx_id =".$id.", command_id = '" . $command_id . "', target = '" . trim($log_target) . "' , target_level =  '" . $log_target_level . "' , datetime = NOW() , status = '" . trim($status) . "', resend = '" . $resend_status . "' , targetNo = '" . $p_no . "' , operator_id = ".$opr_id->row["operator_id"].", triggered_by = ".$this->session->data['user_id']." ");

  		}else{
  			$this->db->query("INSERT INTO " . DB_PREFIX . "logCasCommands SET tx_id =".$id.", command_id = '" . $command_id . "', target = '" . trim($log_target) . "' , target_level =  '" . $log_target_level . "' , datetime = NOW() , status = '" . trim($status) . "', resend = '" . $resend_status . "' , targetNo = '" . $p_no . "' , operator_id = ".$this->session->data['user_id'].", triggered_by = ".$this->session->data['user_id']."");
  		}  	

  	}

  	public function getOperatorIdFromStbno($stbno){
	 	$query = $this->db->query("SELECT `operator_id` FROM ".DB_PREFIX."stb WHERE `stb_no`='".$this->db->escape($stbno)."'");
	 	if($query->num_rows==1){
			return $query->row['operator_id'];
	 	} else {
			return '0';
		}
	}

	public function isStbRMA($stb_no){	 	
	 	$query = $this->db->query("SELECT `box_status` FROM ".DB_PREFIX."stb WHERE `stb_no`='".$stb_no."'");
	 	if($query->row!=NULL){
			return $query->row['box_status'];
	 	}else{
	 		return 0;
		}		
	}

	public function isStbSuspend($stb_no){	 	
	 	$query = $this->db->query("SELECT `is_suspend` FROM ".DB_PREFIX."stb WHERE `stb_no`='".$stb_no."'");
	 	if($query->row!=NULL){
			return $query->row['is_suspend'];
	 	}else{
	 		return 0;
		}		
	}

	public function isLcoSuspend($operator_id){	 	
	 	$query = $this->db->query("SELECT `is_suspend` FROM ".DB_PREFIX."user WHERE `user_id`=".$operator_id);
	 	if($query->row!=NULL){
			return $query->row['is_suspend'];
	 	}else{
	 		return 0;
		}		
	}

}
?>