<?php
class Customer {
	private $customer_id;
	private $firstname;
	private $lastname;
	private $STBNO;
	private $CASNO;
	private $email;
	private $telephone;
	private $fax;
	private $newsletter;
	private $customer_group_id;
	private $address_id;
	
  	public function __construct($registry) {
		$this->config = $registry->get('config');
		$this->db = $registry->get('db');
		$this->request = $registry->get('request');
		$this->session = $registry->get('session');
				
		if (isset($this->session->data['customer_id'])) { 
			$customer_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "customer WHERE customer_id = '" . (int)$this->session->data['customer_id'] . "' AND status = '1'");
			
			if ($customer_query->num_rows) {
				$this->customer_id = $customer_query->row['customer_id'];
				$this->firstname = $customer_query->row['firstname'];
				$this->lastname = $customer_query->row['lastname'];
				$this->STBNO = $customer_query->row['STBNO'];
				//$this->CASNO = $customer_query->row['CASNO'];
				$this->SCNO = $customer_query->row['SCNO'];
				$this->email = $customer_query->row['email'];
				$this->telephone = $customer_query->row['telephone'];
				$this->fax = $customer_query->row['fax'];
				$this->newsletter = $customer_query->row['newsletter'];
				$this->customer_group_id = $customer_query->row['customer_group_id'];
				$this->address_id = $customer_query->row['address_id'];
							
      			$this->db->query("UPDATE " . DB_PREFIX . "customer SET cart = '" . $this->db->escape(isset($this->session->data['cart']) ? serialize($this->session->data['cart']) : '') . "', wishlist = '" . $this->db->escape(isset($this->session->data['wishlist']) ? serialize($this->session->data['wishlist']) : '') . "', ip = '" . $this->db->escape($this->request->server['REMOTE_ADDR']) . "' WHERE customer_id = '" . (int)$this->customer_id . "'");
			
				$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "customer_ip WHERE customer_id = '" . (int)$this->session->data['customer_id'] . "' AND ip = '" . $this->db->escape($this->request->server['REMOTE_ADDR']) . "'");
				
				if (!$query->num_rows) {
					$this->db->query("INSERT INTO " . DB_PREFIX . "customer_ip SET customer_id = '" . (int)$this->session->data['customer_id'] . "', ip = '" . $this->db->escape($this->request->server['REMOTE_ADDR']) . "', date_added = NOW()");
				}
			} else {
				$this->logout();
			}
  		}
	}
		
  	public function login($customerNo, $password, $override = false) {
		if ($override) {
			$customer_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "customer where customer_unique_id = '".$customerNo."' AND status = '1'");
		} else {
			$customer_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "customer WHERE customer_unique_id = '".$customerNo."' AND (password = SHA1(CONCAT(salt, SHA1(CONCAT(salt, SHA1('" . $this->db->escape($password) . "'))))) OR password = '" . $this->db->escape(md5($password)) . "') AND status = '1' AND approved = '1'");
		}

		if ($customer_query->num_rows) {
			$this->session->data['customer_id'] = $customer_query->row['customer_id'];	
		    
			if ($customer_query->row['cart'] && is_string($customer_query->row['cart'])) {
				$cart = unserialize($customer_query->row['cart']);
				
				foreach ($cart as $key => $value) {
					if (!array_key_exists($key, $this->session->data['cart'])) {
						$this->session->data['cart'][$key] = $value;
					} else {
						$this->session->data['cart'][$key] += $value;
					}
				}			
			}

			if ($customer_query->row['wishlist'] && is_string($customer_query->row['wishlist'])) {
				if (!isset($this->session->data['wishlist'])) {
					$this->session->data['wishlist'] = array();
				}
								
				$wishlist = unserialize($customer_query->row['wishlist']);
			
				foreach ($wishlist as $product_id) {
					if (!in_array($product_id, $this->session->data['wishlist'])) {
						$this->session->data['wishlist'][] = $product_id;
					}
				}			
			}
									
			$this->customer_id = $customer_query->row['customer_id'];
			$this->firstname = $customer_query->row['firstname'];
			$this->lastname = $customer_query->row['lastname'];
			$this->STBNO = $customer_query->row['STBNO'];
			// $this->CASNO = $customer_query->row['CASNO'];
			$this->email = $customer_query->row['email'];
			$this->telephone = $customer_query->row['telephone'];
			$this->fax = $customer_query->row['fax'];
			$this->newsletter = $customer_query->row['newsletter'];
			$this->customer_group_id = $customer_query->row['customer_group_id'];
			$this->address_id = $customer_query->row['address_id'];
          	
			$this->db->query("UPDATE " . DB_PREFIX . "customer SET ip = '" . $this->db->escape($this->request->server['REMOTE_ADDR']) . "' WHERE customer_id = '" . (int)$this->customer_id . "'");
			
	  		return true;
    	} else {
      		return false;
    	}
  	}

  	
	public function logout() {
		$this->db->query("UPDATE " . DB_PREFIX . "customer SET cart = '" . $this->db->escape(isset($this->session->data['cart']) ? serialize($this->session->data['cart']) : '') . "', wishlist = '" . $this->db->escape(isset($this->session->data['wishlist']) ? serialize($this->session->data['wishlist']) : '') . "' WHERE customer_id = '" . (int)$this->customer_id . "'");
		
		unset($this->session->data['customer_id']);

		$this->customer_id = '';
		$this->firstname = '';
		$this->lastname = '';
		$this->email = '';
		$this->STBNO = '';
		//$this->CASNO ='';
		$this->telephone = '';
		$this->fax = '';
		$this->newsletter = '';
		$this->customer_group_id = '';
		$this->address_id = '';
  	}

  	public function isUserPairedWithSTB() {
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "customer WHERE customer_id = '".$this->customer_id."'");
		if($query->num_rows)
		{
			// return $query->row['STBNO'] != '';
			return $query->row['STBNO'] != '0';
		}
		return false;
  	}

  	public function validateBoxStatus() {
      	$query = $this->db->query("SELECT is_active FROM `" . DB_PREFIX . "customer` c LEFT JOIN `" . DB_PREFIX . "stb` s ON (c.STBNO=s.stb_no) WHERE c.customer_id = '" .$this->customer_id . "' ");      	
		return $query->row['is_active'];
	}

	public function validateBoxBlacklistStatus() {
      	$query = $this->db->query("SELECT is_black_list FROM `" . DB_PREFIX . "customer` c LEFT JOIN `" . DB_PREFIX . "stb` s ON (c.STBNO=s.stb_no) WHERE c.customer_id = '" .$this->customer_id . "' ");      	
		return $query->row['is_black_list'];
	}

	public function isStbSuspend() {
      	$query = $this->db->query("SELECT is_suspend FROM `" . DB_PREFIX . "customer` c LEFT JOIN `" . DB_PREFIX . "stb` s ON (c.STBNO=s.stb_no) WHERE c.customer_id = '" .$this->customer_id . "' ");      	
		return $query->row['is_suspend'];
	}

	public function isStbRMA() {
      	$query = $this->db->query("SELECT box_status FROM `" . DB_PREFIX . "customer` c LEFT JOIN `" . DB_PREFIX . "stb` s ON (c.STBNO=s.stb_no) WHERE c.customer_id = '" .$this->customer_id . "' ");      	
		return $query->row['box_status'];
	}

	public function getOperatorIdFromStb(){
	 	$query = $this->db->query("SELECT `operator_id` FROM ".DB_PREFIX."stb WHERE `customer_id`='".$this->customer_id."'");
	 	if($query->num_rows==1){
			return $query->row['operator_id'];
	 	} else {
			return '0';
		}
	}

	public function isLcoSuspend($operator_id){	 	
	 	$query = $this->db->query("SELECT `is_suspend` FROM ".DB_PREFIX."user WHERE `user_id`=".$operator_id);
	 	if($query->row!=NULL){
			return $query->row['is_suspend'];
	 	}else{
	 		return 0;
		}		
	}

  	public function isLogged() {
    	return $this->customer_id;
  	}

  	public function getId() {
    	return $this->customer_id;
  	}
      
  	public function getFirstName() {
		return $this->firstname;
  	}
    
    public function getSTBNO()
    {
    	return $this->STBNO;
    }

    public function getCASNO()
    {
    	return $this->CASNO;
    }
    public function getSCNO()
    {
    	return $this->SCNO;
    }

  	public function getLastName() {
		return $this->lastname;
  	}
  
  	public function getEmail() {
		return $this->email;
  	}
  
  	public function getTelephone() {
		return $this->telephone;
  	}
  
  	public function getFax() {
		return $this->fax;
  	}
	
  	public function getNewsletter() {
		return $this->newsletter;	
  	}

  	public function getCustomerGroupId() {
		return $this->customer_group_id;	
  	}
	
  	public function getAddressId() {
		return $this->address_id;	
  	}
	
  	public function getBalance() {
		$query = $this->db->query("SELECT SUM(amount) AS total FROM " . DB_PREFIX . "customer_transaction WHERE customer_id = '" . (int)$this->customer_id . "'");
	
		return $query->row['total'];
  	}	
		
  	public function getRewardPoints() {
		$query = $this->db->query("SELECT SUM(points) AS total FROM " . DB_PREFIX . "customer_reward WHERE customer_id = '" . (int)$this->customer_id . "'");
	
		return $query->row['total'];	
  	}	

  	public function genericLogCommandsFunc($id,$status,$log_target_level,$log_target,$command_id,$resend_status,$p_no ='-1'){ 
  		if($log_target_level==1){

  			$opr_id = $this->db->query("SELECT operator_id FROM " . DB_PREFIX . "stb WHERE stb_no = '" . $log_target . "'");

  			$this->db->query("INSERT INTO " . DB_PREFIX . "logCasCommands SET tx_id =".$id.", command_id = '" . $command_id . "', target = '" . $log_target . "' , target_level =  '" . $log_target_level . "' , datetime = NOW() , status = '" . $status . "', resend = '" . $resend_status . "' , targetNo = '" . $p_no . "' , operator_id = ".$opr_id->row["operator_id"].", triggered_by = ".$this->session->data['user_id']." ");

  		}else{ 		
  			$this->db->query("INSERT INTO " . DB_PREFIX . "logCasCommands SET tx_id =".$id.", command_id = '" . $command_id . "', target = '" . $log_target . "' , target_level = 1, datetime = NOW() , status = '" . $status . "', resend = '" . $resend_status . "' , targetNo = '" . $p_no . "', operator_id = ".$this->session->data['user_id'].", triggered_by = ".$this->session->data['user_id']." ");
  		}
  	}

  	public function isBasicPackage($product_id)	{
		$query = $this->db->query("SELECT package_type FROM ".DB_PREFIX."product WHERE product_id = '" . (int)$product_id . "' AND is_package=1 
				 AND package_type=1 ");
		return $query->row;
	}

	public function isBasicPackageAvailable($customer_id,$product_id,$isBasePack) {
		if($isBasePack){
			$query = $this->db->query("SELECT pd.name as productName, pd.product_id FROM " . DB_PREFIX . "subscriptionDesubscription sd 
				     INNER JOIN ".DB_PREFIX."product p ON p.product_id = sd.product_id INNER JOIN ".DB_PREFIX."product_description pd ON 
				     pd.product_id = p.product_id WHERE sd.user_id=".$customer_id."  AND sd.exp_date > NOW() AND p.is_package = 1 AND p.package_type=1 ");
			// var_dump($query->num_rows); die;
			if($query->num_rows>0){
				if($query->num_rows>1)
					return 201;// for Multiple base pack subscribed;
				elseif($query->row['product_id']==$product_id)
					return 101; // for only one base pack subscribed and to extend the expiry.
				else
					return 301; // different base pack subscripiton available.
			}else{
				return 101; // no base pack subscription available. Trigger new subscription. 
			}
		}else{
			$query = $this->db->query("SELECT pd.name as productName, pd.product_id FROM " . DB_PREFIX . "subscriptionDesubscription sd 
				     INNER JOIN ".DB_PREFIX."product p ON p.product_id = sd.product_id INNER JOIN ".DB_PREFIX."product_description pd ON 
				     pd.product_id = p.product_id WHERE sd.user_id=".$customer_id."  AND sd.exp_date > NOW() AND p.is_package = 1 AND p.package_type=1 ");
			if($query->num_rows>0){
				if($query->num_rows>1)
					return 201;// for Multiple base pack subscribed;
				else
					return 401;
			}else{
				return 101;
			}
		}
	} 
}
?>