<?php

/**
 * Based on: http://stackoverflow.com/questions/99350/passing-php-associative-arrays-to-and-from-xml
 */
// class ArrayToXMLOld 
// {
//     private $version;
//     private $encoding;
//     /**
//      * Construct ArrayToXML object with selected version and encoding
//      *
//      * for available values check XmlWriter docs http://www.php.net/manual/en/function.xmlwriter-start-document.php
//      * @param string $xmlVersion XML Version, default 1.0
//      * @param string $xmlEncoding XML Encoding, default UTF-8
//      */
//     public function __construct($xmlVersion = '1.0', $xmlEncoding = 'UTF-8')
//     {
//         $this->version = $xmlVersion;
//         $this->encoding = $xmlEncoding;
//     }
//     /**
//      * Build an XML Data Set
//      *
//      * @param array $data Associative Array containing values to be parsed into an XML Data Set(s)
//      * @param string $startElement Root Opening Tag, default data
//      * @return string XML String containing values
//      * @return mixed Boolean false on failure, string XML result on success
//      */
//     public function buildXML($data, $startElement = 'data')
//     {
//        // var_dump($startElement); exit();
//         if (!is_array($data)) {
//             $err = 'Invalid variable type supplied, expected array not found on line ' . __LINE__ . ' in Class: ' . __CLASS__ . ' Method: ' . __METHOD__;
//             trigger_error($err);
//             return false; //return false error occurred
//         }
//         $xml = new XmlWriter();
//         $xml->openMemory();
//         $xml->startDocument($this->version, $this->encoding);
//         $xml->startElement($startElement);
//         $this->writeAttr($xml, $data);
//         $this->writeEl($xml, $data);
//         $xml->endElement(); //write end element
//         //returns the XML results
//         return $xml->outputMemory(true);
//     }
//     /**
//      * Write keys in $data prefixed with @ as XML attributes, if $data is an array.
//      * When an @ prefixed key is found, a '%' key is expected to indicate the element itself,
//      * and '#' prefixed key indicates CDATA content
//      *
//      * @param XMLWriter $xml object
//      * @param array $data with attributes filtered out
//      * @return array $data | $nonAttributes
//      */
//     protected function writeAttr(XMLWriter $xml, $data)
//     {
//         if (is_array($data)) {
//             $nonAttributes = array();
//             foreach ($data as $key => $val) {
//                 //handle an attribute with elements
//                 if ($key[0] == '@') {
//                     $xml->writeAttribute(substr($key, 1), $val);
//                 } else if ($key[0] == '%') {
//                     if (is_array($val)) $nonAttributes = $val;
//                     else $xml->text($val);
//                 } elseif ($key[0] == '#') {
//                     if (is_array($val)) $nonAttributes = $val;
//                     else {
//                         $xml->startElement(substr($key, 1));
//                         $xml->writeCData($val);
//                         $xml->endElement();
//                     }
//                 } //ignore normal elements
//                 else $nonAttributes[$key] = $val;
//             }
//             return $nonAttributes;
//         } else return $data;
//     }
//     /**
//      * Write XML as per Associative Array
//      *
//      * @param XMLWriter $xml object
//      * @param array $data Associative Data Array
//      */
//     protected function writeEl(XMLWriter $xml, $data)
//     {
//         foreach ($data as $key => $value) {
//             if (is_array($value) && !$this->isAssoc($value)) { //numeric array
//                 foreach ($value as $itemValue) {
//                     if (is_array($itemValue)) {
//                         $xml->startElement($key);
//                         $itemValue = $this->writeAttr($xml, $itemValue);
//                         $this->writeEl($xml, $itemValue);
//                         $xml->endElement();
//                     } else {
//                         $itemValue = $this->writeAttr($xml, $itemValue);
//                         $xml->writeElement($key, "$itemValue");
//                     }
//                 }
//             } else if (is_array($value)) { //associative array
//                 $xml->startElement($key);
//                 $value = $this->writeAttr($xml, $value);
//                 $this->writeEl($xml, $value);
//                 $xml->endElement();
//             } else { //scalar
//                 $value = $this->writeAttr($xml, $value);
//                 $xml->writeElement($key, "$value");
//             }
//         }
//     }
//     /**
//      * Check if array is associative with string based keys
//      * FROM: http://stackoverflow.com/questions/173400/php-arrays-a-good-way-to-check-if-an-array-is-associative-or-sequential/4254008#4254008
//      *
//      * @param array $array Array to check
//      * @return bool
//      */
//     protected function isAssoc($array)
//     {
//         return (bool)count(array_filter(array_keys($array), 'is_string'));
//     }
// }



class ArrayToXML
{
    /**
     * The main function for converting to an XML document.
     * Pass in a multi dimensional array and this recrusively loops through and builds up an XML document.
     * Based on: http://snipplr.com/view/3491/convert-php-array-to-xml-or-simple-xml-object-if-you-wish/
     * 
     * @param array $data
     * @param string $rootNodeName - what you want the root node to be - defaultsto data.
     * @param SimpleXMLElement $xml - should only be used recursively
     * @return string XML
     */
    private $sRoot="";

    public static function toXml($data, $rootNodeName, $st, &$xml=null)   {

        // var_dump($st); exit();

        // turn off compatibility mode as simple xml throws a wobbly if you don't.
   // if ( ini_get('zend.ze1_compatibility_mode') == 1 ) ini_set ( 'zend.ze1_compatibility_mode', 0 );

    $sRoot=$st;

    if ( is_null( $xml ) ) {
        $xml = simplexml_load_string(stripslashes($sRoot));
    }
    // var_dump($xml); exit();

    // loop through the data passed in.
    foreach( $data as $key => $value ) {
        // no numeric keys in our xml please!
        $numeric = false;
        if ( is_numeric( $key ) ) {
            $numeric = 1;
            $key = $rootNodeName;
        }

        //var_dump($key); exit();
        // delete any char not allowed in XML element names
        $key = preg_replace('/[^a-z0-9\-\_\.\:]/i', '', $key);
        
        //check to see if there should be an attribute added (expecting to see _id_)
        $attrs = false;

        //if there are attributes in the array (denoted by attr_**) then add as XML attributes
        if ( is_array( $value ) ) {
            foreach($value as $i => $v ) {
                $attr_start = false;
                $attr_start = stripos($i, 'attr_');
                if ($attr_start === 0) {
                    $attrs[substr($i, 5)] = $v; unset($value[$i]);
                }
            }
        }
          
        
        // if there is another array found recursively call this function
        if ( is_array( $value ) ) {

            if ( ArrayToXML::is_assoc( $value ) || $numeric ) {

                // older SimpleXMLElement Libraries do not have the addChild Method
                if (method_exists('SimpleXMLElement','addChild'))
                {
                    $node = $xml->addChild( $key, null);
                    if ($attrs) {
                        foreach($attrs as $key => $attribute) {
                            $node->addAttribute($key, $attribute);
                        }
                    }
                }

            }else{
                $node =$xml;
            }


            // recrusive call.
            if ( $numeric ) $key = 'anon';
            ArrayToXML::toXml( $value, $key, $sRoot, $node );
        } else {

                // older SimplXMLElement Libraries do not have the addChild Method
                if (method_exists('SimpleXMLElement','addChild'))
                {
                    $childnode = $xml->addChild( $key, $value);
                    if ($attrs) {
                        foreach($attrs as $key => $attribute) {
                            $childnode->addAttribute($key, $attribute);
                        }
                    }
                }
        }
    }

    // pass back as unformatted XML
//var_dump($data); exit();
   // var_dump($xml->asXML()); exit();
    return $xml->asXML();

    // if you want the XML to be formatted, use the below instead to return the XML
        /*$doc = new DOMDocument('1.0');
        $doc->preserveWhiteSpace = false;
        @$doc->loadXML( ArrayToXML::fixCDATA($xml->asXML()) );
        $doc->formatOutput = true;
        //return $doc->saveXML();
        return $doc->save('data.xml');*/
    }

    public static function fixCDATA($string) {
        //fix CDATA tags
        $find[]     = '&lt;![CDATA[';
        $replace[] = '<![CDATA[';
        $find[]     = ']]&gt;';
        $replace[] = ']]>'; 
        
        $string = str_ireplace($find, $replace, $string);   
        return $string;
    }

/**
 * Convert an XML document to a multi dimensional array
 * Pass in an XML document (or SimpleXMLElement object) and this recrusively loops through and builds a representative array
 *
 * @param string $xml - XML document - can optionally be a SimpleXMLElement object
 * @return array ARRAY
 */
    public static function toArray( $xml ) {
        if ( is_string( $xml ) ) $xml = new SimpleXMLElement( $xml );
        $children = $xml->children();
        if ( !$children ) return (string) $xml;
        $arr = array();
        foreach ( $children as $key => $node ) {
            $node = ArrayToXML::toArray( $node );
    
            // support for 'anon' non-associative arrays
            if ( $key == 'anon' ) $key = count( $arr );
    
            // if the node is already set, put it into an array
            if ( isset( $arr[$key] ) ) {
                if ( !is_array( $arr[$key] ) || $arr[$key][0] == null ) $arr[$key] = array( $arr[$key] );
                $arr[$key][] = $node;
            } else {
                $arr[$key] = $node;
            }
        }
        return $arr;
    }
    
    // determine if a variable is an associative array
    public static function is_assoc( $array ) {
        return (is_array($array) && 0 !== count(array_diff_key($array, array_keys(array_keys($array)))));
    }
}

?>



