<?php
require('fpdf.php');

class PDF extends FPDF
{
    private $name,$email,$logo,$address,$current_date;
    public static $is_address=0;
    function __construct($name,$email,$logo,$icas_logo,$address) 
    {
        parent::__construct();
        $this->name      = $name;
        $this->email     = $email;
        $this->logo      = $logo;
        $this->icas_logo = $icas_logo;
        $this->address   = $address;
        $currDate        = new DateTime("now",new DateTimeZone('Asia/Calcutta'));  
        $this->current_date    = $currDate->format('d-m-Y H:i:s');   
    }

    function Header($orientation='')
    {

    	if(isset($this->icas_logo))
        {
           $this->Image($this->icas_logo,15,10,30);    
        }
        if(isset($this->logo))
        {
           $this->Image($this->logo,46,15,40);    
        }

        /*if(PDF::$is_address==0)
        {
            $this->SetFont('times','B',8);
            $this->SetY(4);
            $this->SetX(75);
            $this->Cell(180,6,$this->name,0,0,'C',0);
            $this->SetY(8);
            $this->SetX(75);
            $this->Cell(178,6,$this->email,0,0,'C',0);
            $this->SetY(14);
            $this->SetX(150);
            $this->MultiCell(180,3,$this->address);//,0,0,'C',0);
            
        }
        $this->SetY(26);
        PDF::$is_address++;*/  


        // NOTE:- changed  for all page display header (Azfar v_3.5)
        if($orientation=='L'){
            $AddressMarginX=230;
        }else{
            $AddressMarginX=150;
        }
        $this->SetFont('times','B',8);
        $this->SetY(4);
        $this->SetX($AddressMarginX);
        $this->Cell($AddressMarginX,6,$this->name,0,0,'L',0);
        $this->SetY(8);
        $this->SetX($AddressMarginX);
        $this->Cell($AddressMarginX,6,$this->email,0,0,'L',0);
        $this->SetY(13);
        $this->SetX($AddressMarginX);
        $this->MultiCell(45,3,$this->address);//,0,0,'C',0);
        $this->SetY(21);
        $this->SetX($AddressMarginX);
        $this->Cell($AddressMarginX,6,$this->current_date,0,0,'L',0);
        $this->SetY(28);
        // PDF::$is_address++;

    }

        // NOTE:- Added to text wrap content in cell (Azfar v_3.10)
    function vvcell($c_width,$c_height,$x_axis,$text,$wrap_limit){
        $w_text=str_split($text,$wrap_limit);
            // echo "<pre>";print_r($w_text);die;
        $no_of_lines = count($w_text);

        $w_w=$c_height/$no_of_lines;
        // $w_w1=$w_w+2;
        $len=strlen($text);// check the length of the cell and splits the text into 21 character each and saves in a array 
        if($len>$wrap_limit){
            // var_dump($w_text[0]);die;
            // $w_text=str_split($text,$wrap_limit);
            $i=0;
            while($i<count($w_text)){
                $this->SetX($x_axis);
                $this->Cell($c_width,($i+1)*($w_w+2)+$i,$w_text[$i],'','','');    
                // $this->SetX($x_axis);
                // $this->Cell($c_width,$w_w2,$w_text[1],'','','');    
                // $this->SetX($x_axis);
                // $this->Cell($c_width,$w_w3,$w_text[2],'','','');    
                $i++;
                   // if($i==20)break; 
            }
            // var_dump(count($w_text));die;
            // echo "<pre>";print_r($w_text);die;
            /*$this->SetX($x_axis);
            $this->Cell($c_width,$w_w_1,$w_text[0],'','','');
            $this->SetX($x_axis);
            $this->Cell($c_width,$w_w1,$w_text[1],'','','');*/
            $this->SetX($x_axis);
            $this->Cell($c_width,$c_height,'','LTRB',0,'L',0);
        }
        else{
            $this->SetX($x_axis);
            $this->Cell($c_width,$c_height,$text,'LTRB',0,'L',0);
        }
    }

    // NOTE:- Added to text wrap content in cell (Azfar v_3.10)
    function vcell($c_width,$c_height,$x_axis,$text,$wrap_limit){
        $w_w=$c_height/3;
        $w_w_1=$w_w+2;
        $w_w1=$w_w+$w_w+$w_w+3;
        $len=strlen($text);// check the length of the cell and splits the text into 21 character each and saves in a array 
        if($len>$wrap_limit){
            $w_text=str_split($text,$wrap_limit);
            $this->SetX($x_axis);
            $this->Cell($c_width,$w_w_1,$w_text[0],'','','');
            $this->SetX($x_axis);
            $this->Cell($c_width,$w_w1,$w_text[1],'','','');
            $this->SetX($x_axis);
            $this->Cell($c_width,$c_height,'','LTRB',0,'L',0);
        }
        else{
            $this->SetX($x_axis);
            $this->Cell($c_width,$c_height,$text,'LTRB',0,'L',0);
        }
    }

    function Footer()
    {
         $this->SetY(-15);
        // Select Arial italic 8
        $this->SetFont('Arial','I',8);
        // Print current and total page numbers
        $this->Cell(0,10,'Page '.$this->PageNo().' of {nb}',0,0,'C');
    }


}

// Instanciation of inherited class
//  $pdf = new PDF($name,$email,$logo,$address);
// // $AliasNbPages();
//  $pdf->AddPage();
?>