<?php


namespace Predis\Transaction;

use \PHPUnit_Framework_TestCase as StandardTestCase;

use Predis\Client;

/**
 *
 */
class AbortedMultiExecExceptionTest extends StandardTestCase
{
    /**
     * @group disconnected
     */
    public function testExceptionClass()
    {
        $client = new Client();
        $transaction = new MultiExecContext($client);
        $exception = new AbortedMultiExecException($transaction, 'ABORTED');

        $this->assertInstanceOf('Predis\PredisException', $exception);
        $this->assertSame('ABORTED', $exception->getMessage());
        $this->assertSame($transaction, $exception->getTransaction());
    }
}
