<?php


namespace Predis\Protocol\Text;

use \PHPUnit_Framework_TestCase as StandardTestCase;

/**
 *
 */
class ResponseMultiBulkStreamHandlerTest extends StandardTestCase
{
    /**
     * @group disconnected
     */
    public function testOk()
    {
        $handler = new ResponseMultiBulkStreamHandler();

        $connection = $this->getMock('Predis\Connection\ComposableConnectionInterface');

        $connection->expects($this->never())->method('readLine');
        $connection->expects($this->never())->method('readBytes');

        $this->assertInstanceOf('Predis\Iterator\MultiBulkResponseSimple', $handler->handle($connection, '1'));
    }

    /**
     * @group disconnected
     * @expectedException Predis\Protocol\ProtocolException
     * @expectedExceptionMessage Cannot parse 'invalid' as multi-bulk length
     */
    public function testInvalid()
    {
        $handler = new ResponseMultiBulkStreamHandler();

        $connection = $this->getMock('Predis\Connection\ComposableConnectionInterface');

        $connection->expects($this->never())->method('readLine');
        $connection->expects($this->never())->method('readBytes');

        $handler->handle($connection, 'invalid');
    }
}
