<?php


namespace Predis\Command;

use \PHPUnit_Framework_TestCase as StandardTestCase;

/**
 * @group commands
 * @group realm-list
 */
class ListIndexTest extends CommandTestCase
{
    /**
     * {@inheritdoc}
     */
    protected function getExpectedCommand()
    {
        return 'Predis\Command\ListIndex';
    }

    /**
     * {@inheritdoc}
     */
    protected function getExpectedId()
    {
        return 'LINDEX';
    }

    /**
     * @group disconnected
     */
    public function testFilterArguments()
    {
        $arguments = array('key', 1);
        $expected = array('key', 1);

        $command = $this->getCommand();
        $command->setArguments($arguments);

        $this->assertSame($expected, $command->getArguments());
    }

    /**
     * @group disconnected
     */
    public function testParseResponse()
    {
        $this->assertSame(0, $this->getCommand()->parseResponse(0));
    }

    /**
     * @group disconnected
     */
    public function testPrefixKeys()
    {
        $arguments = array('key', 1);
        $expected = array('prefix:key', 1);

        $command = $this->getCommandWithArgumentsArray($arguments);
        $command->prefixKeys('prefix:');

        $this->assertSame($expected, $command->getArguments());
    }

    /**
     * @group disconnected
     */
    public function testPrefixKeysIgnoredOnEmptyArguments()
    {
        $command = $this->getCommand();
        $command->prefixKeys('prefix:');

        $this->assertSame(array(), $command->getArguments());
    }

    /**
     * @group connected
     */
    public function testReturnsElementAtIndex()
    {
        $redis = $this->getClient();

        $redis->rpush('letters', 'a', 'b', 'c', 'd', 'e');

        $this->assertSame('a', $redis->lindex('letters', 0));
        $this->assertSame('c', $redis->lindex('letters', 2));
        $this->assertNull($redis->lindex('letters', 100));
    }

    /**
     * @group connected
     */
    public function testReturnsElementAtNegativeIndex()
    {
        $redis = $this->getClient();

        $redis->rpush('letters', 'a', 'b', 'c', 'd', 'e');

        $this->assertSame('a', $redis->lindex('letters', -0));
        $this->assertSame('c', $redis->lindex('letters', -3));
        $this->assertSame('e', $redis->lindex('letters', -1));
        $this->assertNull($redis->lindex('letters', -100));
    }

    /**
     * @group connected
     * @expectedException Predis\ServerException
     * @expectedExceptionMessage Operation against a key holding the wrong kind of value
     */
    public function testThrowsExceptionOnWrongType()
    {
        $redis = $this->getClient();

        $redis->set('foo', 'bar');
        $redis->lindex('foo', 0);
    }
}
