<?php



namespace Predis\Command;

use \PHPUnit_Framework_TestCase as StandardTestCase;

/**
 * @group commands
 * @group realm-connection
 */
class ConnectionAuthTest extends CommandTestCase
{
    /**
     * {@inheritdoc}
     */
    protected function getExpectedCommand()
    {
        return 'Predis\Command\ConnectionAuth';
    }

    /**
     * {@inheritdoc}
     */
    protected function getExpectedId()
    {
        return 'AUTH';
    }

    /**
     * @group disconnected
     */
    public function testFilterArguments()
    {
        $arguments = array('password');
        $expected = array('password');

        $command = $this->getCommand();
        $command->setArguments($arguments);

        $this->assertSame($expected, $command->getArguments());
    }

    /**
     * @group disconnected
     */
    public function testParseResponse()
    {
        $raw = null;
        $expected = null;

        $command = $this->getCommand();

        $this->assertSame($expected, $command->parseResponse($raw));
    }
}
