<?php


namespace Predis\Protocol\Text;

use Predis\CommunicationException;
use Predis\Connection\ComposableConnectionInterface;
use Predis\Protocol\ProtocolException;
use Predis\Protocol\ResponseHandlerInterface;

class ResponseBulkHandler implements ResponseHandlerInterface
{
    /**
     * Handles a bulk reply returned by Redis.
     *
     * @param ComposableConnectionInterface $connection Connection to Redis.
     * @param string $lengthString Bytes size of the bulk reply.
     * @return string
     */
    public function handle(ComposableConnectionInterface $connection, $lengthString)
    {
        $length = (int) $lengthString;

        if ("$length" !== $lengthString) {
            CommunicationException::handle(new ProtocolException(
                $connection, "Cannot parse '$lengthString' as bulk length"
            ));
        }

        if ($length >= 0) {
            return substr($connection->readBytes($length + 2), 0, -2);
        }

        if ($length == -1) {
            return null;
        }
    }
}
