<?php

namespace Predis\Option;

abstract class AbstractOption implements OptionInterface
{
    /**
     * {@inheritdoc}
     */
    public function filter(ClientOptionsInterface $options, $value)
    {
        return $value;
    }

    /**
     * {@inheritdoc}
     */
    public function getDefault(ClientOptionsInterface $options)
    {
        return null;
    }

    /**
     * {@inheritdoc}
     */
    public function __invoke(ClientOptionsInterface $options, $value)
    {
        if (isset($value)) {
            return $this->filter($options, $value);
        }

        return $this->getDefault($options);
    }
}
