<?php

namespace Predis\Command\Processor;

interface CommandProcessorChainInterface extends CommandProcessorInterface, \IteratorAggregate, \Countable
{
    /**
     * Adds a command processor.
     *
     * @param CommandProcessorInterface $processor A command processor.
     */
    public function add(CommandProcessorInterface $processor);

    /**
     * Removes a command processor from the chain.
     *
     * @param CommandProcessorInterface $processor A command processor.
     */
    public function remove(CommandProcessorInterface $processor);

    /**
     * Returns an ordered list of the command processors in the chain.
     *
     * @return array
     */
    public function getProcessors();
}
