<?php



require 'SharedConfigurations.php';

$client = new Predis\Client($single_server);

$replies = $client->pipeline(function ($pipe) {
    $pipe->ping();
    $pipe->flushdb();
    $pipe->incrby('counter', 10);
    $pipe->incrby('counter', 30);
    $pipe->exists('counter');
    $pipe->get('counter');
    $pipe->mget('does_not_exist', 'counter');
});

print_r($replies);

/* OUTPUT:
Array
(
    [0] => 1
    [1] => 1
    [2] => 10
    [3] => 40
    [4] => 1
    [5] => 40
    [6] => Array
        (
            [0] =>
            [1] => 40
        )

)
*/
