#!/usr/bin/env php
<?php


$options = array(
    'name'           => 'predis',
    'project_path'   => __DIR__ . '/../lib/',
    'compression'    => Phar::NONE,
    'append_version' => true,
);

function getPharFilename($options)
{
    $filename = $options['name'];

    
    if ($options['append_version'] && $options['compression'] === Phar::NONE) {
        $versionFile = @fopen(__DIR__ . '/../VERSION', 'r');

        if ($versionFile === false) {
            throw new Exception("Could not locate the VERSION file.");
        }

        $version = trim(fgets($versionFile));
        fclose($versionFile);
        $filename .= "_$version";
    }

    return "$filename.phar";
}

function getPharStub($options)
{
    return <<<EOSTUB
<?php
Phar::mapPhar('predis.phar');
spl_autoload_register(function (\$class) {
    if (strpos(\$class, 'Predis\\\\') === 0) {
        \$file = 'phar://predis.phar/'.strtr(\$class, '\\\', '/').'.php';
        if (file_exists(\$file)) {
            require \$file;
            return true;
        }
    }
});
__HALT_COMPILER();
EOSTUB;
}

// -------------------------------------------------------------------------- //

$phar = new Phar(getPharFilename($options));
$phar->compress($options['compression']);
$phar->setStub(getPharStub($options));
$phar->buildFromDirectory($options['project_path']);
