<?php
class MobileRequest {
    private $conn;
    function __construct() 
    {
        require_once 'include/dbconnect.php';
        require_once 'include/dbconfig.php';
        // opening db connection
        $db = new DbConnect();
        $this->conn = $db->connect();
    }
	public function addMessage($no,$date,$msg,$lcn_no) 
	{

	 	$query = $this->conn->prepare("SELECT STBNO FROM oc_customer WHERE telephone ='".$no."' ");
	 	// AND STBNO ='".$lcn_no."'"
	    if ($query->execute()) 
        {
        	$query->store_result();
        	$num_rows = $query->num_rows;	
            $query->bind_result($stbno);
            $query->fetch();
        } 
         $query->close();   
         if ($num_rows>0) 
         {
         	   	$records = array();
		 	    $count_exist = 0;  
		 	    $stmt = $this->conn->prepare("SELECT `count`,`current_date` FROM oc_mobile_request_count WHERE mobile_no = '".$no."'");
			    if ($stmt->execute()) 
		        {
		        	$stmt->store_result();
        			$rows = $stmt->num_rows;	
		            $stmt->bind_result($count_exist,$current_date);
		            $stmt->fetch();
		        } 
		       
		        $stmt->close();  
		        if($rows>0)
		        {
		        	$current_date=strtotime(date('Y-m-d',strtotime($current_date)));
		        	$now=strtotime(date('Y-m-d'));
			        if($current_date!=$now)
			        {
			        	$stmt = $this->conn->prepare("UPDATE `oc_mobile_request_count` SET `current_date` = NOW() , `count` = 0 WHERE mobile_no = ?");
					  	$stmt->bind_param("i",$no);
					  	$stmt->execute();
					  	$count_exist=1;
			        }
			    }
				 if($count_exist>50000)		
			     {
			     	return 2;
			     }
			    else if($this->is_NVOD($lcn_no)==0)
			    {
			    	return 4;
			    }
			    else
			    {
			    	$stmt = $this->conn->prepare("INSERT INTO `oc_mobile_request`(`mobile_no`,`date`,`message`) VALUES (?,?,?)");
		 			$stmt->bind_param("iss",$no,$date,$msg);
		    		$stmt->execute();
				    $stmt->store_result();
				    $num_rows = $stmt->affected_rows;
				    if($num_rows == 0)
				    {
				        $records['count']=0;
				        return $records;
		    		}
				    $mass_id = $this->conn->insert_id;   
				    if($count_exist==0)
					{
						$stmt = $this->conn->prepare("INSERT INTO `oc_mobile_request_count`(`mobile_no`,`count`) VALUES (? ,1) ");
						$stmt->bind_param("i",$no);
						$stmt->execute();
					}
					else{
						  $stmt = $this->conn->prepare("UPDATE `oc_mobile_request_count` SET count = (count+1) WHERE mobile_no = ?");
						  $stmt->bind_param("i",$no);
						  $stmt->execute();
					}
					$stmt->close();
				    return 3;
			    }
			
		 }
		else
		{
			return 1;  
		}
	}
	public function callNvodSubscription($lcn_no,$mobile_no)
	{

		
		 require_once 'include/restapi.php';
		 $callapi = new restapi();
		 $expiry_time=strtotime('+1 day' ,time());
         $customer_id = $this->getCustomerId($mobile_no);
         $product_id  = $this->getSMSProductId($lcn_no);
         $api_user_id = $this->getApiUserId($customer_id);
         $api_product_id = $this->getApiProductID($product_id); 
         if($this->getNvodStatus($product_id,$customer_id))
         {
            return 5;
         }
		 $data="user_id=".$api_user_id."&product_id=".$api_product_id."&start_time=".time()."&end_time=".$expiry_time."&is_nvod=1";

		$method ="POST";
 	  	$url=KMS_API."/enableProductSubscription";
 	 	$hdr = array('Content-Type: application/x-www-form-urlencoded','authorization : 78fef98a91761cf1b171451b49289000');
     	$apiresult = $callapi->callAPI($method,$hdr,$url,$data);
		$response=json_decode($apiresult);
		$apimessage='';
		$errorMsg='';
		$error=true;	
		$cmd_id=10;
		foreach ($response as $key => $value) 
		{
			switch ($key) {
			case 'error':
				$error=$value;
				break;
			case 'id':
				$id=$value;
				break;
			case 'mq_response':
				$curlresponse=$value;
				break;
			case 'message':
				$apimessage=$value;
				break;
			default:
				$errorMsg=$key.':'.$value;
				break;
			}
		}
		$expiry_time=date('Y-m-d H:i:s',$expiry_time);
		$ack_is=-1;$nack_is=-1;
		
		if(!$error)
		{
			$resp=0;
			$ack=((strpos($curlresponse,'NACK') !== false)?'NACK':((strpos($curlresponse,'ACK') !== false)?'ACK':'NACK'));
			if($ack=='ACK')
			{
				$resp=1;
				$ack_is=1;
			}elseif($ack=='NACK'){
				$resp=2;
				$nack_is=1;
			}
			$finalExpiryDate =null;
			$payload=$lcn_no;
			$now_datetime = new DateTime("now", new DateTimeZone('Asia/Kolkata'));
			$currentDate =  $now_datetime->getTimestamp(); 						
			$results = $this->addToCasOpTransanction($customer_id,$cmd_id,$product_id,$id,$ack_is,$nack_is,$payload,$expiry_time);
			$this->addToSubscription($customer_id,$product_id);
			// $order_details = $this->getOrderDeatils($customer_id);
			// $this->addOrder($order_details);
			// $DB_subscriptionData = $this->getDBSubscriptionData($product_id, $customer_id);

			// if($DB_subscriptionData)
			// {
			// 	$datetime = new DateTime($DB_subscriptionData['expire_date'], new DateTimeZone('Asia/Calcutta'));
			// 	$DB_expiryDate  = $datetime->getTimestamp(); 						  
			// 	if((int)$DB_subscriptionData['is_cancel']==0){							
			// 		if($DB_expiryDate <= $currentDate){
			// 			$finalExpiryDate =strtotime(" +1 day",$currentDate);
			// 			$this->updateStartAndExpiryDate($DB_subscriptionData['product_id'],$finalExpiryDate,$customer_id);
			// 		}
			// 		elseif($DB_expiryDate > $currentDate){
			// 			$finalExpiryDate =strtotime(" +1 day",$DB_expiryDate);							
			// 			$this->model_sale_order->updateExpiryDate($DB_subscriptionData['product_id'],$finalExpiryDate,$customer_id);
			// 		}
			// 	}else{
			// 		$finalExpiryDate =strtotime(" +1 day",$currentDate);
			// 		$this->updateStartAndExpiryDate($DB_subscriptionData['product_id'],$finalExpiryDate,$customer_id);
			// 	}
			// }
			// $casop_id = $this->addToTransanction($customer_id,$cmd_id,$finalExpiryDate,$id,$ack_is,$nack_is,$product_id,$customer_id,1);
			// var_dump($casop_id);
			return $resp;
		}
		else
		{
		 	return 222;
		}
	}
    
public function addToTransanction($user_id,$cmd_id,$end_time,$product_subscription_id,$ack_is='-1',$nack_is='-1',$product_id,$customer_id,$operator_id)	
{
		$date_obj = new DateTime("now", new DateTimeZone('Asia/Calcutta'));
        $date_obj->setTimestamp($end_time);
        $newDate = $date_obj->format('Y-m-d H:i:s');
		// $newDate=date('Y-m-d H:i:s', $end_time+19800);
			$this->conn->query("INSERT INTO oc_cas_op_transactions SET tx_id='".$product_subscription_id."',cmd_id='".$cmd_id."',product_id='".$product_id."',user_id='".$user_id."',ack_ctr='".$ack_is."',nack_ctr='".$nack_is."',nack_type=-1,exp_date='".$newDate."',initiated_by='Admin',operator_id='".$operator_id."'");
			$casop_id = $this->conn->insert_id;
					
		if($product_subscription_id!=-1){
			$query=$this->conn->query("SELECT count(*) as count FROM oc_sms_kms_subscription WHERE customer_id ='".$user_id."' AND product_id = '".$product_id."'");
			var_dump($query->num_rows);
           if($query->num_rows)
           {
                $qry= $this->conn->query("UPDATE oc_sms_kms_subscription SET kms_product_id='".$product_subscription_id."' WHERE customer_id = '" . $user_id. "' AND product_id = '" .(int)$product_id. "'");
           }else{
				$this->conn->query("INSERT INTO oc_sms_kms_subscription SET customer_id = '" . $customer_id. "', product_id = '" .(int)$product_id. "', 
							is_package = 0,kms_product_id='".$product_subscription_id."'");
			}
		}
		return $casop_id;
	}


    public function updateExpiryDate($product_id,$expiryDate,$customer_id){
		$newDate=date('Y-m-d H:i:s', $expiryDate);
		$query = $this->conn->query("UPDATE oc_subscription SET  is_cancel=0,  expire_date = '" .$newDate. "' WHERE product_id = '" . (int)$product_id. "' AND customer_id = '" .(int)$customer_id. "'");
	}

    public function getDBSubscriptionData($product_id,$customer_id)
    {
    
    	$result = $this->conn->query("SELECT customer_id,product_id,start_date,expire_date,is_cancel FROM oc_subscription WHERE product_id = $product_id AND customer_id=$customer_id");
    	return $result->fetch_assoc();
			
	}

    public function updateStartAndExpiryDate($product_id,$expiryDate,$customer_id){
		$newDate=date('Y-m-d H:i:s', $expiryDate);
		$query = $this->conn->query("UPDATE oc_subscription SET is_cancel=0,  start_date = NOW(), expire_date = '" .$newDate. "' WHERE product_id = '" .(int)$product_id. "' AND customer_id = '" .(int)$customer_id. "'");
	}
	
	public function addToCasOpTransanction($user_id,$cmd_id,$product_id,$tx_id,$ack_is,$nack_is,$payload,$expiry_time) {	
	 	$this->conn->query("INSERT INTO oc_cas_op_transactions SET product_id='".$product_id."',tx_id='".$tx_id."',cmd_id='".$cmd_id."',user_id='".$user_id."',ack_ctr='".$ack_is."',nack_ctr='".$nack_is."',exp_date='".$expiry_time."',nack_type=-1,initiated_by='Admin',payload='".$payload."'");
	}

	public function addToSubscription($user_id,$product_id)	 {	

	 	$now_datetime = new DateTime("now", new DateTimeZone('Asia/Kolkata'));	
	 	$current_date = $now_datetime->format('Y-m-d H:i:s');
	 	$exp_date = $now_datetime->modify('+1 day');
	 	$expire_date = $exp_date->format('Y-m-d H:i:s');
	 	// --------------------------------------------------------------------------------------------------------
		
		$res = $this->conn->query("SELECT `customer_id` FROM oc_subscription WHERE product_id = '" .(int)$product_id. "' AND customer_id = '" .(int)$user_id. "'");
		
		if($res->num_rows > 0)	{		
			$this->conn->query("UPDATE oc_subscription SET is_cancel=0,  start_date = NOW(), expire_date = '" .$expire_date. "' WHERE product_id = '" .(int)$product_id. "' AND customer_id = '" .(int)$user_id. "'");
		}else{		
			$this->conn->query("INSERT INTO oc_subscription SET product_id='".$product_id."',customer_id='".$user_id."',start_date='".$current_date."',expire_date='".$expire_date."'");
		}		
	 	// --------------------------------------------------------------------------------------------------------
	  	
	}

	public function addOrder($order_details){
		

	}

	public function getOrderDeatils($customer_id){
		$res = $this->conn->query("SELECT `zone_id`,`firstname`,`lastname`,`address_1`,`postcode` FROM oc_customer c LEFT JOIN oc_address a ON (c.address_id=a.address_id) WHERE product_id = '" .(int)$product_id. "' AND customer_id = '" .(int)$user_id. "'");
		return $res->row;
	}

	public function getCustomerId($mobile_no)
	{
	 	$query = $this->conn->prepare("SELECT `customer_id` FROM oc_customer WHERE `telephone`=?");
	 	$query->bind_param("i",$mobile_no);
		$query->execute();
		$query->bind_result($customer_id);
		if($query->fetch())
		{
			return $customer_id;	
		}else
		{
			return -1;
		}
		
	}


	public function getApiUserId($customer_id)
	{
	 	$query = $this->conn->prepare("SELECT `api_user_id` FROM oc_sms_kms_map WHERE `user_id`=?");
	 	$query->bind_param("i",$customer_id);
		$query->execute();
		$query->bind_result($api_user_id);
		if($query->fetch())
		{
			return $api_user_id;	
		}else
		{
			return -1;
		}
		
	}
    
    public function getSMSProductId($lcn_no)
    {
        $query = $this->conn->prepare("SELECT `product_id` FROM oc_product WHERE `lcn`=?");
	 	$query->bind_param("i",$lcn_no);
		$query->execute();
		$query->bind_result($product_id);
		if($query->fetch())
		{
			return $product_id;	
		}
		else
		{
			return 0;
		}
		
    }
   
   public function getApiProductID($product_id)
   {
   	  $query = $this->conn->prepare("SELECT `api_product_id` FROM oc_sms_kms_product WHERE `product_id`=?");
	 	$query->bind_param("i",$product_id);
		$query->execute();
		$query->bind_result($api_product_id);
		if($query->fetch())
		{
			return $api_product_id;	
		}
		else
		{
			return 0;
		}
   }
	public function is_NVOD($lcn_no)
	{
	 	$query = $this->conn->prepare("SELECT `is_nvod` FROM oc_product WHERE `lcn`=?");
	 	$query->bind_param("i",$lcn_no);
		$query->execute();
		$query->bind_result($is_nvod);
		if($query->fetch())
		{
			return $is_nvod;	
		}
		else
		{
			return 0;
		}
		
	}
public function getNvodStatus($product_id,$customer_id) 
{
    	$now_datetime = new DateTime("now", new DateTimeZone('Asia/Kolkata'));		
		$current_date = (array)$now_datetime;
		$query = $this->conn->prepare("SELECT * FROM oc_subscription s WHERE s.product_id=$product_id AND s.customer_id=$customer_id AND is_cancel = 0 AND s.expire_date >='".$current_date['date']."'");
		 if ($query->execute()) 
        {
        	$query->store_result();
        	$num_rows = $query->num_rows;	
            // $query->bind_result($stbno);
            $query->fetch();
            return $num_rows;
        } 
        else
        {
        	return 0;
        }		
}
}
if(isset($_GET['who']))
{
	$mobile_no = $_GET['who'];
	$msg = $_GET['what'];
	// $operator = $_GET['operator'];
	// $circle = $_GET['circle'];
	$datetime =  date("Y-m-d H:i:s", strtotime($_GET['time']));

	$keyword=trim(substr($msg,0,strpos($msg,' ')));
	$sub_str=trim(substr($msg,strpos($msg,' ')+1)).' ';
	$lcn_no=trim(substr($sub_str,0,strpos($sub_str,' ')));

	$obj=new MobileRequest();
 	$response= $obj->addMessage($mobile_no,$datetime,$msg,$lcn_no);

	if($response==1)
	{
		$message ='Dear customer, This mobile number is not Register...!!!';
	}
	else if($response==2)
	{
		$message ='Dear customer, You have exceeded limit of activation from this mobile number...!!!';
	}
	else if($response==4)
	{
		$message ='Dear customer, You can subscribe only NVOD service...!!!';
	}
	else if($response == 3)
	{
 		if(strpos($keyword,'SUBLCN')!==false)
 		{
 			$resp= $obj->callNvodSubscription($lcn_no,$mobile_no);
			if($resp==1)
			{
				$message ='Dear customer,Your request for NVOD has been confirmed...!!!';
			}else if($resp==2){
				$message ='Dear customer,Your request for NVOD is pending...!!!';
			}else if($resp == 5)
			{
				$message ='Dear customer, You have already subscribed for this NVOD...!!!';
			}
			else if($resp == 3)
			{
				$message ='Dear customer, You have already subscribed for this NVOD...!!!';
			}
			else
			{
				$message ='Sorry ! Error while processing your request...!!!'.$resp;
			}
					//$message = "Dear customer,Your request for STB activation has been confirmed,Our operator will call you shortly!";
 		}
 		else
 		{
 			$message = "Dear customer, You have entered wrong keyword, Please try again with correct keyword 'DDTH'!";
 		}
 	}
 	else
 	{
 		$message ='Sorry ! Error while processing your request...!!!';
 	}
 	echo $message;
}
else
{
	echo 'Mobile no Missing 1';
}


?>