<?php
/*
@File low_order_fee.php(MODEL)
TOTAL:	 low_order_fee PAGE
    Manages the 

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ModelTotalLowOrderFee extends Model {
/*
FUNCTION NAME 		-	getTotal
DESCRIPTION 		-	
INPUT PARAMETER 	-	
OUTPUT PARAMETER 	- 	
*/	
	public function getTotal(&$total_data, &$total, &$taxes) {
		if ($this->cart->getSubTotal() && ($this->cart->getSubTotal() < $this->config->get('low_order_fee_total'))) {
			$this->language->load('total/low_order_fee');
		 	
			$total_data[] = array( 
				'code'       => 'low_order_fee',
        		'title'      => $this->language->get('text_low_order_fee'),
        		'text'       => $this->currency->format($this->config->get('low_order_fee_fee')),
        		'value'      => $this->config->get('low_order_fee_fee'),
				'sort_order' => $this->config->get('low_order_fee_sort_order')
			);
			
			if ($this->config->get('low_order_fee_tax_class_id')) {
				$tax_rates = $this->tax->getRates($this->config->get('low_order_fee_fee'), $this->config->get('low_order_fee_tax_class_id'));
				
				foreach ($tax_rates as $tax_rate) {
					if (!isset($taxes[$tax_rate['tax_rate_id']])) {
						$taxes[$tax_rate['tax_rate_id']] = $tax_rate['amount'];
					} else {
						$taxes[$tax_rate['tax_rate_id']] += $tax_rate['amount'];
					}
				}
			}
			
			$total += $this->config->get('low_order_fee_fee');
		}
	}
}
?>