<?php
/*
@File zone.php(MODEL)
LOCALISATION:	ZONE PAGE
    Manages the zone for the location purpose. 

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ModelLocalisationZone extends Model {
/*
FUNCTION NAME 		-	getZone
DESCRIPTION 		-	Retrieve the zone detail based on the zone_id given
INPUT PARAMETER 	-	zone_id
OUTPUT PARAMETER 	- 	Returns the selected row contianing the zone description
*/	
	public function getZone($zone_id) {
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "zone WHERE zone_id = '" . (int)$zone_id . "' AND status = '1'");
		
		return $query->row;
	}		
/*
FUNCTION NAME 		-	getZoneByCountryId
DESCRIPTION 		-	Retrieves all the zone for the particular country_id.
INPUT PARAMETER 	-	country_id
OUTPUT PARAMETER 	- 	Returns an array containing all the retrieved rows with the zone description
*/	
	public function getZonesByCountryId($country_id) {
		$zone_data = $this->cache->get('zone.' . (int)$country_id);
	
		if (!$zone_data) {
			$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "zone WHERE country_id = '" . (int)$country_id . "' AND status = '1' ORDER BY name");
	
			$zone_data = $query->rows;
			
			$this->cache->set('zone.' . (int)$country_id, $zone_data);
		}
	
		return $zone_data;
	}
}
?>