<?php
/*
@File language.php(MODEL)
LOCALISATION:	 LANGUAGE PAGE
    Manages all the languages associated with the store by retrieving its details

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ModelLocalisationLanguage extends Model {
/*
FUNCTION NAME 		-	getLanguage
DESCRIPTION 		-	Retrieve a row containing language detail based on the given language id
INPUT PARAMETER 	-	language_id
OUTPUT PARAMETER 	- 	Returns the selected row for the language id
*/	
	public function getLanguage($language_id) {
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "language WHERE language_id = '" . (int)$language_id . "'");
		
		return $query->row;	
	}
/*
FUNCTION NAME 		-	getLanguages
DESCRIPTION 		-	Retrieves all the languages stored in the database for the store
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns an array conatining all the rows retrieved by the query for all the language
*/
	public function getLanguages() {
		$language_data = $this->cache->get('language');
		
		if (!$language_data) {		
			$language_data = array();
			
			$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "language ORDER BY sort_order, name");
		
    		foreach ($query->rows as $result) {
      			$language_data[$result['code']] = array(
        			'language_id' => $result['language_id'],
        			'name'        => $result['name'],
        			'code'        => $result['code'],
					'locale'      => $result['locale'],
					'image'       => $result['image'],
					'directory'   => $result['directory'],
					'filename'    => $result['filename'],
					'sort_order'  => $result['sort_order'],
					'status'      => $result['status']
      			);
    		}	
			
			$this->cache->set('language', $language_data);
		}
		
		return $language_data;	
	}
}
?>