<?php
/*
@File currency.php(MODEL)
LOCALISATION:	 CURRENCY PAGE
    Manages the currency associated with the store products.

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ModelLocalisationCurrency extends Model {
/*
FUNCTION NAME 		-	getCurrencyByCode
DESCRIPTION 		-	Retrieve the currency details based on the currency code given.
INPUT PARAMETER 	-	currency code
OUTPUT PARAMETER 	- 	Returns a row containing the selected currency information
*/	
	public function getCurrencyByCode($currency) {
		$query = $this->db->query("SELECT DISTINCT * FROM " . DB_PREFIX . "currency WHERE code = '" . $this->db->escape($currency) . "'");
	
		return $query->row;
	}
/*
FUNCTION NAME 		-	getCurrencies
DESCRIPTION 		-	Retrieve all the currency details from the database.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns an array containing the currency details stored in the database.
*/	
	public function getCurrencies() {
		$currency_data = $this->cache->get('currency');

		if (!$currency_data) {
			$currency_data = array();
			
			$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "currency ORDER BY title ASC");
	
			foreach ($query->rows as $result) {
      			$currency_data[$result['code']] = array(
        			'currency_id'   => $result['currency_id'],
        			'title'         => $result['title'],
        			'code'          => $result['code'],
					'symbol_left'   => $result['symbol_left'],
					'symbol_right'  => $result['symbol_right'],
					'decimal_place' => $result['decimal_place'],
					'value'         => $result['value'],
					'status'        => $result['status'],
					'date_modified' => $result['date_modified']
      			);
    		}	
			
			$this->cache->set('currency', $currency_data);
		}
			
		return $currency_data;	
	}	
}
?>