<?php
/*
@File information.php(MODEL)
CATALOG:	 INFORMATION PAGE
    Manages the information by retrieving it from the database

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ModelCatalogInformation extends Model {
/*
FUNCTION NAME 		-	getInformation
DESCRIPTION 		-	Retrieves the information details based on the given information_id from the database.
INPUT PARAMETER 	-	information_id
OUTPUT PARAMETER 	- 	Retruns a row containing the details for the information_id.
*/
	public function getInformation($information_id) {
		$query = $this->db->query("SELECT DISTINCT * FROM " . DB_PREFIX . "information i LEFT JOIN " . DB_PREFIX . "information_description id ON (i.information_id = id.information_id) LEFT JOIN " . DB_PREFIX . "information_to_store i2s ON (i.information_id = i2s.information_id) WHERE i.information_id = '" . (int)$information_id . "' AND id.language_id = '" . (int)$this->config->get('config_language_id') . "' AND i2s.store_id = '" . (int)$this->config->get('config_store_id') . "' AND i.status = '1'");
	
		return $query->row;
	}
/*
FUNCTION NAME 		-	getInformations
DESCRIPTION 		-	Retrieves all the information details from the dabatabase
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns all the rows retrieved by the query
*/	
	public function getInformations() {
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "information i LEFT JOIN " . DB_PREFIX . "information_description id ON (i.information_id = id.information_id) LEFT JOIN " . DB_PREFIX . "information_to_store i2s ON (i.information_id = i2s.information_id) WHERE id.language_id = '" . (int)$this->config->get('config_language_id') . "' AND i2s.store_id = '" . (int)$this->config->get('config_store_id') . "' AND i.status = '1' ORDER BY i.sort_order, LCASE(id.title) ASC");
		
		return $query->rows;
	}
/*
FUNCTION NAME 		-	getInformationLayoutId
DESCRIPTION 		-	Retrieves the layout_id for the given information_id
INPUT PARAMETER 	-	information_id
OUTPUT PARAMETER 	- 	Returns the layout_id if the query retrieves any row else returns the default layout
*/	
	public function getInformationLayoutId($information_id) {
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "information_to_layout WHERE information_id = '" . (int)$information_id . "' AND store_id = '" . (int)$this->config->get('config_store_id') . "'");
		 
		if ($query->num_rows) {
			return $query->row['layout_id'];
		} else {
			return $this->config->get('config_layout_information');
		}
	}	
}
?>