<?php
/*
@File transaction.php(MODEL)
CUSTOMER:	 TRANSACTION PAGE
    Manages the transactions made by the customer aginst their orders.

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ModelAccountTransaction extends Model {	
/*
FUNCTION NAME 		-	getTransactions
DESCRIPTION 		-	Retrieves all the transaction for the current cutomer
INPUT PARAMETER 	-	data array containing filter options if any.
OUTPUT PARAMETER 	- 	Returns all the rows retrieved by the query containing the transaction detail of the current customer.
*/	
	public function getTransactions($data = array()) {
		$sql = "SELECT * FROM `" . DB_PREFIX . "customer_transaction` WHERE customer_id = '" . (int)$this->customer->getId() . "'";
		   
		$sort_data = array(
			'amount',
			'description',
			'date_added'
		);
	
		if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
			$sql .= " ORDER BY " . $data['sort'];	
		} else {
			$sql .= " ORDER BY date_added";	
		}
			
		if (isset($data['order']) && ($data['order'] == 'DESC')) {
			$sql .= " DESC";
		} else {
			$sql .= " ASC";
		}
		
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}			

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}	
			
			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}

		$query = $this->db->query($sql);
	
		return $query->rows;
	}	
/*
FUNCTION NAME 		-	getTotalTransactions
DESCRIPTION 		-	Retrieves all the rows from the customer_tansaction table for the current cutomer.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns a column of the row retrieved which contains the total no. to rows retrieved by the query.
*/		
	public function getTotalTransactions() {
      	$query = $this->db->query("SELECT COUNT(*) AS total FROM `" . DB_PREFIX . "customer_transaction` WHERE customer_id = '" . (int)$this->customer->getId() . "'");
			
		return $query->row['total'];
	}	
/*
FUNCTION NAME 		-	getTotalAmount
DESCRIPTION 		-	Retrieves amount of all the transactions made by the customer and adds them to a variable.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns a column 'total' of the row retrieved which contains the sum of all amounts or returns 0 is none selected.
*/			
	public function getTotalAmount() {
		$query = $this->db->query("SELECT SUM(amount) AS total FROM `" . DB_PREFIX . "customer_transaction` WHERE customer_id = '" . (int)$this->customer->getId() . "' GROUP BY customer_id");
		
		if ($query->num_rows) {
			return $query->row['total'];
		} else {
			return 0;	
		}
	}
}
?>