<?php
/*
@File reward.php(MODEL)
CUSTOMER:	 REWARD PAGE
    Add & Retrieve the rewards based on the conditions given.

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ModelAccountReward extends Model {	
/*
FUNCTION NAME 		-	getRewards
DESCRIPTION 		-	Retrieves the reward associated with the current customer based on the details given as an input.
INPUT PARAMETER 	-	data array containg filters is any
OUTPUT PARAMETER 	- 	Returns all the rows retrieved by the query
*/	
	public function getRewards($data = array()) {
		$sql = "SELECT * FROM `" . DB_PREFIX . "customer_reward` WHERE customer_id = '" . (int)$this->customer->getId() . "'";
		   
		$sort_data = array(
			'points',
			'description',
			'date_added'
		);
	
		if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
			$sql .= " ORDER BY " . $data['sort'];	
		} else {
			$sql .= " ORDER BY date_added";	
		}
			
		if (isset($data['order']) && ($data['order'] == 'DESC')) {
			$sql .= " DESC";
		} else {
			$sql .= " ASC";
		}
		
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}			

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}	
			
			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}

		$query = $this->db->query($sql);
	
		return $query->rows;
	}	
/*
FUNCTION NAME 		-	getTotalRewards
DESCRIPTION 		-	Counts the total number of rewards for the current customer and returns a row conating its count.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns a column of the row retrieved which contains the total no. to rows retrieved by the query.
*/		
	public function getTotalRewards() {
      	$query = $this->db->query("SELECT COUNT(*) AS total FROM `" . DB_PREFIX . "customer_reward` WHERE customer_id = '" . (int)$this->customer->getId() . "'");
			
		return $query->row['total'];
	}	
/*
FUNCTION NAME 		-	getTotalPoints
DESCRIPTION 		-	Counts the total number of points for the current customer and returns a row conating its sum.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns a column of the row retrieved which contains the total no. to rows retrieved by the query or returns 0 
						if none row retrieved.
*/			
	public function getTotalPoints() {
		$query = $this->db->query("SELECT SUM(points) AS total FROM `" . DB_PREFIX . "customer_reward` WHERE customer_id = '" . (int)$this->customer->getId() . "' GROUP BY customer_id");
		
		if ($query->num_rows) {
			return $query->row['total'];
		} else {
			return 0;	
		}
	}
}
?>