<?php
/*
@File download.php(MODEL)
CUSTOMER:	 DOWNLOAD PAGE
    Manages the download for the orders by retrieving and updating.

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ModelAccountDownload extends Model {

/*
FUNCTION NAME 		-	getDownload
DESCRIPTION 		-	Retrieves the download information for the given order_download_id
INPUT PARAMETER 	-	order_download_id
OUTPUT PARAMETER 	- 	Returns a row containing the information of the download.
*/
	public function getDownload($order_download_id) {
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "order_download od LEFT JOIN `" . DB_PREFIX . "order` o ON (od.order_id = o.order_id) WHERE o.customer_id = '" . (int)$this->customer->getId(). "' AND o.order_status_id > '0' AND o.order_status_id = '" . (int)$this->config->get('config_complete_status_id') . "' AND od.order_download_id = '" . (int)$order_download_id . "' AND od.remaining > 0");
		 
		return $query->row;
	}
/*
FUNCTION NAME 		-	getDownloads
DESCRIPTION 		-	Retrieves all the download information from the database. 
INPUT PARAMETER 	-	Start and limit value for the number of rows to retrieve 
OUTPUT PARAMETER 	- 	Returns all rows containg the detials of the downloads
*/	
	public function getDownloads($start = 0, $limit = 20) {
		if ($start < 0) {
			$start = 0;
		}
		
		if ($limit < 1) {
			$limit = 20;
		}	
		
		$query = $this->db->query("SELECT o.order_id, o.date_added, od.order_download_id, od.name, od.filename, od.remaining FROM " . DB_PREFIX . "order_download od LEFT JOIN `" . DB_PREFIX . "order` o ON (od.order_id = o.order_id) WHERE o.customer_id = '" . (int)$this->customer->getId() . "' AND o.order_status_id > '0' AND o.order_status_id = '" . (int)$this->config->get('config_complete_status_id') . "' AND od.remaining > 0 ORDER BY o.date_added DESC LIMIT " . (int)$start . "," . (int)$limit);
	
		return $query->rows;
	}
/*
FUNCTION NAME 		-	updateRemaining
DESCRIPTION 		-	Updates the order download information for the given order_download_id
INPUT PARAMETER 	-	order_download_id
OUTPUT PARAMETER 	- 	void
*/	
	public function updateRemaining($order_download_id) {
		$this->db->query("UPDATE " . DB_PREFIX . "order_download SET remaining = (remaining - 1) WHERE order_download_id = '" . (int)$order_download_id . "'");
	}
/*
FUNCTION NAME 		-	getTotalDownloads
DESCRIPTION 		-	Retrieve a row containing total as a column containing number of rows retrieved from the query
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns a column total for a retrieved row 
*/	
	public function getTotalDownloads() {
		$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "order_download od LEFT JOIN `" . DB_PREFIX . "order` o ON (od.order_id = o.order_id) WHERE o.customer_id = '" . (int)$this->customer->getId() . "' AND o.order_status_id > '0' AND o.order_status_id = '" . (int)$this->config->get('config_complete_status_id') . "' AND od.remaining > 0");
		
		return $query->row['total'];
	}	
}
?>
