<?php  
/*
@File information.php(Controller/module)
INFORMATION PAGE
    This class load the information regarding the store. This is part of the footer. 
    Appears as a link in footer and based on the selection it shows the store information/privary details.

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ControllerModuleInformation extends Controller {
/*
FUNCTION NAME 		-	index
DESCRIPTION 		-	Load the page with the information detail based on the information id.
						This module is a part of footer where it gets loaded.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	selected Information message 
*/	
	protected function index() {
//Loads language for information		
		$this->language->load('module/information');
//Assign page variable		
    	$this->data['heading_title'] = $this->language->get('heading_title');
    	
		$this->data['text_contact'] = $this->language->get('text_contact');
    	$this->data['text_sitemap'] = $this->language->get('text_sitemap');
//Loads model for information		
		$this->load->model('catalog/information');
		
		$this->data['informations'] = array();
//Retrieving information from the database for different information ids
		foreach ($this->model_catalog_information->getInformations() as $result) {
      		$this->data['informations'][] = array(
        		'title' => $result['title'],
	    		'href'  => $this->url->link('information/information', 'information_id=' . $result['information_id'])
      		);
    	}
//Assign links to different variables
		$this->data['contact'] = $this->url->link('information/contact');
    	$this->data['sitemap'] = $this->url->link('information/sitemap');
/*Check if the template file other than the default theme for the information exists or not. 
	If yes, get the template file for the new theme configured.
	else load the default theme template for the information
*/		
		if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/module/information.tpl')) {
			$this->template = $this->config->get('config_template') . '/template/module/information.tpl';
		} else {
			$this->template = 'default/template/module/information.tpl';
		}
		
		$this->render();
	}
}
?>