<?php  
/*
@File category.php(Controller/module)
CATEGORY PAGE
    This class retrieves category and assign its details to an array for the 
    selected category id.

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/ 
class ControllerModuleCategory extends Controller {
/*
FUNCTION NAME 		-	index
DESCRIPTION 		-	category's detail + all the channels in the category are retrieved
						for the selected category
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Category name and all its child(channels).
*/	
	protected function index($setting) {
//Loads language for category		
		$this->language->load('module/category');
		
    	$this->data['heading_title'] = $this->language->get('heading_title');
//Exploding the path variable from the url		
		if (isset($this->request->get['path'])) {
			$parts = explode('_', (string)$this->request->get['path']);
		} else {
			$parts = array();
		}
//Checking is the category id is set		
		if (isset($parts[0])) {
			$this->data['category_id'] = $parts[0];
		} else {
			$this->data['category_id'] = 0;
		}
//Checking is the child id(channel id in the selected category) is set		
		if (isset($parts[1])) {
			$this->data['child_id'] = $parts[1];
		} else {
			$this->data['child_id'] = 0;
		}
//Loading model for category and product							
		$this->load->model('catalog/category');

		$this->load->model('catalog/product');

		$this->data['categories'] = array();
//Retrieving default category
		$categories = $this->model_catalog_category->getCategories(0);

		foreach ($categories as $category) {
			$total = $this->model_catalog_product->getTotalProducts(array('filter_category_id' => $category['category_id']));

			$children_data = array();
//Retrievig channels of the selected categoryid.
			$children = $this->model_catalog_category->getCategories($category['category_id']);
//Treversing each channel in the category
			foreach ($children as $child) {
				$data = array(
					'filter_category_id'  => $child['category_id'],
					'filter_sub_category' => true
				);

				$product_total = $this->model_catalog_product->getTotalProducts($data);

				$total += $product_total;
//Assigning channel information to an array
				$children_data[] = array(
					'category_id' => $child['category_id'],
					'name'        => $child['name'] . ($this->config->get('config_product_count') ? ' (' . $product_total . ')' : ''),
					'href'        => $this->url->link('product/category', 'path=' . $category['category_id'] . '_' . $child['category_id'])	
				);		
			}
//Assigning category information to an array
			$this->data['categories'][] = array(
				'category_id' => $category['category_id'],
				'name'        => $category['name'] . ($this->config->get('config_product_count') ? ' (' . $total . ')' : ''),
				'children'    => $children_data,
				'href'        => $this->url->link('product/category', 'path=' . $category['category_id'])
			);	
		}
/*Check if the template file other than the default theme for the category exists or not. 
	If yes, get the template file for the new theme configured.
	else load the default theme template for the category
*/		
		if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/module/category.tpl')) {
			$this->template = $this->config->get('config_template') . '/template/module/category.tpl';
		} else {
			$this->template = 'default/template/module/category.tpl';
		}
		
		$this->render();
  	}
}
?>