<?php
/*
@File login.php(Controller)
LOGIN PAGE
    Loads the login page if the guest is checking out the order without login. 

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ControllerCommonMaintenance extends Controller {
/*
FUNCTION NAME 		-	index
DESCRIPTION 		-	
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	
*/	
    public function index() {
        if ($this->config->get('config_maintenance')) {
			$route = '';
			
			if (isset($this->request->get['route'])) {
				$part = explode('/', $this->request->get['route']);
				
				if (isset($part[0])) {
					$route .= $part[0];
				}			
			}
			
// Show site if logged in as admin
			$this->load->library('user');
			
			$this->user = new User($this->registry);
	
			if (($route != 'payment') && !$this->user->isLogged()) {
				return $this->forward('common/maintenance/info');
			}						
        }
    }
/*
FUNCTION NAME 		-	info
DESCRIPTION 		-	Loads the page with the information of the maintenance.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Maintenance message
*/ 		
	public function info() {
//Loads the language for maintenance
        $this->language->load('common/maintenance');
        
        $this->document->setTitle($this->language->get('heading_title'));
        
        $this->data['heading_title'] = $this->language->get('heading_title');
//Short-hand links to path as breadcrumbs                
        $this->document->breadcrumbs = array();

        $this->document->breadcrumbs[] = array(
            'text'      => $this->language->get('text_maintenance'),
			'href'      => $this->url->link('common/maintenance'),
            'separator' => false
        ); 
//maintenance message        
        $this->data['message'] = $this->language->get('text_message');
/*Check if the template file other than the default theme for the maintenance exists or not. 
	If yes, get the template file for the new theme configured.
	else load the default theme template for the maintenance
*/      
		if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/common/maintenance.tpl')) {
            $this->template = $this->config->get('config_template') . '/template/common/maintenance.tpl';
        } else {
            $this->template = 'default/template/common/maintenance.tpl';
        }
		
		$this->children = array(
			'common/footer',
			'common/header'
		);
		
		$this->response->setOutput($this->render());
    }
}
?>