<?php 
/*
@File home.php(Controller)
HOME PAGE
    This is the class that is triggered first of all and all the 
    basic information is rendered.

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/ 
class ControllerCommonHome extends Controller {
/*
FUNCTION NAME 		-	index
DESCRIPTION 		-	This function loads the home template with basic details
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	home page
*/	
	public function index() {
		$this->document->setTitle($this->config->get('config_title'));
		$this->document->setDescription($this->config->get('config_meta_description'));

		$this->data['heading_title'] = $this->config->get('config_title');
/*Check if the template file other than the default theme for the home exists or not. 
	If yes, get the template file for the new theme configured.
	else load the default theme template for the home
*/		
		if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/common/home.tpl')) {
			$this->template = $this->config->get('config_template') . '/template/common/home.tpl';
		} else {
			$this->template = 'default/template/common/home.tpl';
		}
		
		$this->children = array(
			'common/column_left',
			'common/column_right',
			'common/content_top',
			'common/content_bottom',
			'common/footer',
			'common/header'
		);
										
		$this->response->setOutput($this->render());
	}
}
?>