<?php   
/*
@File header.php(Controller)
HEADER PAGE
    Manages the header of the page which includes cart, login , currency, language and search option

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/ 
class ControllerCommonHeader extends Controller {
/*
FUNCTION NAME 		-	index
DESCRIPTION 		-	Loads the login form and registration link to login at the time
						of checkout.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Login form
*/		
	protected function index() {
		$this->data['title'] = $this->document->getTitle();
//Checks for the request from server. If not configure the url.		
		if (isset($this->request->server['HTTPS']) && (($this->request->server['HTTPS'] == 'on') || ($this->request->server['HTTPS'] == '1'))) {
			$server = $this->config->get('config_ssl');
		} else {
			$server = $this->config->get('config_url');
		}
//Assigning different variables
		$this->data['base'] = $server;
		$this->data['description'] = $this->document->getDescription();
		$this->data['keywords'] = $this->document->getKeywords();
		$this->data['links'] = $this->document->getLinks();	 
		$this->data['styles'] = $this->document->getStyles();
		$this->data['scripts'] = $this->document->getScripts();
		$this->data['lang'] = $this->language->get('code');
		$this->data['direction'] = $this->language->get('direction');
		$this->data['google_analytics'] = html_entity_decode($this->config->get('config_google_analytics'), ENT_QUOTES, 'UTF-8');
		$this->data['name'] = $this->config->get('config_name');
//Assigning icon .		
		if ($this->config->get('config_icon') && file_exists(DIR_IMAGE . $this->config->get('config_icon'))) {
			$this->data['icon'] = $server . 'image/' . $this->config->get('config_icon');
		} else {
			$this->data['icon'] = '';
		}
//Assigning logo		
		if ($this->config->get('config_logo') && file_exists(DIR_IMAGE . $this->config->get('config_logo'))) {
			$this->data['logo'] = $server . 'image/' . $this->config->get('config_logo');
		} else {
			$this->data['logo'] = '';
		}		
		
		$this->language->load('common/header');
//Assigning page variables		
		$this->data['text_home'] = $this->language->get('text_home');
		$this->data['text_wishlist'] = sprintf($this->language->get('text_wishlist'), (isset($this->session->data['wishlist']) ? count($this->session->data['wishlist']) : 0));
		$this->data['text_shopping_cart'] = $this->language->get('text_shopping_cart');
    	$this->data['text_search'] = $this->language->get('text_search');
		$this->data['text_welcome'] = sprintf($this->language->get('text_welcome'), $this->url->link('account/login', '', 'SSL'), $this->url->link('account/register', '', 'SSL'));
		$this->data['text_logged'] = sprintf($this->language->get('text_logged'), $this->url->link('account/account', '', 'SSL'), $this->customer->getFirstName(), $this->url->link('account/logout', '', 'SSL'));
		$this->data['text_account'] = $this->language->get('text_account');
    	$this->data['text_checkout'] = $this->language->get('text_checkout');
				
		$this->data['home'] = $this->url->link('common/home');
		$this->data['wishlist'] = $this->url->link('account/wishlist', '', 'SSL');
		$this->data['logged'] = $this->customer->isLogged();
		$this->data['account'] = $this->url->link('account/account', '', 'SSL');
		$this->data['shopping_cart'] = $this->url->link('checkout/cart');
		$this->data['checkout'] = $this->url->link('checkout/checkout', '', 'SSL');
		
// Daniel's robot detector
		$status = true;
		
		if (isset($this->request->server['HTTP_USER_AGENT'])) {
			$robots = explode("\n", trim($this->config->get('config_robots')));

			foreach ($robots as $robot) {
				if (strpos($this->request->server['HTTP_USER_AGENT'], trim($robot)) !== false) {
					$status = false;

					break;
				}
			}
		}
		
// A dirty hack to try to set a cookie for the multi-store feature
		$this->load->model('setting/store');
		
		$this->data['stores'] = array();
		
		if ($this->config->get('config_shared') && $status) {
			$this->data['stores'][] = $server . 'catalog/view/javascript/crossdomain.php?session_id=' . $this->session->getId();
			
			$stores = $this->model_setting_store->getStores();
					
			foreach ($stores as $store) {
				$this->data['stores'][] = $store['url'] . 'catalog/view/javascript/crossdomain.php?session_id=' . $this->session->getId();
			}
		}
				
// Search		
		if (isset($this->request->get['search'])) {
			$this->data['search'] = $this->request->get['search'];
		} else {
			$this->data['search'] = '';
		}
		
// Menu
		$this->load->model('catalog/category');
		
		$this->load->model('catalog/product');
		// $this->load->model('catalog/ppv');
		
		$this->data['categories'] = array();
		
//Retrieving default category					
		$categories = $this->model_catalog_category->getCategories(0);
		
		foreach ($categories as $category) {
			if ($category['top']) {
// Level 2-Category childrens retrieval
				$children_data = array();
//Retrieving channels in a particular category with id				
				$children = $this->model_catalog_category->getCategories($category['category_id']);
				
				foreach ($children as $child) {
					$data = array(
						'filter_category_id'  => $child['category_id'],
						'filter_sub_category' => true
					);
					
                    $this->data['packages'] = array();
//Retrieving enabled packages                    
					$results = $this->model_catalog_product->getPackagesEnabledHeader();
//Assigning package details and assigning to an array
					foreach($results as $result)
					{
						$this->data['packages'][] = array(
					          'name' => $result['name'],
					          'id'   => $result['product_id'],
					          'href'    	 => $this->url->link('product/product', 'product_id=' . $result['product_id'])
							);
					}

					$product_total = $this->model_catalog_product->getTotalProducts($data);
									
					$children_data[] = array(
						'name'  => $child['name'] . ($this->config->get('config_product_count') ? ' (' . $product_total . ')' : ''),
						'href'  => $this->url->link('product/category', 'path=' . $category['category_id'] . '_' . $child['category_id'])
					);						
				}
				
// Level 1- Category name and links
				$this->data['categories'][] = array(
					'name'     => $category['name'],
					'children' => $children_data,
					'column'   => $category['column'] ? $category['column'] : 1,
					'href'     => $this->url->link('product/category', 'path=' . $category['category_id'])
				);

				$this->data['packages_home'] = array(
					          'name' 		=> 'Packages',
					          'href'    	=> $this->url->link('product/packages_home', 'path=' . $category['category_id'])
							);
				$this->data['ppv_home'] = array(
					          'name' 		=> 'Packages',
					          'href'    	=> $this->url->link('product/ppv_home', 'path=' . $category['category_id'])
							);
			}
		}
		//-------------
				$this->data['ppvs'] = array();
				$ppv_results = $this->model_catalog_product->getPpvEnabled();
				
				foreach($ppv_results as $ppv_result)
					{
						$this->data['ppvs'][] = array(
					          'name' => $ppv_result['name'],
					          'id'   => $ppv_result['product_id'],
					          'href' => $this->url->link('product/product', 'product_id=' . $ppv_result['product_id'])
							);
					}
		//-------------
		
		$this->children = array(
			'module/language',
			'module/currency',
			'module/cart'
		);
/*Check if the template file other than the default theme for the header exists or not. 
	If yes, get the template file for the new theme configured.
	else load the default theme template for the header
*/				
		if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/common/header.tpl')) {
			$this->template = $this->config->get('config_template') . '/template/common/header.tpl';
		} else {
			$this->template = 'default/template/common/header.tpl';
		}
		
    	$this->render();
	} 	
}
?>