<?php 
/*
@File column_bottom.php(Controller)
COLUMN_BOTTOM PAGE
    The channels/packages content page is divided into left, right, top and bottom. 
    This class manages the bottom side of it and loads the module that is requested.  

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/  
class ControllerCommonContentBottom extends Controller {
/*
FUNCTION NAME 		-	index
DESCRIPTION 		-	Loads the module requested by the page
						
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	render the module to display
*/	
	protected function index() {
//Loads model for layout, category, product and information			
		$this->load->model('design/layout');
		$this->load->model('catalog/category');
		$this->load->model('catalog/product');
		$this->load->model('catalog/information');
//if route is not set, redirect to home page.			
		if (isset($this->request->get['route'])) {
			$route = (string)$this->request->get['route'];
		} else {
			$route = 'common/home';
		}
		
		$layout_id = 0;
//if route requested is for category and path is set. Assign the layout_id as requested.		
		if ($route == 'product/category' && isset($this->request->get['path'])) {
			$path = explode('_', (string)$this->request->get['path']);
				
			$layout_id = $this->model_catalog_category->getCategoryLayoutId(end($path));			
		}
//if route requested is for product and product_id is set. Assign the layout_id as requested.		
		if ($route == 'product/product' && isset($this->request->get['product_id'])) {
			$layout_id = $this->model_catalog_product->getProductLayoutId($this->request->get['product_id']);
		}
//if route requested is for information and information_id is set. Assign the layout_id as requested.		
		if ($route == 'information/information' && isset($this->request->get['information_id'])) {
			$layout_id = $this->model_catalog_information->getInformationLayoutId($this->request->get['information_id']);
		}
		
		if (!$layout_id) {
			$layout_id = $this->model_design_layout->getLayout($route);
		}
						
		if (!$layout_id) {
			$layout_id = $this->config->get('config_layout_id');
		}

		$module_data = array();
		
		$this->load->model('setting/extension');
//Retrieving the extention for module		
		$extensions = $this->model_setting_extension->getExtensions('module');		
//Traversing each extension for for the details			
		foreach ($extensions as $extension) {
			$modules = $this->config->get($extension['code'] . '_module');
			
			if ($modules) {
				foreach ($modules as $module) {
					if ($module['layout_id'] == $layout_id && $module['position'] == 'content_bottom' && $module['status']) {
						$module_data[] = array(
							'code'       => $extension['code'],
							'setting'    => $module,
							'sort_order' => $module['sort_order']
						);				
					}
				}
			}
		}
		
		$sort_order = array(); 
//Sorting the module based on their sort order value.		  
		foreach ($module_data as $key => $value) {
      		$sort_order[$key] = $value['sort_order'];
    	}
		
		array_multisort($sort_order, SORT_ASC, $module_data);
		
		$this->data['modules'] = array();
//Retreiving each child of the module 		
		foreach ($module_data as $module) {
			$module = $this->getChild('module/' . $module['code'], $module['setting']);
			
			if ($module) {
				$this->data['modules'][] = $module;
			}
		}
/*
	Check if the template file other than the default theme for the column_bottom exists or not. 
	If yes, get the template file for the new theme configured.
	else load the default theme template for the column_bottom
*/	
		if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/common/content_bottom.tpl')) {
			$this->template = $this->config->get('config_template') . '/template/common/content_bottom.tpl';
		} else {
			$this->template = 'default/template/common/content_bottom.tpl';
		}
								
		$this->render();
	}
}
?>