<?php
/*
@File success.php(Controller)
SUCCESS PAGE
    Displays the success message when order payment is done and confirmed

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/

class ControllerCheckoutSuccess extends Controller { 

/*
FUNCTION NAME 		-	index
DESCRIPTION 		-	Loads the success page for the message 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Success message
*/	
	public function index() { 	
		$resp="";
		// if (isset($this->session->data['order_id']) && $this->validateBasePackage()) {
		if (isset($this->session->data['order_id'])) {
			$resp=$this->callKmsAPI($this->session->data['order_id']);
//Clears the cart after the success of the checkout
			$this->cart->clear();
//Unsetting other session variables
			unset($this->session->data['shipping_method']);
			unset($this->session->data['shipping_methods']);
			unset($this->session->data['payment_method']);
			unset($this->session->data['payment_methods']);
			unset($this->session->data['guest']);
			unset($this->session->data['comment']);
			unset($this->session->data['order_id']);	
			unset($this->session->data['coupon']);
			unset($this->session->data['reward']);
			unset($this->session->data['voucher']);
			unset($this->session->data['vouchers']);
			unset($this->session->data['totals']);
		}	
									   
		$this->language->load('checkout/success');
		
		$this->document->setTitle($this->language->get('heading_title'));
//Short-hand links to path as breadcrumbs		
		$this->data['breadcrumbs'] = array(); 

      	$this->data['breadcrumbs'][] = array(
        	'href'      => $this->url->link('common/home'),
        	'text'      => $this->language->get('text_home'),
        	'separator' => false
      	); 
		
      	$this->data['breadcrumbs'][] = array(
        	'href'      => $this->url->link('checkout/cart'),
        	'text'      => $this->language->get('text_basket'),
        	'separator' => $this->language->get('text_separator')
      	);
				
		$this->data['breadcrumbs'][] = array(
			'href'      => $this->url->link('checkout/checkout', '', 'SSL'),
			'text'      => $this->language->get('text_checkout'),
			'separator' => $this->language->get('text_separator')
		);	
					
      	$this->data['breadcrumbs'][] = array(
        	'href'      => $this->url->link('checkout/success'),
        	'text'      => $this->language->get('text_success'),
        	'separator' => $this->language->get('text_separator')
      	);
      	if(isset($resp))
      	{
      		$this->data['heading_title'] = $resp;	
      	}else{
			$this->data['heading_title'] = $this->language->get('heading_title');
      	}
      	//$this->data['heading_title'] = $resp;	
//Assigning success message variable		
		if ($this->customer->isLogged()) {
    		$this->data['text_message'] = sprintf($this->language->get('text_customer'), $this->url->link('account/account', '', 'SSL'), $this->url->link('account/order', '', 'SSL'), $this->url->link('account/download', '', 'SSL'), $this->url->link('information/contact'));
		} else {
    		$this->data['text_message'] = sprintf($this->language->get('text_guest'), $this->url->link('information/contact'));
		}
		
    	$this->data['button_continue'] = $this->language->get('button_continue');

    	$this->data['continue'] = $this->url->link('common/home');
/*Check if the template file other than the default theme for the success exists or not. 
	If yes, get the template file for the new theme configured.
	else load the default theme template for the success
*/
		if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/common/success.tpl')) {
			$this->template = $this->config->get('config_template') . '/template/common/success.tpl';
		} else {
			$this->template = 'default/template/common/success.tpl';
		}
		
		$this->children = array(
			'common/column_left',
			'common/column_right',
			'common/content_top',
			'common/content_bottom',
			'common/footer',
			'common/header'			
		);
				
		$this->response->setOutput($this->render());
  	}

  	public function validateBasePackage(){
  		/*======================================================================*/
  		$products = $this->cart->getProducts();
  		$validate = true;
		$basicPackPostCnt=0;

		foreach ($products as $product) {
			// Checking Basic Package
			$isBasePack = $this->customer->isBasicPackage($product['product_id']);
			if($isBasePack)
				$basicPackPostCnt++;
		}

	    if($basicPackPostCnt>1){
			$this->session->data['warning'] = 'Warning: Cannot subscribed more than one basic package for customer.!';
			$this->redirect($this->url->link('checkout/cart'));
		}else{
			foreach ($products as $product) {
				$isBasePack = $this->customer->isBasicPackage($product['product_id']);
				$basicPackageExist = $this->customer->isBasicPackageAvailable($this->session->data['customer_id'],$product['product_id'],$isBasePack);
				if($basicPackageExist==101 && $basicPackPostCnt!=1){
		    		$this->session->data['warning'] = 'Warning: Basic Package Subscription not available for customer, atleast one basic package required.!';
					$validate = false;
		    		$this->redirect($this->url->link('checkout/cart'));
		    	}else if($basicPackageExist==301){
    				$this->session->data['warning'] = 'Warning: Basic Package Subscription already available, cannot subscribed another basic package.!';
					$validate = false;
					$this->redirect($this->url->link('checkout/cart'));
    			}else if($basicPackageExist==201){
    				$this->session->data['warning'] = 'Warning: Multiple Base Package Subscription available, kindly de-subscribe other base packages.!';
    				$validate = false;
    				$this->redirect($this->url->link('checkout/cart'));
    			}
	    	}
    	} 
    	return $validate;
		/*======================================================================*/
  	}
  	
  	function callKmsAPI($order_id)
  	{
  		$message="";
  		$curlresponse="";
  		$p_no="";
  		$this->load->model('checkout/order');
  		$rows=$this->model_checkout_order->getOrderDetails($order_id);

  		// 
		if (isset($rows)) 
		{
			$obj = new restapi();
			foreach ($rows as $row) 
			{
				$operator_id = $this->model_checkout_order->getOperatorID($row['cust_id']);
				$stb_no = $this->model_checkout_order->getSTBNO($row['cust_id']);
			
				$end_time=$row['expire'];
				// $end_time=$end_time;
				
				$now_datetime = new DateTime("now", new DateTimeZone('Asia/Kolkata'));
				$start_time =  $now_datetime->getTimestamp();

				/*$var=date('Y-m-d H:i:s');
				$start_time=strtotime($var);*/

				$method ="POST";
				
				if($row['is_ppv']==1)
				{	

					$ppv_datetime_start = new DateTime($row['date_added'], new DateTimeZone('Asia/Calcutta'));
					$start_time  = $ppv_datetime_start->getTimestamp(); 
					$end_time=$row['ppv_expiry'];

					/*$end_time=$row['ppv_expiry'];
					$end_time=$end_time-19800;
					$start_time=strtotime($row['date_added']);
					$start_time=$start_time-19800;*/
					$cmd_id=18;
					$data="user_id=".$row['customer_id']."&ppv_id=".$row['product_id']."&start_time=".$start_time."&end_time=".$end_time;
					$uri=KMS_API."/enablePPVSubscription";
					
				}elseif($row['is_package']==0)
				{
					$cmd_id=10;
					$data="user_id=".$row['customer_id']."&product_id=".$row['product_id']."&start_time=".$start_time."&end_time=".$row['expire']."&is_nvod=".$row['is_nvod'];
					$uri=KMS_API."/enableProductSubscription";
				}else{
					$cmd_id=6;
					$data="user_id=".$row['customer_id']."&package_id=".(int)$row['product_id']."&start_time=".$start_time."&end_time=".$row['expire'];
					// var_dump($data);exit();
					$uri=KMS_API."/enablePackageSubscription";	
				}
				$hdr = array('Content-Type: application/x-www-form-urlencoded',API_AUTH_NAME.':'.API_AUTH);
				$res=$obj->callAPI($method,$hdr,$uri,$data);
		
				$response=json_decode($res);
				
				$error=true;
				$errorMsg='';
				$error_encounter=0;
				if($response!=NULL){
					foreach ($response as $key => $value) {
		    			if((strcmp($key,"error")==0)&&$value==false)
		    			{
		    				$error=$value;
		    				
		    			}
		    			if((strcmp($key,"error")==0)&&$value==true)
		    			{
		    				$error=$value;
		    				$error_encounter=1;
		    			}
		    			if((strcmp($key,"id")==0))
		    			{
		    				$product_subscription_id=$value;
		    			}
		    			if((strcmp($key,"mq_response")==0))
		    			{
		    				$curlresponse=$value;
		    			}
		    			if((strcmp($key,"message")==0))
		    			{
		    				$message=$value;
		    			}if($key!='message' && $key!='error' && $key!='id' && $key!='mq_response')
						{
							$errorMsg=$errorMsg." ".$key. ": ".$value."\n";			
						}	
	    			}
		    		if(!$error)
					{
						// -------------------------------------
	    				$log_target_level = "Individual";
						$log_target = $stb_no;
						$p_no = $this->model_checkout_order->getPNo($row['prod_id']);
						// -------------------------------------
						$resend_status = 0;
						if($row['is_ppv']==1){
							$commandid = 18;
							$p_no = '-1';
							$this->WriteMessageLog($product_subscription_id,$curlresponse,$log_target_level,$log_target,"PPV SUBS.",$resend_status,$commandid,$p_no);
						}elseif ($row['is_package']==1) {
							$commandid = 6;
							$this->WriteMessageLog($product_subscription_id,$curlresponse,$log_target_level,$log_target,"PACKAGE SUBS."." - ".$p_no,$resend_status,$commandid,$p_no);
						}else{
							$commandid = 10;
							$this->WriteMessageLog($product_subscription_id,$curlresponse,$log_target_level,$log_target,"PRODUCT SUBS."." - ".$p_no,$resend_status,$commandid,$p_no);
						}
						
						$ack=((strpos($curlresponse,'NACK') !== false)?'NACK':((strpos($curlresponse,'ACK') !== false)?'ACK':'NACK'));
						$ack_is=-1;$nack_is=-1;
						if((strcmp($ack,"ACK")==0))
						{
							$ack_is=1;
						}elseif((strcmp($ack,"NACK")==0)){
							$nack_is=0;
					
						}if($row['is_ppv']==1){
							$this->model_checkout_order->addToTransanction($row['cust_id'],$cmd_id,$end_time,$product_subscription_id,$ack_is,$nack_is,$row['prod_id'],$row['is_package'],$row['cust_id'],$order_id,0,$operator_id,$stb_no);					
						}else{
							$this->model_checkout_order->addToTransanction($row['cust_id'],$cmd_id,$end_time,$product_subscription_id,$ack_is,$nack_is,$row['prod_id'],$row['is_package'],$row['cust_id'],$order_id,0,$operator_id,$stb_no);
							// -----------------------------------------------------------------
								// $p_no = $this->model_checkout_order->getPNo($order_id);
							$p_no = $this->model_checkout_order->getPNo($row['prod_id']);
							// -----------------------------------------------------------------
							
						}
						// --------------------------------
						if($ack_is==1){
							$this->model_checkout_order->addToSubscriptionDesubscription($row['cust_id'],$cmd_id,$end_time,$product_subscription_id,$ack_is,$row['prod_id'],$operator_id,$stb_no);
						}
						// --------------------------------

					}else{
						$errorMsg=$errorMsg." ".$message."\n";
					}
					
				}else{
					$message ="Warning: KMS FAIL..NACK.!";
				}	
			} //END FOREACH
			/*if (!$error) {
				$temp = 0;
				foreach ($this->cart->getProducts() as $cart) {
					$temp += $cart['total'];
				}
				$total_amount = $temp + $this->session->data['shipping_method']['cost'];
				$this->model_checkout_order->addLCOtransaction($total_amount,$this->session->data);
			}*/
			if (!$error) {		
				$final_total = end($this->session->data['totals']);
				$this->model_checkout_order->addLCOtransaction($final_total["value"],$this->session->data);
			}
		}
			
		if($error_encounter)
			return $errorMsg;
		else
			return $message;
  	}

  	public function WriteMessageLog($id,$status,$log_target_level,$log_target,$command,$resend_status,$commandid,$p_no){
		date_default_timezone_set('Asia/Kolkata');
   		$log_file = fopen(DIR_LOGS."command_log.txt", "a") or die("Unable to open file!");
 		$today  = date("Y-m-d H:i:s");
    	// fwrite($log_file, "\n".$status."\t\t".$today."\t\t".$log_target_level."\t\t".$log_target."\t\t".$command);
    	fwrite($log_file, "\n".str_pad($status,14," ").$today."\t".str_pad($log_target_level,18," ").str_pad($log_target,24," ").$command);
        fclose($log_file);
        // ------------------------------only subscription log------------------------------------
        $log_file = fopen(DIR_LOGS."subscription_log.txt", "a") or die("Unable to open file!");
 		$today  = date("Y-m-d H:i:s");    	
    	fwrite($log_file, "\n".str_pad($status,14," ").$today."\t\t".str_pad($log_target,24," ").$command);
        fclose($log_file);

        $log_target_level = 1;
        $this->customer->genericLogCommandsFunc($id,$status,$log_target_level,$log_target,$commandid,$resend_status,$p_no);

        // -----------------------------------------------------------------------------------------
    }
}
?>