<?php
/*
@File checkout.php(Controller)
CHECKOUT PAGE
    Loads the checkout page with the option to make final confirmation of the products
    like billing address and payment methods.

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/

class ControllerCheckoutCheckout extends Controller { 
/*
FUNCTION NAME 		-	index
DESCRIPTION 		-	Loads the checkout page for the order to confirm it. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Checkout form for billing address and payment method.
*/		
	public function index() {
// Validate cart has products and has stock.
		if ((!$this->cart->hasProducts() && empty($this->session->data['vouchers'])) || (!$this->cart->hasStock() && !$this->config->get('config_stock_checkout'))) {
	  		$this->redirect($this->url->link('checkout/cart'));
    	}	
    	// var_dump($this->customer->isUserPairedWithSTB());exit();
    	if(!$this->customer->isUserPairedWithSTB())
    	{
    		if (!$this->customer->isLogged()) {
    			$this->session->data['warning']='Warning: You are not logged in. Please login!';
    		}
    		else{
    			$this->session->data['warning']='Warning: User not paired with any STB!';
    		}
    		$this->redirect($this->url->link('checkout/cart'));
    	}

    	$blacklist_status = $this->customer->validateBoxBlacklistStatus(); 
    	if($blacklist_status==1) {
    		$this->session->data['warning']='Warning: Box is Blacklisted!';
    		$this->redirect($this->url->link('checkout/cart'));
    	}

    	$is_suspend = $this->customer->isStbSuspend(); 
    	if($is_suspend==1) {
    		$this->session->data['warning']='Warning: STB is suspended, Please resume the box before subscription.!';
    		$this->redirect($this->url->link('checkout/cart'));
    	}

    	$lcoId  = $this->customer->getOperatorIdFromStb();
    	$is_lco_suspend = $this->customer->isLcoSuspend($lcoId);
 		if($is_lco_suspend==1){
 			$this->session->data['warning']= 'Warning: STB Belongs To LCO Is Suspended, Please Resume LCO before subscription.!';	
 			$this->redirect($this->url->link('checkout/cart'));	
 		}

    	$is_RMA = $this->customer->isStbRMA(); 
    	if($is_RMA==1) {
    		$this->session->data['warning']='Warning: STB in RMA State, Cannot send subscription.!';
    		$this->redirect($this->url->link('checkout/cart'));
    	}

    	$box_status = $this->customer->validateBoxStatus(); 
    	if($box_status==0) {
    		$this->session->data['warning']='Warning: Box is not active, Please activate the box before subscription!';
    		$this->redirect($this->url->link('checkout/cart'));
    	}
		
// Validate minimum quantity requirments.			
		$products = $this->cart->getProducts();
		// exit();
		// var_dump($this->session->data['cart']);exit();
		// if(sizeof($products)>1){
		// 	$this->session->data['warning']='Please order one Product/PPV/Package at a time!';
		// 	$this->redirect($this->url->link('checkout/cart'));
		// }
		$product_id = array();
		foreach ($this->session->data['cart'] as $key => $quantity) {
			$product = explode(':', $key);
			array_push($product_id,$product[0]);
		}
		if (count(array_unique($product_id))<count($product_id)) {
			$this->session->data['warning']='Warning: Duplicate Product/PPV/Package already added into the cart!';
			$this->redirect($this->url->link('checkout/cart'));
		}
		// var_dump($product_id);exit();
//-----------------------Checking PPV duplicate subscription-------------------------------
		$prod_id = $this->cart->getSubscriptionDeatils();
		
		foreach ($products as $key => $value) {
			foreach ($prod_id as $value1) {	
				if(in_array($key,$value1) && $value['is_ppv']==1 && $this->session->data['customer_id']==$value1['customer_id']){
					$this->session->data['warning']='You have already bought this offer !';
					$this->redirect($this->url->link('checkout/cart'));			
				}
			}
		}

		// exit();
//------------------------------------------------------------------------------------------		
//-----------------------Checking NVOD duplicate subscription-------------------------------------
		foreach ($products as $key => $value) {
			$is_nvod = $this->cart->isNvod($value['product_id']); 
			if($is_nvod['is_nvod']){
	    		$is_subscribed = $this->cart->getNvodStatus($value['product_id'], $this->session->data['customer_id']) ;
	    		if($is_subscribed){		    			
	    			$this->session->data['warning']='Warning: This Nvod is already subscribed for this customer!';
					$this->redirect($this->url->link('checkout/cart'));	
	    		}
    		}				
		}		
//-------------------------------------------------------------------------------------------
		$basicPackPostCnt=0;
		foreach ($products as $product) {
			$product_total = 0;
				
			foreach ($products as $product_2) {
				if ($product_2['product_id'] == $product['product_id']) {
					$product_total += $product_2['quantity'];
				}
			}		
			
			if ($product['minimum'] > $product_total) {
				$this->redirect($this->url->link('checkout/cart'));
			}	
			// Checking Basic Package
			$isBasePack = $this->customer->isBasicPackage($product['product_id']);
			if($isBasePack)
				$basicPackPostCnt++;			
		}

		/*======================================================================*/

	    if($basicPackPostCnt>1){
			$this->session->data['warning'] = 'Warning: Cannot subscribed more than one basic package for customer.!';
			$this->redirect($this->url->link('checkout/cart'));
		}else{
			foreach ($products as $product) {
				$isBasePack = $this->customer->isBasicPackage($product['product_id']);
				$basicPackageExist = $this->customer->isBasicPackageAvailable($this->session->data['customer_id'],$product['product_id'],$isBasePack);
				if($basicPackageExist==101 && $basicPackPostCnt!=1){
		    		$this->session->data['warning'] = 'Warning: Basic Package Subscription not available for customer, atleast one basic package required.!';
		    		$this->redirect($this->url->link('checkout/cart'));
		    	}else if($basicPackageExist==301){
    				$this->session->data['warning'] = 'Warning: Basic Package Subscription already available, cannot subscribed another basic package.!';
    				$this->redirect($this->url->link('checkout/cart'));
    			}else if($basicPackageExist==201){
    				$this->session->data['warning'] = 'Warning: Multiple Base Package Subscription available, kindly de-subscribe other base packages.!';
    				$this->redirect($this->url->link('checkout/cart'));
    			}
			}
    	} 
		/*======================================================================*/
//Loads language for checkout				
		$this->language->load('checkout/checkout');
		
		$this->document->setTitle($this->language->get('heading_title')); 
//Adding script and style		
		$this->document->addScript('catalog/view/javascript/jquery/colorbox/jquery.colorbox-min.js');
		$this->document->addStyle('catalog/view/javascript/jquery/colorbox/colorbox.css');
//Short-hand links to the path as breadcrumbs					
		$this->data['breadcrumbs'] = array();

      	$this->data['breadcrumbs'][] = array(
        	'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home'),
        	'separator' => false
      	); 

      	$this->data['breadcrumbs'][] = array(
        	'text'      => $this->language->get('text_cart'),
			'href'      => $this->url->link('checkout/cart'),
        	'separator' => $this->language->get('text_separator')
      	);
		
      	$this->data['breadcrumbs'][] = array(
        	'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('checkout/checkout', '', 'SSL'),
        	'separator' => $this->language->get('text_separator')
      	);
//Assigning page variables					
	    $this->data['heading_title'] = $this->language->get('heading_title');
		
		$this->data['text_checkout_option'] = $this->language->get('text_checkout_option');
		$this->data['text_checkout_account'] = $this->language->get('text_checkout_account');
		$this->data['text_checkout_payment_address'] = $this->language->get('text_checkout_payment_address');
		$this->data['text_checkout_shipping_address'] = $this->language->get('text_checkout_shipping_address');
		$this->data['text_checkout_shipping_method'] = $this->language->get('text_checkout_shipping_method');
		$this->data['text_checkout_payment_method'] = $this->language->get('text_checkout_payment_method');		
		$this->data['text_checkout_confirm'] = $this->language->get('text_checkout_confirm');
		$this->data['text_modify'] = $this->language->get('text_modify');
		
		$this->data['logged'] = $this->customer->isLogged();
		$this->data['shipping_required'] = $this->cart->hasShipping();	
/*Check if the template file other than the default theme for the checkout exists or not. 
	If yes, get the template file for the new theme configured.
	else load the default theme template for the checkout
*/		
		if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/checkout/checkout.tpl')) {
			$this->template = $this->config->get('config_template') . '/template/checkout/checkout.tpl';
		} else {
			$this->template = 'default/template/checkout/checkout.tpl';
		}
		
		$this->children = array(
			'common/column_left',
			'common/column_right',
			'common/content_top',
			'common/content_bottom',
			'common/footer',
			'common/header'	
		);
				
		$this->response->setOutput($this->render());
  	}
/*
FUNCTION NAME 		-	country
DESCRIPTION 		-	Retrieve the country details of the selected country
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns a json containing country information.
*/	
	public function country() {
		$json = array();
//Loads model for country		
		$this->load->model('localisation/country');
//Retrieving country information
    	$country_info = $this->model_localisation_country->getCountry($this->request->get['country_id']);
//Assigning information to an array.		
		if ($country_info) {
			$this->load->model('localisation/zone');

			$json = array(
				'country_id'        => $country_info['country_id'],
				'name'              => $country_info['name'],
				'iso_code_2'        => $country_info['iso_code_2'],
				'iso_code_3'        => $country_info['iso_code_3'],
				'address_format'    => $country_info['address_format'],
				'postcode_required' => $country_info['postcode_required'],
				'zone'              => $this->model_localisation_zone->getZonesByCountryId($this->request->get['country_id']),
				'status'            => $country_info['status']		
			);
		}
		
		$this->response->setOutput(json_encode($json));
	}
}
?>