<?php 
/*
@File success.php(Controller)
AFFILIATE SUCCESS PAGE
    This class load the success message when affiliate is successfully registered.

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/ 
class ControllerAffiliateSuccess extends Controller {  
/*
FUNCTION NAME 		-	index
DESCRIPTION 		-	Loads the success message on registration 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Success message
*/
	public function index() {
//Loads the language for success
    	$this->language->load('affiliate/success');
  
    	$this->document->setTitle($this->language->get('heading_title'));
//Short-hand links to path as breadcrumbs
		$this->data['breadcrumbs'] = array();

      	$this->data['breadcrumbs'][] = array(
        	'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home'),       	
        	'separator' => false
      	); 

      	$this->data['breadcrumbs'][] = array(
        	'text'      => $this->language->get('text_account'),
			'href'      => $this->url->link('affiliate/account', '', 'SSL'),
        	'separator' => $this->language->get('text_separator')
      	);

      	$this->data['breadcrumbs'][] = array(
        	'text'      => $this->language->get('text_success'),
			'href'      => $this->url->link('affiliate/success'),
        	'separator' => $this->language->get('text_separator')
      	);
//Assigning page variable
    	$this->data['heading_title'] = $this->language->get('heading_title');

		$this->data['text_message'] = sprintf($this->language->get('text_approval'), $this->config->get('config_name'), $this->url->link('information/contact'));
		
    	$this->data['button_continue'] = $this->language->get('button_continue');
		
		$this->data['continue'] = $this->url->link('affiliate/account', '', 'SSL');
/*Check if the template file other than the default theme for the success exists or not. 
	If yes, get the template file for the new theme configured.
	else load the default theme template for the success
*/
		if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/common/success.tpl')) {
			$this->template = $this->config->get('config_template') . '/template/common/success.tpl';
		} else {
			$this->template = 'default/template/common/success.tpl';
		}
		
		$this->children = array(
			'common/column_left',
			'common/column_right',
			'common/content_top',
			'common/content_bottom',
			'common/footer',
			'common/header'	
		);
				
		$this->response->setOutput($this->render());				
  	}
}
?>