<?php 
/*
@File login.php(Controller)
AFFILIATE LOGIN PAGE
    Load the login page for the affiliate and a registration link if don't have an account.
@Author Mohammad Azfar 
@date 13th Nov. 2014
*/ 
class ControllerAffiliateLogin extends Controller {
	private $error = array();
/*
FUNCTION NAME 		-	index
DESCRIPTION 		-	Loads the login form for the affiliate. Where affiliate can login 
						by giving his credentials 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Affiliate login form and registration link
*/	
	public function index() {
/*Checks if the customer is logged in or not, if yes redirect him to his account page.*/
		if ($this->affiliate->isLogged()) {  
      		$this->redirect($this->url->link('affiliate/account', '', 'SSL'));
    	}
//Loads language for login	
    	$this->language->load('affiliate/login');

    	$this->document->setTitle($this->language->get('heading_title')); 
//Loads model for affiliate		
		$this->load->model('affiliate/affiliate');
//Redirecting him to account page if email id and password is valid.						
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && isset($this->request->post['email']) && isset($this->request->post['password']) && $this->validate()) {
			if (isset($this->request->post['redirect']) && (strpos($this->request->post['redirect'], $this->config->get('config_url')) !== false || strpos($this->request->post['redirect'], $this->config->get('config_ssl')) !== false)) {
				$this->redirect(str_replace('&amp;', '&', $this->request->post['redirect']));
			} else {
				$this->redirect($this->url->link('affiliate/account', '', 'SSL'));
			} 
		}
//Short-hand links to path as breadcrumbs		
      	$this->data['breadcrumbs'] = array();

      	$this->data['breadcrumbs'][] = array(
        	'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home'),       	
        	'separator' => false
      	);
 
      	$this->data['breadcrumbs'][] = array(
        	'text'      => $this->language->get('text_account'),
			'href'      => $this->url->link('affiliate/account', '', 'SSL'),
        	'separator' => $this->language->get('text_separator')
      	);
		
      	$this->data['breadcrumbs'][] = array(
        	'text'      => $this->language->get('text_login'),
			'href'      => $this->url->link('affiliate/login', '', 'SSL'),      	
        	'separator' => $this->language->get('text_separator')
      	);
//Assigning local page variable.				
    	$this->data['heading_title'] = $this->language->get('heading_title');
		
		$this->data['text_description'] = sprintf($this->language->get('text_description'), $this->config->get('config_name'), $this->config->get('config_name'), $this->config->get('config_commission') . '%');
		$this->data['text_new_affiliate'] = $this->language->get('text_new_affiliate');
    	$this->data['text_register_account'] = $this->language->get('text_register_account'); 	
		$this->data['text_returning_affiliate'] = $this->language->get('text_returning_affiliate');
		$this->data['text_i_am_returning_affiliate'] = $this->language->get('text_i_am_returning_affiliate');
    	$this->data['text_forgotten'] = $this->language->get('text_forgotten');

    	$this->data['entry_email'] = $this->language->get('entry_email');
    	$this->data['entry_password'] = $this->language->get('entry_password');

    	$this->data['button_continue'] = $this->language->get('button_continue');
		$this->data['button_login'] = $this->language->get('button_login');
//Assigning error and warning variables.
		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}
//Assigning links to action, register and forgotten buttons		
		$this->data['action'] = $this->url->link('affiliate/login', '', 'SSL');
		$this->data['register'] = $this->url->link('affiliate/register', '', 'SSL');
		$this->data['forgotten'] = $this->url->link('affiliate/forgotten', '', 'SSL');
//Assigning variables    	
		if (isset($this->request->post['redirect'])) {
			$this->data['redirect'] = $this->request->post['redirect'];
		} elseif (isset($this->session->data['redirect'])) {
      		$this->data['redirect'] = $this->session->data['redirect'];
	  		
			unset($this->session->data['redirect']);		  	
    	} else {
			$this->data['redirect'] = '';
		}

		if (isset($this->session->data['success'])) {
    		$this->data['success'] = $this->session->data['success'];
    
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}

		if (isset($this->request->post['email'])) {
			$this->data['email'] = $this->request->post['email'];
		} else {
			$this->data['email'] = '';
		}

		if (isset($this->request->post['password'])) {
			$this->data['password'] = $this->request->post['password'];
		} else {
			$this->data['password'] = '';
		}
/*Check if the template file other than the default theme for the login exists or not. 
	If yes, get the template file for the new theme configured.
	else load the default theme template for the login
*/				
		if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/affiliate/login.tpl')) {
			$this->template = $this->config->get('config_template') . '/template/affiliate/login.tpl';
		} else {
			$this->template = 'default/template/affiliate/login.tpl';
		}
		
		$this->children = array(
			'common/column_left',
			'common/column_right',
			'common/content_top',
			'common/content_bottom',
			'common/footer',
			'common/header'	
		);
						
		$this->response->setOutput($this->render());
  	}

/*
FUNCTION NAME 		-	validate
DESCRIPTION 		-	Validate the email id for approval 
						for changing.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns TRUE if the validation satisfies else returns FALSE
*/  
  	protected function validate() {
    	if (!$this->affiliate->login($this->request->post['email'], $this->request->post['password'])) {
      		$this->error['warning'] = $this->language->get('error_login');
    	}

		$affiliate_info = $this->model_affiliate_affiliate->getAffiliateByEmail($this->request->post['email']);
//Email approval validation		
    	if ($affiliate_info && !$affiliate_info['approved']) {
      		$this->error['warning'] = $this->language->get('error_approved');
    	}	
			
    	if (!$this->error) {
      		return true;
    	} else {
      		return false;
    	}  	
  	}
}
?>
