<?php 
/*
@File success.php(Controller)
CUSTOMER SUCCESS PAGE
    This page is displayed when customers registeration is successfully. 

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ControllerAccountSuccess extends Controller {  

/*
FUNCTION NAME 		-	index
DESCRIPTION 		-	Loads the page on successful registration
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Success message.
*/	
	public function index() {
//Loads the language for success
    	$this->language->load('account/success');
  
    	$this->document->setTitle($this->language->get('heading_title'));
//Short-hand links to path as breadcrumbs.
		$this->data['breadcrumbs'] = array();

      	$this->data['breadcrumbs'][] = array(
        	'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home'),       	
        	'separator' => false
      	); 

      	$this->data['breadcrumbs'][] = array(
        	'text'      => $this->language->get('text_account'),
			'href'      => $this->url->link('account/account', '', 'SSL'),
        	'separator' => $this->language->get('text_separator')
      	);

      	$this->data['breadcrumbs'][] = array(
        	'text'      => $this->language->get('text_success'),
			'href'      => $this->url->link('account/success'),
        	'separator' => $this->language->get('text_separator')
      	);

    	$this->data['heading_title'] = $this->language->get('heading_title');
//Loading model for customer_group
		$this->load->model('account/customer_group');
//Retrieving customer_group for the selected customer_group_id		
		$customer_group = $this->model_account_customer_group->getCustomerGroup($this->customer->getCustomerGroupId());
//Assigning message based on the approval of the customer.
		if ($customer_group && !$customer_group['approval']) {
    		$this->data['text_message'] = sprintf($this->language->get('text_message'), $this->url->link('information/contact'));
		} else {
			$this->data['text_message'] = sprintf($this->language->get('text_approval'), $this->config->get('config_name'), $this->url->link('information/contact'));
		}
		
    	$this->data['button_continue'] = $this->language->get('button_continue');
/*If customer has product in his cart, redirect him to checkout/cart page to make the order
	else redirect him to his account home page.
*/		
		if ($this->cart->hasProducts()) {
			$this->data['continue'] = $this->url->link('checkout/cart', '', 'SSL');
		} else {
			$this->data['continue'] = $this->url->link('account/account', '', 'SSL');
		}
/*Check if the template file other than the default theme for the success exists or not. 
	If yes, get the template file for the new theme configured.
	else load the default theme template for the success
*/
		if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/common/success.tpl')) {
			$this->template = $this->config->get('config_template') . '/template/common/success.tpl';
		} else {
			$this->template = 'default/template/common/success.tpl';
		}
		
		$this->children = array(
			'common/column_left',
			'common/column_right',
			'common/content_top',
			'common/content_bottom',
			'common/footer',
			'common/header'	
		);
						
		$this->response->setOutput($this->render());				
  	}
}
?>