<?php 
/*
@File subscription.php(Controller)
CUSTOMER SUBSCRIPTION PAGE
    All the subscription made by the customer is displayed as a list.

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ControllerAccountSubscription extends Controller {
	private $error = array();
/*
FUNCTION NAME 		-	index
DESCRIPTION 		-	Retrieves the subscription from the database for the logged in 
						customer.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Subscription list, 10 in each page.
*/
	public function index() {

/*Checks if the customer is logged in or not, if not redirect him to login page.*/
		if (!$this->customer->isLogged()) {
			$this->session->data['redirect'] = $this->url->link('account/subscription', '', 'SSL');

			$this->redirect($this->url->link('account/login', '', 'SSL'));
		}
//Loads the language for subscription
		$this->language->load('account/subscription');
		
		$this->document->setTitle($this->language->get('heading_title'));
//Loads the model for customer		
		$this->load->model('account/customer');
//Short-hand links to the path as breadcrumbs
      	$this->data['breadcrumbs'] = array();

      	$this->data['breadcrumbs'][] = array(
        	'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home'),     	
        	'separator' => false
      	); 

      	$this->data['breadcrumbs'][] = array(
        	'text'      => $this->language->get('text_account'),
			'href'      => $this->url->link('account/account', '', 'SSL'),        	
        	'separator' => $this->language->get('text_separator')
      	);

      	$this->data['breadcrumbs'][] = array(
        	'text'      => $this->language->get('text_subscription'),
			'href'      => $this->url->link('account/subscription', '', 'SSL'),       	
        	'separator' => $this->language->get('text_separator')
      	);
		
//Retrieving subscription details from the database.
		$subscription_detail = $this->model_account_customer->getSubscription($this->customer->getId());
			$this->data['subscription'] = array();
//Assigning detials to an array
			foreach ($subscription_detail as $r) {
				$this->data['subscription'][] = array(
					'product_id' => $r['name'],
					'start_date' => $r['start_date'],
					'expire_date' => $r['expire_date']
				);
				
			}
				
		$this->data['heading_title'] = $this->language->get('heading_title');

		$this->data['text_subscription_title'] = $this->language->get('text_subscription_title');


		$this->data['button_continue'] = $this->language->get('button_continue');
		$this->data['button_back'] = $this->language->get('button_back');
//Assigning errors and warning variables.
		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}
//Assigning button events
		$this->data['action'] = $this->url->link('account/subscription', '', 'SSL');

		$this->data['back'] = $this->url->link('account/account', '', 'SSL');
/*
	Check if the template file other than the default theme for the subscription exists or not. 
	If yes, get the template file for the new theme configured.
	else load the default theme template for the subscription
*/
		if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/account/subscription.tpl')) {
			$this->template = $this->config->get('config_template') . '/template/account/subscription.tpl';
		} else {
			$this->template = 'default/template/account/subscription.tpl';
		}
		
		$this->children = array(
			'common/column_left',
			'common/column_right',
			'common/content_top',
			'common/content_bottom',
			'common/footer',
			'common/header'	
		);
						
		$this->response->setOutput($this->render());	
	}

	
}
?>
