<?php 
/*
@File logout.php(Controller)
CUSTOMER LOGOUT ACCOUNT PAGE
    Customer can logout from his account.

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ControllerAccountLogout extends Controller {


/*
FUNCTION NAME 		-	index
DESCRIPTION 		-	Logout the customer from his account and clear the session 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Logout notification
*/	
	public function index() {
//check if customer is logged in.
    	if ($this->customer->isLogged()) {
//logout the customer       		
      		$this->customer->logout();
//clear his cart
	  		$this->cart->clear();
//unset customer session.			
			unset($this->session->data['wishlist']);
			unset($this->session->data['shipping_address_id']);
			unset($this->session->data['shipping_country_id']);
			unset($this->session->data['shipping_zone_id']);
			unset($this->session->data['shipping_postcode']);
			unset($this->session->data['shipping_method']);
			unset($this->session->data['shipping_methods']);
			unset($this->session->data['payment_address_id']);
			unset($this->session->data['payment_country_id']);
			unset($this->session->data['payment_zone_id']);
			unset($this->session->data['payment_method']);
			unset($this->session->data['payment_methods']);
			unset($this->session->data['comment']);
			unset($this->session->data['order_id']);
			unset($this->session->data['coupon']);
			unset($this->session->data['reward']);			
			unset($this->session->data['voucher']);
			unset($this->session->data['vouchers']);
			
      		$this->redirect($this->url->link('account/logout', '', 'SSL'));
    	}
//Loads language for logout. 
    	$this->language->load('account/logout');
		
		$this->document->setTitle($this->language->get('heading_title'));
//Short-hand link to the path as breadcrumbs.      	
		$this->data['breadcrumbs'] = array();

      	$this->data['breadcrumbs'][] = array(
        	'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home'),        	
        	'separator' => false
      	);
      	
		$this->data['breadcrumbs'][] = array(
        	'text'      => $this->language->get('text_account'),
			'href'      => $this->url->link('account/account', '', 'SSL'),       	
        	'separator' => $this->language->get('text_separator')
      	);
		
      	$this->data['breadcrumbs'][] = array(
        	'text'      => $this->language->get('text_logout'),
			'href'      => $this->url->link('account/logout', '', 'SSL'),
        	'separator' => $this->language->get('text_separator')
      	);	
		
    	$this->data['heading_title'] = $this->language->get('heading_title');

    	$this->data['text_message'] = $this->language->get('text_message');

    	$this->data['button_continue'] = $this->language->get('button_continue');

    	$this->data['continue'] = $this->url->link('common/home');

/*Check if the template file other than the default theme for the logout exists or not. 
	If yes, get the template file for the new theme configured.
	else load the default theme template for the logout
*/		
		if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/common/success.tpl')) {
			$this->template = $this->config->get('config_template') . '/template/common/success.tpl';
		} else {
			$this->template = 'default/template/common/success.tpl';
		}
		
		$this->children = array(
			'common/column_left',
			'common/column_right',
			'common/content_top',
			'common/content_bottom',
			'common/footer',
			'common/header'	
		);
						
		$this->response->setOutput($this->render());	
  	}
}
?>