<?php 
/*
@File account.php(Controller)
CUSTOMER ACCOUNT PAGE
    This is the home page for the customer if logged in. On this page the customer 
    gets the hyperlink for managing his account and viewing his account details.

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/

class ControllerAccountAccount extends Controller { 

/*
FUNCTION NAME 		-	index
DESCRIPTION 		-	Loads when a customer logs in with his credentials. 
						Checks for the session and manages the links to different
						pages to the account.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the account template file.
*/
	public function index() {
/*Checks if the customer is logged in or not, if not redirect him to login page.*/
		if (!$this->customer->isLogged()) {
	  		$this->session->data['redirect'] = $this->url->link('account/account', '', 'SSL');
	  
	  		$this->redirect($this->url->link('account/login', '', 'SSL'));
    	} 
/*Loading the language(variable definition) file for the account.*/
		$this->language->load('account/account');
		$this->document->setTitle($this->language->get('heading_title'));
/*Setting the short-hand links as breadcrumbs on the account page.*/
      	$this->data['breadcrumbs'] = array();
      	$this->data['breadcrumbs'][] = array(
        	'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home'),
        	'separator' => false
      	); 

      	$this->data['breadcrumbs'][] = array(       	
        	'text'      => $this->language->get('text_account'),
			'href'      => $this->url->link('account/account', '', 'SSL'),
        	'separator' => $this->language->get('text_separator')
      	);
/*Managing the session for the customer.*/		
		if (isset($this->session->data['success'])) {
    		$this->data['success'] = $this->session->data['success'];
			
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}
		
/*Assigning values to the variables in account page.
	Variables are assigned value that are defined in the language file 
	which is loaded earlier.
*/		
    	$this->data['heading_title'] = $this->language->get('heading_title');
    	$this->data['text_my_box_detail'] = $this->language->get('text_my_box_detail');
    	$this->data['text_my_subscription'] = $this->language->get('text_my_subscription');
    	$this->data['text_my_account'] = $this->language->get('text_my_account');
		$this->data['text_my_orders'] = $this->language->get('text_my_orders');
		$this->data['text_my_newsletter'] = $this->language->get('text_my_newsletter');
    	$this->data['text_edit'] = $this->language->get('text_edit');
    	$this->data['text_box'] = $this->language->get('text_box');
    	$this->data['text_subscription'] = $this->language->get('text_subscription');
    	$this->data['text_password'] = $this->language->get('text_password');
    	$this->data['text_address'] = $this->language->get('text_address');
		$this->data['text_wishlist'] = $this->language->get('text_wishlist');
    	$this->data['text_order'] = $this->language->get('text_order');
    	$this->data['text_download'] = $this->language->get('text_download');
		$this->data['text_reward'] = $this->language->get('text_reward');
		$this->data['text_return'] = $this->language->get('text_return');
		$this->data['text_transaction'] = $this->language->get('text_transaction');
		$this->data['text_newsletter'] = $this->language->get('text_newsletter');

/*Assigning page variables that act as a hyperlink to different pages where the 
	customer can navigate is logged in
*/
		$this->data['subscription'] = $this->url->link('account/subscription', '', 'SSL');
		$this->data['box'] = $this->url->link('account/box', '', 'SSL');
    	$this->data['edit'] = $this->url->link('account/edit', '', 'SSL');
    	$this->data['password'] = $this->url->link('account/password', '', 'SSL');
		$this->data['address'] = $this->url->link('account/address', '', 'SSL');
		$this->data['wishlist'] = $this->url->link('account/wishlist');
    	$this->data['order'] = $this->url->link('account/order', '', 'SSL');
    	$this->data['download'] = $this->url->link('account/download', '', 'SSL');
		$this->data['return'] = $this->url->link('account/return', '', 'SSL');
		$this->data['transaction'] = $this->url->link('account/transaction', '', 'SSL');
		$this->data['newsletter'] = $this->url->link('account/newsletter', '', 'SSL');
		
		if ($this->config->get('reward_status')) {
			$this->data['reward'] = $this->url->link('account/reward', '', 'SSL');
		} else {
			$this->data['reward'] = '';
		}
/*Check if the template file other than the default theme for the account exists or not. 
	If yes, get the template file for the new theme configured.
	else load the default theme template for the account
*/
		if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/account/account.tpl')) {
			$this->template = $this->config->get('config_template') . '/template/account/account.tpl';
		} else {
			$this->template = 'default/template/account/account.tpl';
		}
		
		$this->children = array(
			'common/column_left',
			'common/column_right',
			'common/content_top',
			'common/content_bottom',
			'common/footer',
			'common/header'		
		);
				
		$this->response->setOutput($this->render());
  	}
}
?>