<?php
class Helper {
//------------------------parameter validation---------------------------------
/**
     * Verifying required params posted or not
     */
    function verifyStringParams($string_field,$length) {
        $error = false;
        if(is_string($string_field)){
            
            if (preg_match("#^[a-zA-Z0-9@_:/. ]+$#", $string_field)) {
                if(strlen($string_field) > $length){

                    $error = sprintf("Length should be less than or equal to %s",$length);
                }
            } else {
                $error = "Special characters not allowed!";
            }
        }else{
            $error = "Not a string!";
        }
        return $error;
    }

/**
     * Verifying required params posted or not
     */
    function verifyIntegerParams($Integer_field,$length,$isexactlength) {
        $error = false;
        if(is_numeric($Integer_field)){
            $int_field = (int)$Integer_field;
            $num_length = strlen((string)$int_field);
            if($isexactlength){
                if($num_length != $length){
                    $error = sprintf("Length should be %s!",$length);
                }
            }else{
                if($num_length > $length){
                    $error = sprintf("Length should be less than or equal to %s!",$length);
                }
            }
        }else{
          $error = "Only integers are acceptable";
        }
        return $error;
    }

/**
* Verifying required params posted or not
*/
function verifyParamLength($field,$length,$isexactlength)
{
    $error = true;
    $num_length = strlen($field);
    if($isexactlength)
    {
        if($num_length == $length){
        $error = 1;
        }else{
        $error = "Length should be ".$length;
        }
    }
    else
    {
        if($num_length <= $length)
        {
            $error =1;
        }
        else
        {
            $error = "Length should be less than or equal to ".$length;
        }
    }
    return $error;
}
function verifyStbNo($stbno,$limit){
        $error=false;
        if(strlen((string)$stbno)!=14){
            $error = "Length should be 14 characters";
        }elseif(!preg_match("#^[a-zA-Z0-9]+$#", $stbno)){
            $error = "Accepts only values (A-Z0-9)";
        }
        return $error;
}
}
?>