<?php 
/**
 * Class to handle all db operations
 * 
 * @author Patil Prashant
 * Date: 26th July 2018
 */
class DbHandler {
    private $conn_sms;
    private $conn_kms;
    private $url;
    function __construct() {
        require_once dirname(__FILE__) . '/DbConnect.php';
        //for payment
        require_once dirname(__FILE__) . '/Config.php';
        require_once dirname(__FILE__) . '/enum.php';
        // opening db connection
        $db = new DbConnect();
        $this->conn_sms = $db->connect_sms();
        $this->conn_kms = $db->connect_kms();
    }

function getSuperPermission()
{
    $response = array();
    $stmt = $this->conn_sms->prepare("SELECT `status` FROM `oc_android_auth` WHERE `operator_id` = 44");
    if($stmt->execute())
    {
        $stmt->bind_result($status);
        if($stmt->fetch()){
            if($status==1)
             {   
                $response['error']=false;
                $response['data']['status'] = $status;
            }else{
                $response['error']=true;
                $response['errorCode']=24;            
            }
        }
    }
    $stmt->close();
    return $response;  
}
function restrictAccess($status)
{
    $response = array();
    $stmt = $this->conn_sms->prepare("UPDATE `oc_android_auth` SET `status` = ? ");
    $stmt->bind_param("i",$status);
    $stmt->execute();
    $stmt->close();
}

function getOperatorlogo()
{
    $response = array();
    $stmt = $this->conn_sms->prepare("SELECT `value` FROM `oc_setting` WHERE `key` ='config_logo'");
    if($stmt->execute())
    {
        $stmt->bind_result($value);
        if($stmt->fetch()){
            $response['error']=false;
            $response['data']['url'] = $value;
        }else{
            $response['error']=true;
            $response['errorCode']=1;            
        }
    }else{
        $response['error']=true;
        $response['errorCode']=2;            
    }
    $stmt->close();
    return $response;  
}

function getServerIP()
{
    $response = array();
    $stmt = $this->conn_sms->prepare("SELECT `server_ip` FROM `oc_android_server`");
    if($stmt->execute())
    {
        $stmt->bind_result($server_ip);
        if($stmt->fetch()){
            $response['error']=false;
            $response['data']['server_ip'] = $server_ip;
        }else{
            $response['error']=true;
            $response['errorCode']=1;            
        }
    }else{
        $response['error']=true;
        $response['errorCode']=2;            
    }
    $stmt->close();
    return $response;  
}
function updateServerIP($server_ip)
{
    $response = array();
    $stmt_update = $this->conn_sms->prepare("UPDATE `oc_android_server` SET `server_ip`= ?");
    $stmt_update->bind_param("s",$server_ip);
    $stmt_update->execute();
    $stmt_update->close();
      
}
/***************************************************************************************************************/
                                    /*Basic Fuctionality Check API's*/
/***************************************************************************************************************/

/*
FUNCTION NAME       -   isLogin
DESCRIPTION         -   Get the Login details.
INPUT PARAMETER     -   $username,$password.
OUTPUT PARAMETER    -   Returns all the rows queried
*/  
function isLogin($username,$password)
{
    $response=array();
    $response['data'] = array();
    $stmt = $this->conn_sms->prepare("SELECT user_id,username,sdk_enabled FROM oc_user WHERE username = ? AND (password = SHA1(CONCAT(salt, SHA1(CONCAT(salt, SHA1((?)))))) OR password =(md5(?))) AND status = '1'");

    $stmt->bind_param("sss",$username,$password,$password);
    if($stmt->execute())
    {
        $stmt->bind_result($user_id,$username,$sdk_enabled);
        if($stmt->fetch()){
            if($sdk_enabled){
                
                $response['error']=false;
                $response['data']['user_id']  = $user_id;
                $response['data']['username'] = $username;
                $response['errorCode'] = 0;
                
            }else{
                $response['error']=true;
                $response['errorCode'] = 3;
            }

        }else{
            $response['error']=true;
            $response['errorCode'] = 4;
        }   
    }
    else{
            $response['error']=true;
            $response['errorCode'] = 5;
    }
    $stmt->close();
    return $response;
}
/*
FUNCTION NAME       -   stbMap
DESCRIPTION         -   Get the STB details.
INPUT PARAMETER     -   $stbno.
OUTPUT PARAMETER    -   Returns all the rows queried
*/
function stbMap($stb_no,$operator_id)
{
    $response=array();
    if ($operator_id == 1)
    {
        $stmt = $this->conn_sms->prepare("SELECT `stb_no`,`operator_id` FROM oc_stb WHERE stb_no = ? ");
        $stmt->bind_param("s",$stb_no);
    }
    else
    {    
        $stmt = $this->conn_sms->prepare("SELECT `stb_no`,`operator_id` FROM oc_stb WHERE stb_no = ? AND operator_id = ? ");
        $stmt->bind_param("si",$stb_no,$operator_id);
    }
    if($stmt->execute())
    {
        $stmt->bind_result($stbno,$operator);
        if($stmt->fetch())
        {
            $response['error'] = false;
            $response['errorCode'] = 0;
            $response['data']['stb_no'] = $stbno;
            $response['data']['operator'] = $operator;
        }
        else
        {
            $response['error']=true;
            $response['errorCode']=11;
            
        }
        $stmt->close();
    }
    else
    {
        $response['error']=true;
        $response['errorCode']=2;         
    }
    return $response;
}
/*
FUNCTION NAME       -   custDetails
DESCRIPTION         -   Get the Customer details.
INPUT PARAMETER     -   $stbno.
OUTPUT PARAMETER    -   Returns all the rows queried
*/
function custDetails($stb_no,$operator_id)
{
    $response=array();
    $query = "SELECT c.customer_id,c.customer_unique_id,c.firstname,c.SCNO, c.lastname, c.email, c.telephone,a.postcode,a.address_1,a.address_2,a.city,a.country_id,a.zone_id,a.region_id,g.name,g.customer_group_id,z.name,ct.name FROM`oc_customer` c INNER JOIN `oc_address` a  ON (c.customer_id = a.customer_id )INNER JOIN `oc_customer_group_description` g ON (c.customer_group_id = g.customer_group_id) INNER JOIN `oc_zone` z ON (a.zone_id=z.zone_id) INNER JOIN `oc_country` ct ON (a.country_id = ct.country_id) WHERE STBNO = ? ";
    if($operator_id!=1)
    {
        $query = $query." AND operator_id = ?";
        $stmt = $this->conn_sms->prepare($query);
        $stmt->bind_param("si",$stb_no,$operator_id);
    }
    else
    {
        $stmt = $this->conn_sms->prepare($query);
        $stmt->bind_param("s",$stb_no);
    }    
       
    if($stmt->execute())
    {
        $stmt->bind_result($customer_id,$customer_unique_id,$firstname,$sc_no,$lastname,$email,$telephone,$postcode,$address_1,$address_2,$city,$country_id,$zone_id,$region_id,$name,$customer_group_id,$zone_name,$country_name);
        if($stmt->fetch())
        {
            $response['error']=false;
            $response['data']['stb_no'] = $stb_no;
            $response['data']['customer_id'] = $customer_id;
            $response['data']['customer_unique_id'] = $customer_unique_id;
            $response['data']['firstname'] = $firstname;
            $response['data']['sc_no'] = $sc_no;
            $response['data']['lastname'] = $lastname;
            $response['data']['email'] = $email;
            $response['data']['telephone'] = $telephone;
            $response['data']['postcode'] = $postcode;
            $response['data']['address_1'] = $address_1;
            $response['data']['address_2'] = $address_2;
            $response['data']['city']   = $city;
            $response['data']['country_id']   = $country_id;
            $response['data']['zone_id']   = $zone_id;
            $response['data']['region_id'] = $region_id;
            $response['data']['group_name'] = $name;
            $response['data']['group_id'] = $customer_group_id;
            $response['data']['zone_name'] = $zone_name;
            $response['data']['country_name'] = $country_name;
        }
        else
        {
            $response['error']=true;
            $response['errorCode']=2;            
        }
        $stmt->close();

    }
    else
    {
        $response['error']=true;
        $response['errorCode']=12;            
    }
    return $response;
}
/*
FUNCTION NAME       -   getGroupDetails
DESCRIPTION         -   Get the Customer Group details.
INPUT PARAMETER     -   none.
OUTPUT PARAMETER    -   Returns all the rows queried
*/
function getGroupDetails()
{
    $response = array();
    $response['data']=array();
   /* $stmt = $this->conn_sms->prepare("SELECT c.customer_group_id,c.kms_group_id,k.name FROM oc_customer_group c INNER join oc_customer_group_description k ON c.customer_group_id = k.customer_group_id");*/
    $stmt = $this->conn_sms->prepare("SELECT c.customer_group_id,c.name,k.kms_group_id FROM oc_customer_group_description c left join oc_sms_kms_group k ON c.customer_group_id = k.sms_group_id");
    if($stmt->execute())
    {
        $stmt->bind_result($customer_group_id,$name,$kms_group_id);
        $arr= array();
        while($stmt->fetch())
        {
            $arr['customer_group_id'] = $customer_group_id;
            $arr['name'] = $name;
            //$arr['kms_group_id'] = $kms_group_id;
            array_push($response['data'],$arr); 
            unset($arr);
        } 
        $response['error'] = false;
        $stmt->close();
    }
    return $response;
}
/*
FUNCTION NAME       -   getCountryDetails
DESCRIPTION         -   Get the Country details.
INPUT PARAMETER     -   none.
OUTPUT PARAMETER    -   Returns all the rows queried
*/
function getCountryDetails()
{
    $response = array();
    $response['data']= array();
    $stmt = $this->conn_sms->prepare("SELECT `country_id`,`name` FROM oc_country WHERE country_id IN (99,196)");
    if($stmt->execute())
    {
        $stmt->bind_result($country_id,$name);
        $arr= array();
        while($stmt->fetch())
        {
            $arr['country_id'] = $country_id;
            $arr['name'] = $name;
            array_push($response['data'],$arr);
            unset($arr); 
        }
        
        $response['error'] = false;
        $stmt->close();
    }
    return $response;
}
/*
FUNCTION NAME       -   getStateRegion
DESCRIPTION         -   Get the State details.
INPUT PARAMETER     -   Integer country_id.
OUTPUT PARAMETER    -   Returns all the rows queried
*/
function getStateRegion($country_id)
{
    $response = array();
    $response['data']= array();
    $stmt_state = $this->conn_sms->prepare("SELECT `zone_id`,`name` FROM oc_zone WHERE country_id = ?");
    $stmt_state->bind_param("i",$country_id);
    if($stmt_state->execute())
    {
        $stmt_state->bind_result($zone_id,$name);
        $arr= array();
        
        while($stmt_state->fetch())
        {
            $arr['zone_id'] = $zone_id;
            $arr['name'] = $name;
            array_push($response['data'],$arr); 
            unset($arr);
        } 
        $response['error'] = false;
        $stmt_state->close();
    }
    else
    {
        $response['error']=true;
        $response['errorCode']=2;            
    }
    return $response;  
}
/*
FUNCTION NAME       -   getRegions
DESCRIPTION         -   Get the Region details.
INPUT PARAMETER     -   Integer zone_id.
OUTPUT PARAMETER    -   Returns all the rows queried
*/
function getRegions($zone_id)
{
    $response = array();
    $response['data']= array();
    $stmt_region = $this->conn_sms->prepare("SELECT `region_id`,`region_name`,`pin` FROM oc_region WHERE zone_id = ?");
    $stmt_region->bind_param("i",$zone_id);
    if($stmt_region->execute())
    {
        $stmt_region->bind_result($region_id,$region_name,$pin);
        $arr= array();
        while($stmt_region->fetch())
        {
            $arr['region_id'] = $region_id;
            $arr['region_name'] = $region_name;
            $arr['pin'] = $pin;
            array_push($response['data'],$arr);
            unset($arr); 
        } 
        $response['error'] = false;
        $stmt_region->close();
    }
    else
    {
        $response['error']=true;
        $response['errorCode']=2;            
    }
    return $response;  
}
/*
FUNCTION NAME       -   getOperatorDetail
DESCRIPTION         -   getting details of operator.
INPUT PARAMETER     -   Integer operator_id.
OUTPUT PARAMETER    -   Returns all the rows queried
*/
function getOperatorDetail($operator_id)
{
    $response=array();
    $response['data'] = array();
    $andClause = '';
    $whereClause = '';
    if($operator_id !=1)
    {
        $andClause =" AND operator_id= ?";
        $whereClause =" WHERE operator_id =?";
    }
        $stmt_stb = $this->conn_sms->prepare("SELECT count(*) from `oc_stb` ".$whereClause);
        $stmt_stb->bind_param("i",$operator_id);
        if($stmt_stb->execute())
        {
            $stmt_stb->bind_result($STB_count);
            if($stmt_stb->fetch())
            {
                $response['error']=false;
                $response['data']['STB_count']=$STB_count;
            }
            else
            {
                $response['error']=true;
                $response['errorCode']=2;            
            }
            $stmt_stb->close();

        }
        $stmt = $this->conn_sms->prepare("SELECT t3.tot_customer,t2.unpaired,t1.paired
                                        FROM (SELECT 1 AS common_key, count(*) AS paired
                                        FROM oc_customer WHERE STBNO != '0' and STBNO !='' ".$andClause.") AS t1 JOIN (SELECT 1 AS common_key, count(*) AS unpaired 
                                        FROM oc_customer WHERE STBNO = '0' ".$andClause.") AS t2 ON t1.common_key JOIN (SELECT 1 AS common_key, count(*) AS tot_customer
                                        FROM oc_customer ".$whereClause.") AS t3 ON t1.common_key = t3.common_key;");
        $stmt->bind_param("iii",$operator_id,$operator_id,$operator_id);
        if($stmt->execute())
        {

            $stmt->bind_result($paired_STB,$unpaired_STB,$total_customer);
            if($stmt->fetch())
            {
                $response['error']=false;
                $response['data']['paired_STB'] =$paired_STB;
                $response['data']['unpaired_STB']=$unpaired_STB;
                $response['data']['total_customer']=$total_customer;
            }
            else
            {
                $response['error']=true;
                $response['errorCode']=2;            
            }
            $stmt->close();
        }
    return $response;
}
/*
FUNCTION NAME       -   searchStbNo
DESCRIPTION         -   search stb.
INPUT PARAMETER     -   Integer operator_id,String stb_no.
OUTPUT PARAMETER    -   Returns all the rows queried
*/
function searchStbNo($stb_no,$operator_id)
{
    $response = array();
    $response['data'] = array();
    $andClause='';
    if($operator_id != 1)
    {
        $andClause= " AND operator_id =?";
    }

    $stmt = $this->conn_sms->prepare("SELECT stb_no FROM oc_stb WHERE stb_no LIKE '%$stb_no%' ".$andClause." ");
    $stmt->bind_param("i",$operator_id);
    if($stmt->execute())
    {
        $stmt->bind_result($stb_no);
        $arr= array();
        while($stmt->fetch())
        {
            $arr['stb_no'] = $stb_no;
            array_push($response['data'],$arr);
            unset($arr);
        } 
        $response['error'] = false;
        $stmt->close();
    }
    else
    {
        $response['error']=true;
        $response['errorCode']=2;            
    }  
    return $response;  
}
/*
FUNCTION NAME       -   getCommandList
DESCRIPTION         -   Checking command permissions.
INPUT PARAMETER     -   Integer operator_id,String stb_no.
OUTPUT PARAMETER    -   Returns all the rows queried
*/
function getCommandList($stb_no,$operator_id)
{
    $response=array();
    $response['data'] = array();
    $is_active = $this->isSTBActiveted($stb_no);
    $is_suspend= $this->isSTBSuspended($stb_no); 
    $stmt = $this->conn_sms->prepare("SELECT `command_id`,`command_name`,`command_flag` FROM oc_app_commands WHERE operator_id = ?");
    $stmt->bind_param("i",$operator_id);
     if($stmt->execute())
        {
            $arr= array();
            $stmt->bind_result($command_id,$command_name,$command_flag);
            while($stmt->fetch())
            {
                 $arr['command_id']         = $command_id;
                 $arr['command_name']       = $command_name;
                 $arr['command_flag']       = $command_flag;
                 $arr['sms_stb_active_status']  = $is_active;
                 $arr['sms_stb_suspend_status'] = $is_suspend;
                 array_push($response['data'],$arr); 
                 unset($arr); 
            }
            $response['error'] = false;
            $stmt->close();
        }    
    else
    {
        $response['error']=true;
        $response['message']=2;            
    }
return $response;
}

/*
FUNCTION NAME       -   getNetworkDetails
DESCRIPTION         -   Get the Network details.
INPUT PARAMETER     -   none.
OUTPUT PARAMETER    -   Returns all the rows queried
*/
function getNetworkDetails()
{
    $response = array();
    $response['data']= array();
    $stmt = $this->conn_sms->prepare("SELECT `value` FROM oc_setting WHERE `key` IN('config_owner','config_address','config_email','config_telephone')" );
    if($stmt->execute())
    {
        $stmt->bind_result($value);
        $arr= array();
        while($stmt->fetch())
        {
            $arr['value'] = $value;
            array_push($response['data'],$arr);
            unset($arr); 
        }
        
        $response['error'] = false;
        $stmt->close();
    }
    return $response;
}
/*********************************************************************************************************************/
                                            /*Validation Function*/
/********************************************************************************************************************/
public function ValidateOperator($operator_id){
        $response =array();
        $stmt_user = $this->conn_sms->prepare("SELECT status,sdk_enabled,is_suspend FROM oc_user where user_id= ?");
        $stmt_user->bind_param("i",$operator_id);
        $stmt_user->execute();
        $stmt_user->bind_result($status,$sdk_enabled,$is_suspend);
        $stmt_user->fetch();
        $stmt_user->close();
        if($status!=1)
        {
            $response['error']=true;
            $response['errorCode']=5;
        } 
        else if($sdk_enabled!=1)
        {
            $response['error']=true;
            $response['errorCode'] = 3;
        }
        else if($is_suspend==1)
        {
            $response['error']=true;
            $response['errorCode'] = 6;
        }
        return $response;
}
public function ValidateSTB($stb_no,$operator_id){
    $response =array();

    $stmt_map_stb_op = $this->conn_sms->prepare("SELECT operator_id FROM oc_stb WHERE stb_no = ?");
    $stmt_map_stb_op->bind_param("s",$stb_no);
    $stmt_map_stb_op->execute();
    $stmt_map_stb_op->bind_result($currentOperatorId);
    $stmt_map_stb_op->fetch();
    $stmt_map_stb_op->close();
    if($operator_id!=1)
    {    
        /***********Stb move to lco********************/
        if($operator_id!=$currentOperatorId)
        {    
            $response['error']=true;
            $response['errorCode']=27; 
        }
        else
        {
            $stmt_rma = $this->conn_sms->prepare("SELECT is_black_list,box_status FROM oc_stb where stb_no= ? ");
            $stmt_rma->bind_param("s",$stb_no);
            $stmt_rma->execute();
            $stmt_rma->bind_result($is_black_list,$box_status);
            $stmt_rma->fetch();
            $stmt_rma->close();
            if($is_black_list == 1)
            {
                $response['error']=true;
                $response['errorCode']=7; 
            } 
            else if($box_status == 1) 
            {
                $response['error']=true;
                $response['errorCode']=8; 
            }
        } 
    }
    else
    {
            $stmt_rma = $this->conn_sms->prepare("SELECT is_black_list,box_status FROM oc_stb where stb_no= ? ");
            $stmt_rma->bind_param("s",$stb_no);
            $stmt_rma->execute();
            $stmt_rma->bind_result($is_black_list,$box_status);
            $stmt_rma->fetch();
            $stmt_rma->close();
            if($is_black_list == 1)
            {
                $response['error']=true;
                $response['errorCode']=7; 
            } 
            else if($box_status == 1) 
            {
                $response['error']=true;
                $response['errorCode']=8; 
            }

    }   
    return $response;
}
public function isSTBActive($stb_no,$stb_flag){
    $response =array();
    $stmt = $this->conn_sms->prepare("SELECT count(*) as count FROM oc_activationDeactivation aa
                inner join (select max(id) as id from oc_activationDeactivation ad group by user_id ) A
                on aa.id = A.id where cmd_id =0 and exp_date >now() and aa.stbno = ? ");
                $stmt->bind_param("s",$stb_no);
                $stmt->execute();
                $stmt->bind_result($count);
                $stmt->fetch();
                $stmt->close();
                if($count>0)
                   {
                        $stmt_cust = $this->conn_sms->prepare("SELECT count(*) as cust_count FROM oc_customer where STBNO = ? and status = 1");
                        $stmt_cust->bind_param("s",$stb_no);
                        $stmt_cust->execute();
                        $stmt_cust->bind_result($cust_count);
                        $stmt_cust->fetch();
                        $stmt_cust->close();
                        if($cust_count>0){
                            $response['error']=false;
                            $response['errorCode']=22; 
                        }
                        else
                        {
                            $response['error']=true;
                            $response['errorCode']=9;  
                        }  
                    }
                    else
                    {
                        if($stb_flag==1)
                        {    
                            $response['error']=false;
                            $response['errorCode']=22;          
                        }
                        else
                        {
                            $response['error']=true;
                            $response['errorCode']=100;  
                        }    
                    }
                    return $response;
}
public function isValidate($stb_no,$operator_id,$stb_flag)
{
    $response = array(); 
    $op = $this->ValidateOperator($operator_id);
    if($op['error']){
        foreach ($op as $key => $value) {
            $response[$key]=$value;
        }
    }else{
        $vstb = $this->ValidateSTB($stb_no,$operator_id);
        if($vstb['error']){
            foreach ($vstb as $key => $value) {
                $response[$key]=$value;
            }
        }else{
            $isStbActive = $this->isSTBActive($stb_no,$stb_flag);
            foreach ($isStbActive as $key => $value) {
                $response[$key]=$value;
            }
        }
    }
    return $response;
}
public function isStatus($stb_no)
{
    $response =array();
    $stmt_cust = $this->conn_sms->prepare("SELECT count(*) as cust_count FROM oc_customer where STBNO = ? and status = 1");
    $stmt_cust->bind_param("s",$stb_no);
    $stmt_cust->execute();
    $stmt_cust->bind_result($cust_count);
    $stmt_cust->fetch();
    $stmt_cust->close();
    if($cust_count>0){
        $response['error']=false;
        $response['errorCode']=22; 
    }
    else
    {
        $response['error']=true;
        $response['errorCode']=9;  
    }
    return $response;  
}
public function getStatusOfOperator($operator_id)
{
    $stmt_op_status = $this->conn_sms->prepare("SELECT `is_suspend` FROM oc_user WHERE user_id = ?");
    $stmt_op_status->bind_param("i",$operator_id);
    $stmt_op_status->execute();
    $stmt_op_status->bind_result($is_suspend);
    $stmt_op_status->fetch();
    $stmt_op_status->close();
    return $is_suspend;
}
/*
FUNCTION NAME       -   validateCustomerData
DESCRIPTION         -   Validating the customer fields.
INPUT PARAMETER     -   Integer sc_no,Integer mobile_no,String stb_no, Integer operator_id, Integer stb_flag.
OUTPUT PARAMETER    -   Returns all the rows queried
*/
public function validateCustomerData($sc_no,$mobile_no,$stb_no,$operator_id,$stb_flag){
    $error =0;
    $response=array();
    $StbValidate = $this->isValidate($stb_no,$operator_id,$stb_flag);
    if($StbValidate['error']===true){
        $error=1;
        foreach ($StbValidate as $key => $value) {
            $response[$key]=$value;
        }
    }
    $stmt_cust = $this->conn_sms->prepare("SELECT * FROM oc_customer WHERE SCNO = ?");
    $stmt_cust->bind_param("i",$sc_no);
    $stmt_cust->execute();
    $stmt_cust->store_result();
    $num_rows = $stmt_cust->num_rows;
    $stmt_cust->close();
    if($num_rows > 0){
        $response['error']=1;
        $response['errorCode']=13;
    }

    $stmt_phone = $this->conn_sms->prepare("SELECT * FROM oc_customer WHERE telephone = ?");
    $stmt_phone->bind_param("i",$mobile_no);
    $stmt_phone->execute();
    $stmt_phone->store_result();
    $num_rows = $stmt_phone->num_rows;
    $stmt_phone->close();
    if($num_rows > 0)   {
        $response['error']=1;
        $response['errorCode']=14;
    }
    return $response;
}


/*
FUNCTION NAME       -   isSTBActiveted
DESCRIPTION         -   Checking stb active status.
INPUT PARAMETER     -   String stb_no.
OUTPUT PARAMETER    -   Returns all the rows queried
*/
private function isSTBActiveted($stb_no)
{
    $stmt_active = $this->conn_sms->prepare("SELECT count(*) as count FROM oc_activationDeactivation aa
               inner join (select max(id) as id from oc_activationDeactivation ad group by user_id ) A
               on aa.id = A.id where cmd_id =0 and exp_date >now() and aa.stbno = ?");
    $stmt_active->bind_param("s",$stb_no);
    $stmt_active->execute();
    $stmt_active->bind_result($is_active);
    $stmt_active->fetch();
    $stmt_active->close();
    return $is_active;
}
/*
FUNCTION NAME       -   isSTBSuspended
DESCRIPTION         -   Checking stb suspend status.
INPUT PARAMETER     -   String stb_no.
OUTPUT PARAMETER    -   Returns all the rows queried
*/
public function isSTBSuspended($stb_no)
{
    $stmt_suspend = $this->conn_sms->prepare("SELECT `is_suspend` FROM `oc_stb` WHERE stb_no = ?");
    $stmt_suspend->bind_param("s",$stb_no);
    $stmt_suspend->execute();
    $stmt_suspend->bind_result($is_suspend);
    $stmt_suspend->fetch();
    $stmt_suspend->close();
    return $is_suspend;
}

public function getCommandPermission($command_id_per,$operator_id)
{
    $stmt = $this->conn_sms->prepare("SELECT count(*) as permission FROM `oc_app_commands` WHERE command_id=? AND operator_id = ?");
    $stmt->bind_param("ii",$command_id_per,$operator_id);
    $result=$stmt->execute();
    $stmt->bind_result($permission);
    $stmt->fetch();
    $stmt->close();
    return $permission;
}
/**
* Checking operator_id
* @param Integer operator_id
* @return boolean
*/
function getOperatorID($stb_no)
{
    $response=array();
    $stmt = $this->conn_sms->prepare("SELECT s.operator_id FROM oc_stb s INNER JOIN oc_user u ON s.operator_id = u.user_id WHERE s.stb_no = ?");
    $stmt->bind_param("s",$stb_no);
    $stmt->execute();
    $stmt->bind_result($operator_id);
    $stmt->fetch();
    $stmt->close();
    if($operator_id>0)
    {
        $response['error']=false;
        $response['operator_id']=$operator_id; 
    }
    else
    {
        $response['error']=1;
        $response['errorCode']=5;  
    }  
    return $response;

}

/*
FUNCTION NAME            -   getRecentTransaction
DESCRIPTION              -   Get the Command details.
INPUT PARAMETER          -   $username,$password.
OUTPUT PARAMETER         -   Returns all the rows queried
HARD-CODED O/P PARAMETERS -  3=>error box activation,5=>error customer_id,7=>transaction_id.
*/  
function getRecentTransaction($stb_no,$command_id,$operator_id)
{
    $response=array();
    $response['data'] = array();
    $date = new DateTime("now",new DateTimeZone('Asia/Calcutta'));  
    $date_1 = $date->getTimestamp();
    $is_active = $this->isSTBActiveted($stb_no);
    $exp_date  = $this->isBoxExpired($stb_no,$operator_id);
    $expiry_time = strtotime($exp_date);
    if($is_active == 1)
    {
        if($expiry_time > $date_1)
        {  
            $result_cust = $this->custDetails($stb_no,$operator_id);
            $customer_id    = $result_cust['data']['customer_id'];  
            if($command_id == 0 || $command_id == 6 || $command_id == 23 || $command_id == 10)
            {  
                $stmt_cmd = $this->conn_sms->prepare("SELECT MAX(tx_id) AS tx_id FROM oc_cas_op_transactions cas WHERE cas.user_id = ? AND cas.cmd_id = ? GROUP BY cas.user_id");
                $stmt_cmd->bind_param("ii",$customer_id,$command_id);
                if($stmt_cmd->execute())
                {
                    $arr= array();
                    $stmt_cmd->bind_result($tx_id);
                    $stmt_cmd->fetch();
                    $stmt_cmd->close();
                    $response['errorCode'] = 0;
                    $response['error'] = false;
                } 
            }
            else
            {
                $response['error']=true;
                $response['errorCode'] = 2;
            }
        }
        else
        {
            $response['error']=true;
            $response['errorCode'] = 19;
           
        }        
    }
    else
    {
        $response['error']=true;
        $response['errorCode'] = 20;
    }
    $stmt = $this->conn_sms->prepare("SELECT `tx_id`,`cmd_id`,`target_level`,`user_id`,`exp_date` FROM oc_cas_op_transactions WHERE tx_id = ? AND user_id = ? AND cmd_id = ?");
    $stmt->bind_param("iii",$tx_id,$customer_id,$command_id);
    if($stmt->execute())
    {
        $arr= array();
        $stmt->bind_result($tx_id,$cmd_id,$target_level,$user_id,$exp_date);
        while($stmt->fetch())
            {
            $arr['tx_id']              = $tx_id;
            $arr['cmd_id']             = $cmd_id;
            $arr['target_level']       = $target_level;
            $arr['user_id']            = $user_id; 
            $arr['exp_date']           = $exp_date;
            array_push($response['data'],$arr); 
            unset($arr); 
        }
        $stmt->close();
    }    
    else
    {
        $response['error']=true;
        $response['errorCode']   = 2; 
    }
    return $response;
}
/*
FUNCTION NAME            -   packageStatus
DESCRIPTION              -   packageStatus .
INPUT PARAMETER          -   $product_no.
OUTPUT PARAMETER         -   Returns all the rows queried.
*/ 
function packageStatus($product_id,$stb_no,$operator_id)
{

    $result_cust = $this->custDetails($stb_no,$operator_id);
    $customer_id    = $result_cust['data']['customer_id'];
    
    $response = array(); 
    $stmt = $this->conn_sms->prepare("SELECT tx_id,cmd_id FROM oc_cas_op_transactions WHERE cmd_id !=11 AND product_id = ? AND user_id = ? ORDER BY id desc limit 1");
    $stmt->bind_param("ii",$product_id,$customer_id);
    $stmt->execute();
    $stmt->bind_result($tx_id,$cmd_id);
    $stmt->fetch();
    if($cmd_id != 7)
       {
            $response['error']=false;
            $response['errorCode']=0;
        }
       else
        {
            $response['error']=true;
            $response['errorCode']=21;
        }
    return $response;

}
/*
FUNCTION NAME            -   productStatus
DESCRIPTION              -   productStatus .
INPUT PARAMETER          -   $product_id,$stb_no,$operator_id.
OUTPUT PARAMETER         -   Returns all the rows queried.
*/ 
function productStatus($product_id,$stb_no,$operator_id)
{

    $result_cust = $this->custDetails($stb_no,$operator_id);
    $customer_id    = $result_cust['data']['customer_id'];
    
    $response = array(); 
    $stmt = $this->conn_sms->prepare("SELECT tx_id,cmd_id FROM oc_cas_op_transactions WHERE cmd_id !=7 AND product_id = ? AND user_id = ? ORDER BY id desc limit 1");
    $stmt->bind_param("ii",$product_id,$customer_id);
    $stmt->execute();
    $stmt->bind_result($tx_id,$cmd_id);
    $stmt->fetch();
    if($cmd_id != 11)
       {
            $response['error']=false;
            $response['errorCode']=0;
        }
       else
        {
            $response['error']=true;
            $response['errorCode']=21;
        }
    return $response;

}
/*
FUNCTION NAME       -   getPackages
DESCRIPTION         -   Checking Package List.
INPUT PARAMETER     -   none.
OUTPUT PARAMETER    -   Returns all the rows queried
*/
function getPackages($region_id)
{
    $response = array();
    $response['data'] = array();
    $stmt = $this->conn_sms->prepare("SELECT pd.product_id,pd.name,p.tax_class_id,p.package_type,p.broadcaster_id FROM `oc_product` p inner join `oc_product_description` pd on p.product_id = pd.product_id WHERE p.region_id = ? OR p.region_id ='0'  AND p.is_package=1 AND p.status = 1");
    $stmt->bind_param("i",$region_id);
    if($stmt->execute())
    {
        $stmt->bind_result($package_id,$name,$tax_class_id,$package_type,$broadcaster_id);
        $arr= array();
        while($stmt->fetch())
        {
            $arr['package_id'] = $package_id;
            $arr['name'] = $name;
            $arr['tax_class_id'] = $tax_class_id;
            $arr['package_type'] = $package_type;
            $arr['broadcaster_id'] = $broadcaster_id;
            array_push($response['data'],$arr); 
            unset($arr);
        } 
        $response['error'] = false;
        $stmt->close();
    }
    return $response;
}
/*
FUNCTION NAME       -   getPackageDetails
DESCRIPTION         -   Checking Package Details.
INPUT PARAMETER     -   Integer package_id.
OUTPUT PARAMETER    -   Returns all the rows queried
*/
function getPackageDetails($package_id)
{
    $response=array();
    $response['data'] = array();
    $stmt = $this->conn_sms->prepare("SELECT pv.product_id,pv.option_value_id,pv.price,od.name,p.name 
            FROM `oc_product_option_value` pv 
            INNER join `oc_option_value_description` od on pv.option_value_id = od.option_value_id AND pv.option_id = od.option_id 
            INNER join `oc_product_description` p on pv.product_id = p.product_id 
            where pv.product_id = ?");
    $stmt->bind_param("i", $package_id);
    if($stmt->execute())
    {
        $arr= array();
        $stmt->bind_result($package_id,$option_value_id,$price,$name_option,$name);
        while($stmt->fetch())
        {
            
            $arr['option_value_id'] = $option_value_id;
            $arr['price'] = $price;
            $arr['name_option'] = $name_option;
            array_push($response['data'],$arr); 
            unset($arr);
        } 
        $response['error'] = false;
        $stmt->close();
    }

return $response;
}
public function getTaxRate($stb_no,$operator_id,$customer_id,$value,$tax_class_id){
        
        $response=array();
               
        $cust_details = $this->custDetails($stb_no,$operator_id);
        $customer_group_id = $cust_details['data']['group_id'];
        $country_id = $cust_details['data']['country_id'];
        $zone_id = $cust_details['data']['zone_id'];

        $stmt_casop = $this->conn_sms->prepare("SELECT tr2.tax_rate_id, tr2.name, tr2.rate, tr2.type, tr1.priority FROM oc_tax_rule tr1 LEFT JOIN oc_tax_rate tr2 ON (tr1.tax_rate_id = tr2.tax_rate_id) INNER JOIN oc_tax_rate_to_customer_group tr2cg ON (tr2.tax_rate_id = tr2cg.tax_rate_id) LEFT JOIN oc_zone_to_geo_zone z2gz ON (tr2.geo_zone_id = z2gz.geo_zone_id) LEFT JOIN oc_geo_zone gz ON (tr2.geo_zone_id = gz.geo_zone_id) WHERE tr1.tax_class_id = ? AND tr2cg.customer_group_id = ? AND z2gz.country_id = ? AND (z2gz.zone_id = '0' OR z2gz.zone_id = ?) ORDER BY tr1.priority ASC");  
        $stmt_casop->bind_param("iiii",$tax_class_id,$customer_group_id,$country_id,$zone_id);      
        if($stmt_casop->execute())
        {
            $stmt_casop->store_result();    
            $stmt_casop->bind_result($tax_rate_id,$name,$rate,$type,$priority);
            $arr= array();
            while($stmt_casop->fetch())
            {
                $amount = 0;
                $arr['tax_rate_id'] = $tax_rate_id;
                $arr['name'] = $name;
                $arr['rate'] = $rate;
                $arr['type'] = $type;
                $arr['priority'] = $priority;
                if($type=='F')
                {
                    $amount =$rate;
                    $arr['amount'] = $amount;
                }
                else if($type=='P')
                {
                    $amount +=($value/100*$rate);
                    $arr['amount'] = $amount;    
                }
                array_push($response,$arr); 
                unset($arr);
            } 
            $stmt_casop->close();
        }       
        return $response;
  
    }

/*
*
*           Product Subscription
*
*/
/*
FUNCTION NAME       -   getProducts
DESCRIPTION         -   Checking Products List.
INPUT PARAMETER     -   none.
OUTPUT PARAMETER    -   Returns all the rows queried
*/
function getProducts()
{
    $response = array();
    $response['data'] = array();
    $stmt = $this->conn_sms->prepare("SELECT pd.product_id,pd.name,p.tax_class_id,p.package_type,p.broadcaster_id FROM `oc_product` p inner join `oc_product_description` pd on p.product_id = pd.product_id WHERE p.is_package!=1 AND p.status = 1 limit 0,346");
    if($stmt->execute())
    {
        $stmt->bind_result($product_id,$name,$tax_class_id,$package_type,$broadcaster_id);
        $arr= array();
        while($stmt->fetch())
        {

            $arr['product_id'] = $product_id;
            $arr['name'] = $name;
            $arr['tax_class_id'] = $tax_class_id;
            $arr['package_type'] = $package_type;
            $arr['broadcaster_id'] = $broadcaster_id;
            array_push($response['data'],$arr); 
            unset($arr);
        } 
        $response['error'] = false;
        $stmt->close();
    }
    return $response;
}
/*
FUNCTION NAME       -   getProductDetails
DESCRIPTION         -   Checking Product Details.
INPUT PARAMETER     -   Integer product_id.
OUTPUT PARAMETER    -   Returns all the rows queried
*/
function getProductDetails($product_id)
{
    $response=array();
    $response['data'] = array();
    $stmt = $this->conn_sms->prepare("SELECT pv.product_id,pv.option_value_id,pv.price,od.name,p.name 
            FROM `oc_product_option_value` pv 
            INNER join `oc_option_value_description` od on pv.option_value_id = od.option_value_id AND pv.option_id = od.option_id 
            INNER join `oc_product_description` p on pv.product_id = p.product_id 
            where pv.product_id = ?");
    $stmt->bind_param("i", $product_id);
    if($stmt->execute())
    {
        $arr= array();
        $stmt->bind_result($product_id,$option_value_id,$price,$name_option,$name);
        while($stmt->fetch())
        {
            
            $arr['option_value_id'] = $option_value_id;
            $arr['price'] = $price;
            $arr['name_option'] = $name_option;
            array_push($response['data'],$arr); 
            unset($arr);
        } 
        $response['error'] = false;
        $stmt->close();
    }
return $response;
}



/*
FUNCTION NAME       -   isLCO_MSO_PAYMENT
DESCRIPTION         -   Checking LCO Credit Amount.
INPUT PARAMETER     -   Integer package_id,Integer package_id,Integer option_id_new.
OUTPUT PARAMETER    -   Returns all the rows queried
*/

function isLCO_MSO_PAYMENT($operator_id,$package_id,$option_id_new)
{
    $response = array(); 
    $response['error']=false;
        if(MSO_LCO_PAYMENT==0)
        {
            if($operator_id!=1)
            {
                $stmt = $this->conn_sms->prepare("SELECT credit FROM oc_user WHERE user_id = ?");
                $stmt->bind_param("i",$operator_id);
                $result = $stmt->execute();
                $stmt->bind_result($credit);
                $stmt->fetch();
                $stmt->close();

                $stmt_price = $this->conn_sms->prepare("SELECT `price` FROM `oc_product_option_value` o INNER JOIN oc_option_value_description p ON p.option_value_id = o.option_value_id WHERE p.option_value_id = ? AND o.product_id = ?");
                $stmt_price->bind_param("si",$option_id_new,$package_id);
                $stmt_price->execute();
                $stmt_price->bind_result($price);
                $stmt_price->fetch();
                $stmt_price->close();

                $stmt_base_price = $this->conn_sms->prepare("SELECT price FROM oc_product WHERE product_id = ?");
                $stmt_base_price->bind_param("i",$package_id);
                $result = $stmt_base_price->execute();
                $stmt_base_price->bind_result($baseprice);
                $stmt_base_price->fetch();
                $stmt_base_price->close();

                $stmt_tax_price = $this->conn_sms->prepare("SELECT value FROM  `oc_setting` WHERE  `key` LIKE 'flat_cost'");
                $result = $stmt_tax_price->execute();
                $stmt_tax_price->bind_result($taxprice);
                $stmt_tax_price->fetch();
                $stmt_tax_price->close();

                $stmt_e_tax_price = $this->conn_sms->prepare("SELECT rate FROM  `oc_tax_rate` WHERE  `name` LIKE 'Eco Tax (-2.00)'");
                $result = $stmt_e_tax_price->execute();
                $stmt_e_tax_price->bind_result($e_tax);
                $stmt_e_tax_price->fetch();
                $stmt_e_tax_price->close();
                
                $total_price = $price + $baseprice + $taxprice+$e_tax;
                if($credit<$total_price)
                    {
                        $response['error']=true;
                        $response['errorCode']=16;
                    }    
                }
            }
            else
            {
                 $response['error']=false;
            }
return $response;   
}
/*
FUNCTION NAME       -   getSubscribed_Package
DESCRIPTION         -   Checking for Subscribed Packages.
INPUT PARAMETER     -   String stb_no.
OUTPUT PARAMETER    -   Returns all the rows queried
*/
function getSubscribed_Package($stb_no)
{
    $response=array();
    $response['data'] = array();
    $is_active = $this->isSTBActiveted($stb_no);
    if($is_active>0)
    { 
        $stmt = $this->conn_sms->prepare("SELECT `customer_id` FROM oc_customer WHERE STBNO = ?");
        $stmt->bind_param("s",$stb_no);
        $stmt->execute();
        $stmt->bind_result($customer_id);
        $stmt->fetch();
        $stmt->close();
        $stmt_casop = $this->conn_sms->prepare("SELECT dd.product_id,pd.name,p.model AS product_number,package_type,modify_date, exp_date 
        FROM oc_subscriptionDesubscription dd INNER JOIN
        (
            SELECT max(id) AS maxId FROM 
            oc_subscriptionDesubscription a 
            WHERE user_id = ?
            AND cmd_id IN (6,7)
            GROUP BY user_id ,product_id
        ) A ON dd.id = A.maxId 
        INNER JOIN oc_product p ON p.product_id = dd.product_id 
        INNER JOIN oc_product_description pd ON pd.product_id = dd.product_id 
        WHERE p.is_package = 1 AND p.is_nvod = 0 AND p.is_ppv = 0 AND cmd_id =6 AND exp_date > NOW()");    
        $stmt_casop->bind_param("i",$customer_id);     
        if($stmt_casop->execute())
        {
            $stmt_casop->store_result();    
            $stmt_casop->bind_result($product_id,$name,$product_number,$package_type,$modify_date,$exp_date);
            $arr= array();
            while($stmt_casop->fetch())
            {
                $arr['model'] = $product_number;
                $arr['product_id'] = $product_id;
                $arr['name'] = $name;
                $arr['package_type'] = $package_type;
                $arr['broadcaster_id'] = $broadcaster_id;
                array_push($response['data'],$arr); 
                unset($arr);
            } 
            $response['error'] = false;
            $stmt_casop->close();
        }       
        else
        {
            $response['error']=true;
            $response['errorCode']=2;            
        }
        
    }
    else
    {
        $response['error']=true;
        $response['errorCode']=10;            
    }    
return $response;
}
/*
FUNCTION NAME       -   getSubscribed_Products
DESCRIPTION         -   Checking for Subscribed Packages.
INPUT PARAMETER     -   String stb_no.
OUTPUT PARAMETER    -   Returns all the rows queried
*/
function getSubscribed_Product($stb_no)
{
    $response=array();
    $response['data'] = array();
    $is_active = $this->isSTBActiveted($stb_no);
    if($is_active>0)
    { 
        $stmt = $this->conn_sms->prepare("SELECT `customer_id` FROM oc_customer WHERE STBNO = ?");
        $stmt->bind_param("s",$stb_no);
        $stmt->execute();
        $stmt->bind_result($customer_id);
        $stmt->fetch();
        $stmt->close();
        $stmt_casop = $this->conn_sms->prepare("SELECT dd.product_id,pd.name,p.model AS product_number,package_type,modify_date, exp_date 
        FROM oc_subscriptionDesubscription dd INNER JOIN
        (
            SELECT max(id) AS maxId FROM 
            oc_subscriptionDesubscription a 
            WHERE user_id = ?
            AND cmd_id IN (10,11)
            GROUP BY user_id ,product_id
        ) A ON dd.id = A.maxId 
        INNER JOIN oc_product p ON p.product_id = dd.product_id 
        INNER JOIN oc_product_description pd ON pd.product_id = dd.product_id 
        WHERE p.is_package = 0 AND p.is_nvod = 0 AND p.is_ppv = 0 AND cmd_id =10 AND exp_date > NOW()");    
        $stmt_casop->bind_param("i",$customer_id);     
        if($stmt_casop->execute())
        {
            $stmt_casop->store_result();    
            $stmt_casop->bind_result($product_id,$name,$product_number,$package_type,$modify_date,$exp_date);
            $arr= array();
            while($stmt_casop->fetch())
            {
                $arr['model'] = $product_number;
                $arr['product_id'] = $product_id;
                $arr['name'] = $name;
                $arr['package_type'] = $package_type;
                $arr['broadcaster_id'] = $broadcaster_id;
                array_push($response['data'],$arr); 
                unset($arr);
            } 
            $response['error'] = false;
            $stmt_casop->close();
        }       
        else
        {
            $response['error']=true;
            $response['errorCode']=2;            
        }
        
    }
    else
    {
        $response['error']=true;
        $response['errorCode']=10;            
    }    
return $response;
}
/*
FUNCTION NAME       -   getKMSPackageID
DESCRIPTION         -   KMS Package ID.
INPUT PARAMETER     -   Integer package_id.
OUTPUT PARAMETER    -   Returns all the rows queried
*/
public function getKMSPackageID($package_id)
{
    $stmt = $this->conn_sms->prepare("SELECT api_product_id FROM `oc_sms_kms_product` WHERE product_id = ? AND is_package = 1 ");
    //$stmt = $this->conn_sms->prepare("SELECT api_product_id FROM `oc_product` WHERE product_id = ? AND is_package = 1 ");
    $stmt->bind_param("i",$package_id);
    $stmt->execute();
    $stmt->bind_result($kmsPackageId);
    $stmt->fetch();
    $stmt->close();
    return $kmsPackageId;  
}

/*
FUNCTION NAME       -   getKMSProductID
DESCRIPTION         -   KMS Product ID.
INPUT PARAMETER     -   Integer product_id.
OUTPUT PARAMETER    -   Returns all the rows queried
*/
public function getKMSProductID($product_id)
{
    $stmt = $this->conn_sms->prepare("SELECT api_product_id FROM `oc_sms_kms_product` WHERE product_id = ? AND is_package != 1");
    $stmt->bind_param("i",$product_id);
    $stmt->execute();
    $stmt->bind_result($kmsPackageId);
    $stmt->fetch();
    $stmt->close();
    return $kmsPackageId;
}

/*
FUNCTION NAME       -   getKmsUserID
DESCRIPTION         -   KMS User ID.
INPUT PARAMETER     -   Integer user_id.
OUTPUT PARAMETER    -   Returns all the rows queried
*/
public function getKmsUserID($stb_no)
{
    $stmt = $this->conn_kms->prepare("SELECT u.user_id FROM `users` u LEFT JOIN stb s ON u.stb_id = s.stb_id WHERE stb_no = ? ");
    $stmt->bind_param("s",$stb_no);
    $stmt->execute();
    $stmt->bind_result($user_id_kms);
    $stmt->fetch();
    $stmt->close();
    return $user_id_kms;
}
/*
FUNCTION NAME       -   getSubscriptionDate
DESCRIPTION         -   Calculating Date.
INPUT PARAMETER     -   Integer option_id.
OUTPUT PARAMETER    -   Returns all the rows queried
*/
function getSubscriptionDate($option_id)
{
    $response = array();
    $stmt = $this->conn_sms->prepare("SELECT `name` FROM `oc_option_value_description` WHERE `option_value_id` = ?");
    $stmt->bind_param("i",$option_id);
    $stmt->execute();
    $stmt->bind_result($name_option);
    $stmt->fetch();
    $stmt->close(); 

    $digit=explode(" ", $name_option);
    $now_datetime = new DateTime("now", new DateTimeZone('Asia/Kolkata'));
    $start_time =  $now_datetime->getTimestamp(); 
   
    if($digit[1]==="hour") {
        $end_time = strtotime("+".$digit[0]." hour",$start_time);
    }elseif($digit[1]==="hours"){
        $end_time = strtotime("+".$digit[0]." hours",$start_time);
    }elseif($digit[1]==="day") {
        $end_time = strtotime("+".$digit[0]." day",$start_time);
    }elseif($digit[1]==="days"){
        $end_time = strtotime("+".$digit[0]." days",$start_time);
    }elseif($digit[1]==="month") {
        $end_time = strtotime("+".$digit[0]." month",$start_time);
    }elseif($digit[1]==="months"){
        $end_time = strtotime("+".$digit[0]." months",$start_time);
    }elseif ($digit[1]==="year") {
        $end_time = strtotime("+".$digit[0]." year",$start_time);
    }elseif ($digit[1]==="years") {
        $end_time = strtotime("+".$digit[0]." years",$start_time);
    }
    $response['start_time'] = $start_time;
    $response['end_time']=$end_time;
    $response['option']=$name_option;
    return $response;
}
/*
FUNCTION NAME       -   getValidOldSubscription
DESCRIPTION         -   Checking Old Package Subscription Details.
INPUT PARAMETER     -   Integer package_id,Integer user_id.
OUTPUT PARAMETER    -   Returns all the rows queried
*/
public function getValidOldSubscription($user_id,$package_id,$stb_no)
{

    $stmt = $this->conn_sms->prepare("SELECT sub.cmd_id,sub.exp_date FROM oc_subscriptionDesubscription sub
        inner join (select max(id) mId from oc_subscriptionDesubscription sd WHERE cmd_id IN (6,7) and user_id = ? and product_id = ? and stbno = ?
         group by user_id,product_id) y on sub.id = y.mId Where sub.cmd_id=6 and sub.exp_date > NOW()");
    $stmt->bind_param("iis",$user_id,$package_id,$stb_no);
    $stmt->execute();
    $stmt->bind_result($cmd_id,$exp_date);
    $stmt->fetch();
    $stmt->close();
    if($cmd_id)
        return $exp_date;
    else 
        return NULL;
}

/*
FUNCTION NAME       -   getValidOldSubscription
DESCRIPTION         -   Checking Old Package Subscription Details.
INPUT PARAMETER     -   Integer package_id,Integer user_id.
OUTPUT PARAMETER    -   Returns all the rows queried
*/
public function getValidOldSubscriptionForProduct($user_id,$product_id)
{
    $stmt = $this->conn_sms->prepare("SELECT sub.cmd_id,sub.exp_date FROM oc_subscriptionDesubscription sub
        inner join (select max(id) mId from oc_subscriptionDesubscription sd WHERE cmd_id IN (10,11) and user_id = ? and product_id = ?
         group by user_id,product_id) y on sub.id = y.mId Where sub.cmd_id=10 and sub.exp_date > NOW()");
    $stmt->bind_param("ii",$user_id,$product_id);
    $stmt->execute();
    $stmt->bind_result($cmd_id,$exp_date);
    $stmt->fetch();
    $stmt->close();
    if($cmd_id)
        return $exp_date;
    else 
        return NULL;
}


public function getPackageType($package_id)
{
    $stmt_pk_type = $this->conn_sms->prepare("SELECT package_type FROM `oc_product` WHERE product_id = ?");
    $stmt_pk_type->bind_param("i",$package_id);
    $stmt_pk_type->execute();
    $stmt_pk_type->bind_result($package_type);
    $stmt_pk_type->fetch();
    $stmt_pk_type->close();
    return $package_type;
}
/*
FUNCTION NAME       -   checkPackageSubscriptionAvailable
DESCRIPTION         -   Checking Package Subscription Details.
INPUT PARAMETER     -   Integer package_id,Integer user_id.
OUTPUT PARAMETER    -   Returns all the rows queried
*/
public function checkPackageSubscriptionAvailable($package_id,$user_id){
        $stmt = $this->conn_sms->prepare("SELECT id,user_id, exp_date FROM oc_subscriptionDesubscription WHERE cmd_id IN (6,7) and product_id = ? AND user_id = ? ORDER BY id DESC LIMIT 1");
        $stmt->bind_param("ii",$package_id,$user_id);
        $result=$stmt->execute();
        $stmt->bind_result($updateId,$customer_id,$expire_date);
        $stmt->store_result();
        $stmt->fetch();
        $row = $stmt->num_rows;
        $response=array();
        
        $date = new DateTime("now", new DateTimeZone('Asia/Kolkata'));
        $curr_date= $date->getTimestamp();
        if($result) 
        {
            if($row > 0)
            {
                $stmt->fetch();
                if(strtotime($expire_date) <= $curr_date)
                {
                    $response[0]=3; //if expiry date is less than current date with start date & end date
                }
                else
                {
                    $response[0]=1; // if expiry date not less than current date the update record by adding months in the end date
                    $response['expiry']=$expire_date;
                    $response['updateId']=$updateId;
                }
            }
            else
            {
                $response[0]=2; // new subscription
            }
        } 
        else 
        {
            $response[0]=2;
        }
        return  $response;
    }

/*
FUNCTION NAME       -   checkPackageSubscriptionAvailable
DESCRIPTION         -   Checking Package Subscription Details.
INPUT PARAMETER     -   Integer package_id,Integer user_id.
OUTPUT PARAMETER    -   Returns all the rows queried
*/
public function checkProductSubscriptionAvailable($product_id,$user_id){
        $stmt = $this->conn_sms->prepare("SELECT id,user_id, exp_date FROM oc_subscriptionDesubscription WHERE cmd_id IN (10,11) and product_id = ? AND user_id = ? ORDER BY id DESC LIMIT 1");
        $stmt->bind_param("ii",$product_id,$user_id);
        $result=$stmt->execute();
        $stmt->bind_result($updateId,$customer_id,$expire_date);
        $stmt->store_result();
        $stmt->fetch();
        $row = $stmt->num_rows;
        $response=array();
        
        $date = new DateTime("now", new DateTimeZone('Asia/Kolkata'));
        $curr_date= $date->getTimestamp();
        if($result) 
        {
            if($row > 0)
            {
                $stmt->fetch();
                if(strtotime($expire_date) <= $curr_date)
                {
                    $response[0]=3; //if expiry date is less than current date with start date & end date
                }
                else
                {
                    $response[0]=1; // if expiry date not less than current date the update record by adding months in the end date
                    $response['expiry']=$expire_date;
                    $response['updateId']=$updateId;
                }
            }
            else
            {
                $response[0]=2; // new subscription
            }
        } 
        else 
        {
            $response[0]=2;
        }
        return  $response;
    }    

/*
FUNCTION NAME       -   getSubscriptionStatus
DESCRIPTION         -   Checking Package Subscription Details.
INPUT PARAMETER     -   String stb_no,Integer operator_id.
OUTPUT PARAMETER    -   Returns all the rows queried
*/
function getSubscriptionStatus($stb_no,$operator_id)
{
    $result_cust  = $this->custDetails($stb_no,$operator_id);
    $customer_id  =   $result_cust['data']['customer_id'];
    
    $response = array();
    $stmt = $this->conn_sms->prepare("SELECT count(*) as isValid FROM oc_subscriptionDesubscription WHERE cmd_id IN(6,10) AND exp_date >= NOW() AND user_id = ? ");
    $stmt->bind_param("i",$customer_id);
    $stmt->execute();
    $stmt->bind_result($isValid);
    $stmt->fetch();
    $stmt->close();
    if($isValid > 0)
    {    
        $response['error']=true;
        $response['errorCode']=17;
    }
    else
    {
        $response['error']=false;
    }
    return $response;

}
/*
FUNCTION NAME       -   getIdsForExpiryUpdateBox
DESCRIPTION         -   Checking Box Details.
INPUT PARAMETER     -   Integer target.
OUTPUT PARAMETER    -   Returns all the rows queried
*/
public function getIdsForExpiryUpdateBox($target)
{
        $response = array();
        $stmt = $this->conn_sms->prepare("SELECT MAX(tx_id) as txid FROM oc_cas_op_transactions WHERE user_id = ? AND cmd_id = 1");
        $stmt->bind_param("i",$target);
        $result = $stmt->execute();
        $stmt->bind_result($txid);
        if($stmt->fetch())
        {
            if($txid==NULL)
            {
                $stmt->close();
                $stmt_update = $this->conn_sms->prepare("UPDATE oc_cas_op_transactions SET  exp_date = NOW() where user_id =?
                    and cmd_id=0");
                $stmt_update->bind_param("i",$target);
                $stmt_update->execute();
                $stmt_update->close();

                 $stmt_update = $this->conn_sms->prepare("UPDATE oc_activationDeactivation SET  exp_date = NOW() where user_id =?
                    and cmd_id=0");
                $stmt_update->bind_param("i",$target);
                $stmt_update->execute();
                $stmt_update->close();
                
                $response['error']=false;
            }else{
                $stmt->close();  
                $stmt_update = $this->conn_sms->prepare("UPDATE oc_cas_op_transactions SET  exp_date = NOW() WHERE user_id =? and cmd_id=0 and tx_id > ?");
                $stmt_update->bind_param("ii",$target,$txid);
                $stmt_update->execute();
                $stmt_update->close();

                 $stmt_update = $this->conn_sms->prepare("UPDATE oc_activationDeactivation SET  exp_date = NOW() WHERE user_id =? and cmd_id=0 and tx_id > ?");
                $stmt_update->bind_param("ii",$target,$txid);
                $stmt_update->execute();
                $stmt_update->close();

                $response['error']=false;
            }
        }
        else
        {
            $response['error']=true;
            $response['errorCode']=2;
        }
    return $response;  
}

/*
FUNCTION NAME       -   getIdsForExpiryUpdate
DESCRIPTION         -   Checking Package Details.
INPUT PARAMETER     -   Integer target,Integer product_id.
OUTPUT PARAMETER    -   Returns all the rows queried
*/
public function getIdsForExpiryUpdate($product_id,$target)
{
        $response = array();
        $stmt = $this->conn_sms->prepare("SELECT MAX(tx_id) as txid FROM oc_cas_op_transactions WHERE user_id= ? AND product_id= ? AND cmd_id=7");
        $stmt->bind_param("ii",$target,$product_id);
        $result = $stmt->execute();
        $stmt->bind_result($txid);
        if($stmt->fetch())
        {
            if($txid==NULL)
            {
                $stmt->close();
                $stmt_update = $this->conn_sms->prepare("UPDATE oc_cas_op_transactions SET  exp_date = NOW() where user_id =? AND product_id = ? AND cmd_id=6");
                $stmt_update->bind_param("ii",$target,$product_id);
                $stmt_update->execute();
                $stmt_update->close();

                 $stmt_update = $this->conn_sms->prepare("UPDATE oc_subscriptionDesubscription SET  exp_date = NOW() where user_id =? AND product_id = ? AND cmd_id=6");
                $stmt_update->bind_param("ii",$target,$product_id);
                $stmt_update->execute();
                $stmt_update->close();
                
                $response['error']=false;
                $response['errorCode']=0;
            }else{
                
                $stmt->close();  
                $stmt_update = $this->conn_sms->prepare("UPDATE oc_cas_op_transactions SET  exp_date = NOW() WHERE user_id =? AND product_id = ?  AND cmd_id=6 AND tx_id > ?");
                $stmt_update->bind_param("iii",$target,$product_id,$txid);
                $stmt_update->execute();
                $stmt_update->close();
                
                 $stmt_update = $this->conn_sms->prepare("UPDATE oc_subscriptionDesubscription SET  exp_date = NOW() WHERE user_id =? AND product_id = ? AND cmd_id=6 AND tx_id > ?");
                $stmt_update->bind_param("iii",$target,$product_id,$txid);
                $stmt_update->execute();
                $stmt_update->close();

                $response['error']=false;
                $response['errorCode']=0;
            }
        }
        else
        {
            $response['error']=true;
            $response['errorCode']=2;
        }
    return $response;  
}
/*
FUNCTION NAME       -   getIdsForExpiryUpdate
DESCRIPTION         -   Checking Package Details.
INPUT PARAMETER     -   Integer target,Integer product_id.
OUTPUT PARAMETER    -   Returns all the rows queried
*/
public function getIdsForExpiryUpdateProduct($product_id,$target)
{
        $response = array();
        $stmt = $this->conn_sms->prepare("SELECT MAX(tx_id) as txid FROM oc_cas_op_transactions WHERE user_id= ? AND product_id= ? AND cmd_id=11");
        $stmt->bind_param("ii",$target,$product_id);
        $result = $stmt->execute();
        $stmt->bind_result($txid);
        if($stmt->fetch())
        {
            if($txid==NULL)
            {
                $stmt->close();
                $stmt_update = $this->conn_sms->prepare("UPDATE oc_cas_op_transactions SET  exp_date = NOW() where user_id =? AND product_id = ? AND cmd_id=10");
                $stmt_update->bind_param("ii",$target,$product_id);
                $stmt_update->execute();
                $stmt_update->close();

                 $stmt_update = $this->conn_sms->prepare("UPDATE oc_subscriptionDesubscription SET  exp_date = NOW() where user_id =? AND product_id = ? AND cmd_id=10");
                $stmt_update->bind_param("ii",$target,$product_id);
                $stmt_update->execute();
                $stmt_update->close();
                
                $response['error']=false;
                $response['errorCode']=0;
            }else{
                
                $stmt->close();  
                $stmt_update = $this->conn_sms->prepare("UPDATE oc_cas_op_transactions SET  exp_date = NOW() WHERE user_id =? AND product_id = ?  AND cmd_id=10 AND tx_id > ?");
                $stmt_update->bind_param("iii",$target,$product_id,$txid);
                $stmt_update->execute();
                $stmt_update->close();
                
                 $stmt_update = $this->conn_sms->prepare("UPDATE oc_subscriptionDesubscription SET  exp_date = NOW() WHERE user_id =? AND product_id = ? AND cmd_id=10 AND tx_id > ?");
                $stmt_update->bind_param("iii",$target,$product_id,$txid);
                $stmt_update->execute();
                $stmt_update->close();

                $response['error']=false;
                $response['errorCode']=0;
            }
        }
        else
        {
            $response['error']=true;
            $response['errorCode']=2;
        }
    return $response;  
}

public function getSuspendStatus($stb_no,$operator_id)
{
   
        if($operator_id==1)
        {
            $stmt_stb = $this->conn_sms->prepare("SELECT is_suspend FROM `oc_stb` WHERE stb_no = ? ");
            $stmt_stb->bind_param("s",$stb_no);
            $stmt_stb->execute();
            $stmt_stb->bind_result($is_suspend);
            $stmt_stb->fetch();
            $stmt_stb->close();
        }
        else
        {   
            $stmt_stb = $this->conn_sms->prepare("SELECT is_suspend FROM `oc_stb` WHERE stb_no = ? AND operator_id = ?");
            $stmt_stb->bind_param("si",$stb_no,$operator_id);
            $stmt_stb->execute();
            $stmt_stb->bind_result($is_suspend);
            $stmt_stb->fetch();
            $stmt_stb->close();
        }   
        return $is_suspend;
     
}


/**
* Checking availablity of mass package entitlement id
* @param Integer mass_pkg_entitle_id
* @return boolean
*/
private function isBoxExpired($stb_no,$operator_id) 
{
    $result_cust = $this->custDetails($stb_no,$operator_id);
    $customer_id    = $result_cust['data']['customer_id'];  
    
    $stmt = $this->conn_sms->prepare("SELECT MAX(modify_date) AS modify_date, MAX(exp_date) AS exp_date FROM oc_cas_op_transactions where user_id = ? AND cmd_id = 0");
    $stmt->bind_param("i", $customer_id);
    $stmt->execute();
    $stmt->bind_result($modify_date,$exp_date);
    $stmt->fetch();
    $stmt->close();
    return $exp_date;
    
}
/*
FUNCTION NAME            -   genericLogCommandsFunc
DESCRIPTION              -   genericLogCommandsFunc.
INPUT PARAMETER          -   $id,$status,$log_target_level,$log_target,$command_id,$resend_status,$p_no ='-1'.
OUTPUT PARAMETER         -   Returns all the rows queried.
*/
function genericLogCommandsFunc($id,$status,$log_target_level,$log_target,$command_id,$resend_status,$stbMappedOperatorId,$triggeredBy,$p_no ='-1')
{ 
        $stmt = $this->conn_sms->prepare("INSERT INTO oc_logCasCommands SET tx_id = ?, command_id = ?, target = ?, target_level = ?, `datetime` = NOW() , status = ?, resend = ? , targetNo = ? , operator_id = ?,triggered_by=?");
        $stmt->bind_param("iisisiiii",$id,$command_id,$log_target,$log_target_level,$status,$resend_status,$p_no,$stbMappedOperatorId,$triggeredBy);
        $stmt->execute();
        $stmt->close();            
}
/*
FUNCTION NAME            -   genericLogCommandsFunc
DESCRIPTION              -   genericLogCommandsFunc.
INPUT PARAMETER          -   $id,$status,$log_target_level,$log_target,$command_id,$resend_status,$p_no ='-1'.
OUTPUT PARAMETER         -   Returns all the rows queried.
*/
function genericLogCommandsFunc_suspend($id,$curlresponse,$log_target_level,$log_target,$state,$resend_status,$commandid,$log_target_level_numeric,$stbMappedOperatorId,$triggerredBy){ 
        
       
            $stmt = $this->conn_sms->prepare("INSERT INTO oc_logCasCommands SET tx_id = ?, command_id = ?, target = ?, target_level = ?, `datetime` = NOW() , status = ?, resend = ? , targetNo = ? , operator_id = ?,triggered_by=?");
            $stmt->bind_param("iisisiii",$id,$commandid,$log_target,$log_target_level,$curlresponse,$resend_status,$state,$stbMappedOperatorId,$triggeredBy);
            $stmt->execute();
            $stmt->close();            
      

    } 
function getKMSGroupID($sms_group_id)
{
    $stmt = $this->conn_sms->prepare("SELECT k.kms_group_id FROM  oc_customer_group_description s LEFT JOIN oc_sms_kms_group k ON s.customer_group_id = k.sms_group_id WHERE s.customer_group_id = ? ");
    $stmt->bind_param("i",$sms_group_id);
    $stmt->execute();
    $stmt->bind_result($kms_group_id);
    $stmt->fetch();
    $stmt->close();
    return $kms_group_id;
}
public function generateUniqueCustomerID(){
    $digits=10;
    while(1){
        $unique_rand_num = rand(pow(10, $digits-1), pow(10, $digits)-1);
        $stmt=$this->conn_sms->prepare("SELECT * from oc_customer WHERE customer_unique_id =".$unique_rand_num);
        if($stmt->execute())
        {
            if($query->num_rows==0)break;
        }    
    }
    return $unique_rand_num;
}     
/*
FUNCTION NAME            -   CaptureAndroidLogs
DESCRIPTION              -   CaptureAndroidLogs.
INPUT PARAMETER          -   $command_name,$operator_id.
OUTPUT PARAMETER         -   Returns all the rows queried.
*/
function CaptureAndroidLogs($command_name,$operator_id)
{
        $stmt_andriod_logs = $this->conn_sms->prepare("INSERT INTO oc_android_logs SET command_name = ?, trigger_by = ?");
        $stmt_andriod_logs->bind_param("si",$command_name,$operator_id);
        $stmt_andriod_logs->execute();
        $stmt_andriod_logs->close();  
}

/********************************************************************************************************************/
                                           /*API's For Functionality*/
/*******************************************************************************************************************/
/*
FUNCTION NAME       -   enableUser
DESCRIPTION         -   Creating new customer.
INPUT PARAMETER     -   Integer operator_id,String first_name,String last_name,String stb_no,String sc_no,String email,
                        Integer mobile_no,String address_1,String address_2,Integer country_id,Integer zone_id,String city,Integer region_pin,Integer sms_group_id,Integer customer_no,Integer kms_group_id,Integer user_id,Integer region_id.
OUTPUT PARAMETER    -   Returns all the rows queried
*/
public function enableUser($operator_id,$first_name,$last_name,$stb_no,$sc_no,$email,$mobile_no,$address_1,$address_2,$country_id,$zone_id,$city,$region_pin,$sms_group_id,$customer_no,$kms_group_id,$user_id,$region_id)
{

    $response = array();
    $response['data'] = array();
    $error=array();
        //insert oc_customer model    
        $salt = substr(md5(uniqid(rand(), true)), 0, 9);
        $password = sha1($salt . sha1($salt . sha1("user123")));  

        $stmt_cust = $this->conn_sms->prepare("INSERT INTO oc_customer(customer_unique_id,firstname,lastname,STBNO,SCNO,email, telephone,fax,newsletter,customer_group_id, salt,password,status,approved,date_added,product_subscribed_list, operator_id) values(?,?,?,?,?,?,?,0,1,?,?,?,1,1,now(),'abc',?)");

        $stmt_cust->bind_param("isssississi",$customer_no,$first_name,$last_name,$stb_no,$sc_no,$email,$mobile_no,$sms_group_id,$salt,$password,$operator_id);

        $result = $stmt_cust->execute();
        $stmt_cust->close();
        $customer_id = $this->conn_sms->insert_id;
        $stmt_addrs = $this->conn_sms->prepare("INSERT INTO oc_address (customer_id,firstname,lastname,address_1,address_2,city,postcode,country_id,zone_id,region_id) values(?,?,?,?,?,?,?,?,?,?)");
        $stmt_addrs->bind_param("issssssiii",$customer_id,$first_name,$last_name,$address_1,$address_2,$city,$region_pin,$country_id,$zone_id,$region_id);
        $result = $stmt_addrs->execute();
        $stmt_addrs->close();
        $address_id = $this->conn_sms->insert_id;
        //Inserting
        $stmt_sms_kms = $this->conn_sms->prepare("INSERT INTO oc_sms_kms_map (user_id,api_user_id) values (?,?)");
        $stmt_sms_kms->bind_param("ii",$customer_id,$user_id);
        $result = $stmt_sms_kms->execute();
        $stmt_sms_kms->close();

        //--------------------

        $stmt_cust_stb_cas = $this->conn_sms->prepare("INSERT INTO oc_customer_stb_cas (customer_id,current_stbno,current_casno) values (?,?,-1)");
        $stmt_cust_stb_cas->bind_param("is",$customer_id,$stb_no);
        $result = $stmt_cust_stb_cas->execute();
        $stmt_cust_stb_cas->close();

        $stmt_stb = $this->conn_sms->prepare("UPDATE oc_stb SET customer_id = ?,is_avail='0' WHERE stb_no = ?");
        $stmt_stb->bind_param("is",$customer_id,$stb_no);
        $result = $stmt_stb->execute();
        $stmt_stb->close();

        $stmt_cust_paire_unpaire = $this->conn_sms->prepare("INSERT INTO oc_customer_stb_pair_unpair (customer_unique_id,stb_no,pairing_status,group_id,region_id,operator_id) values (?,?,1,?,?,?)");
        $stmt_cust_paire_unpaire->bind_param("isiii",$customer_no,$stb_no,$sms_group_id,$region_id,$operator_id);
        $result = $stmt_cust_paire_unpaire->execute();
        $stmt_cust_paire_unpaire->close();


        //Getting address_id
        $stmt_cust_up = $this->conn_sms->prepare("UPDATE oc_customer SET address_id = ? WHERE customer_id = ? ");
        $stmt_cust_up->bind_param("ii",$address_id,$customer_id);
        $result = $stmt_cust_up->execute();
        $stmt_cust_up->close();
        $response["error"] = false;
        $response['errorCode']=0;
        $response['data']["message"] = "Success: You have added a new User successfully...!";
    return $response;
}
/**
* Activating Box.
* @param String stb_no,Integer operator_id,String expiry,Integer tx_id,Integer ack,Integer nack.
* @return boolean
*/
public function enableSTBActivation($stb_no,$operator_id,$expiry,$tx_id,$ack,$nack)
{
        $response = array();
        $response['data'] = array();
        $result_cust = $this->custDetails($stb_no,$operator_id);
        $customer_id    = $result_cust['data']['customer_id'];
        $mobile_no      = $result_cust['data']['telephone'];
        $group_id       = $result_cust['data']['group_id'];
        $region_pin     = $result_cust['data']['postcode'];
        $region_id		= $result_cust['data']['region_id'];  
        
        $initiated_by = "iCAS_APP"; 
        $payload=$group_id."~".$region_pin."~".$mobile_no."~".$stb_no."~".$expiry;

        $expiry_time = date('Y-m-d H:i:s', substr($expiry, 0,10));


        $stmt_stb = $this->conn_sms->prepare("UPDATE oc_stb SET is_active = 1, active_date = NOW() WHERE stb_no = ?");
        $stmt_stb->bind_param("s",$stb_no);
        $result = $stmt_stb->execute();
        $stmt_stb->close();

        //Inserting data into sms oc_cas_op_transactions table  
        $stmt_cas = $this->conn_sms->prepare("INSERT INTO oc_cas_op_transactions(`tx_id`,`cmd_id`,`user_id`,`stbno`,`ack_ctr`,`nack_ctr`,`exp_date`,`nack_type`,`initiated_by`,`payload`,`operator_id`) VALUES (?,0,?,?,?,?,?,-1,?,?,?)");
        $stmt_cas->bind_param("iisiisssi",$tx_id,$customer_id,$stb_no,$ack,$nack,$expiry_time,$initiated_by,$payload,$operator_id);
        $result = $stmt_cas->execute();
        $stmt_cas->close();

        //Inserting data into sms oc_activationDeactivation table

        $stmt_actdeact = $this->conn_sms->prepare("INSERT INTO oc_activationDeactivation(`tx_id`,`cmd_id`,`user_id`,`stbno`,`ack_ctr`,`exp_date`,`operator_id`) VALUES (?,0,?,?,?,?,?)");
        $stmt_actdeact->bind_param("iisisi",$tx_id,$customer_id,$stb_no,$ack,$expiry_time,$operator_id);
        $result = $stmt_actdeact->execute();
        $stmt_actdeact->close();   

        $response['error']=false;
        $response['errorCode'] = 0;
        $response['data']['message']="STB is successfully Activated...!"; 
        return $response;
}
/**
* Resend Box Activation.
* @param String stb_no,Integer operator_id,Integer tx_id,Integer target,Integer transaction_id,Integer command_id,Integer end_time,Integer ack,Integer nack.
* @return boolean
*/
function Resend_Box($tx_id,$target_level,$target,$transaction_id,$command_id,$expiry,$operator_id,$stb_no,$ack,$nack)
{
    /*var_dump($tx_id."~".$target_level."~".$target."~".$transaction_id."~".$command_id."~".$expiry."~".$operator_id."~".$stb_no."~".$ack."~".$nack);die;*/
    $initiated_by = "iCAS_APP";
    $payload = $tx_id."#".$command_id."#".$target;
    $response = array();

    $stmt_casop = $this->conn_sms->prepare("INSERT INTO oc_cas_op_transactions(tx_id,cmd_id,target_level,order_id,product_id,user_id,stbno,ack_ctr,nack_ctr,nack_type,exp_date,initiated_by,payload,cmd_type,operator_id) values(?,?,?,0,0,?,?,?,?,-1,?,?,?,-1,?)");
    $stmt_casop->bind_param("iiiisiisssi",$tx_id,$command_id,$target_level,$target,$stb_no,$ack,$nack,$expiry,$initiated_by,$payload,$operator_id);
    if($stmt_casop->execute())
    {
        $response['error']=false;
        $response['errorCode']=0;
        $response['data']['message']="Box Resend is Successfully Done...!";
    }
    else
    {
        $response['error']=true;
        $response['errorCode']=2;
       
    }
    return $response;
}
/**
* Subscribing Package.
* @param String stb_no,Integer user_id,Integer package_id,Integer operator_id,Integer start_time,Integer end_time,String *store_url,Integer option_id_new,Integer ack,Integer nack,Integer initiatedBy.
* @return boolean
*/
public function enablePackageSubscription($stb_no,$user_id,$operator_id,$package_id,$start_time,$end_time,$store_url,$option_id_new,$broadcaster_id,$tx_id,$ack,$nack,$initiatedBy,$tax_class_id)
{
    /*var_dump($stb_no."~".$user_id."~".$operator_id."~".$package_id."~".$start_time."~".$end_time."~".$store_url."~".$option_id_new."~".$tx_id."~".$broadcaster_id."~".$ack."~".$nack."~".$tax_class_id);die; */
    $response = array();
    $error_encountered=0;
    $quantity=1;
    $stmt_price = $this->conn_sms->prepare("SELECT pxd.name ,o.price,p.price,p.model FROM `oc_product_option_value` o 
            INNER JOIN oc_option_value_description pd ON (pd.option_value_id = o.option_value_id) 
            INNER JOIN `oc_product` p ON (o.product_id = p.product_id) 
            INNER JOIN oc_product_description pxd on p.product_id = pxd.product_id
            WHERE pd.name = ? AND o.product_id = ?");
        $stmt_price->bind_param("si",$option_id_new,$package_id);
        $stmt_price->execute();
        $stmt_price->bind_result($package_name,$subsPriceP,$basic_price,$model);
        $stmt_price->fetch();
        $stmt_price->close();
        //var_dump($package_name."~".$subsPricePk."~".$basic_price."~".$model);die;
        //var_dump($stb_no."~".$operator_id."~".$user_id."~".$subsPricePk."~".$tax_class_id);die;
        $subsPricePk = $subsPriceP+$basic_price;
        $getTax = $this->getTaxRate($stb_no,$operator_id,$user_id,$subsPricePk,$tax_class_id);
        $taxDetails = array();
        foreach ($getTax as $key => $value) {
                $taxDetails[$key] = $value['amount'];
        }
        $txamt = array_values($taxDetails); 
        $taxprice = array_sum($txamt);
        $subsPrice = $subsPricePk + $taxprice;    
        $initiated_by= "iCAS_APP";
        $payload=$tx_id."#"."6"."#". $user_id."#".$package_id."#".$start_time."#".$end_time;
        //--------------------oc_setting for getting invoice prefix-----------------------------------------------    

        $stmt = $this->conn_sms->prepare("SELECT `value` FROM `oc_setting` WHERE `key` = 'config_invoice_prefix'");
        $stmt->bind_param("s",$value);
        $stmt->execute();
        $stmt->bind_result($invoice_prefix);
        $stmt->fetch();
        $response['inside'] = $invoice_prefix;
        $stmt->close();


        //-------------------oc_coustomer_description for getting customer group_id--------------------------------------------

        $result_cust = $this->custDetails($stb_no,$operator_id);

        $customer_group_id  =   $result_cust['data']['group_id']; 
        $firstname          =   $result_cust['data']['firstname'];
        $lastname           =   $result_cust['data']['lastname'];
        $email              =   $result_cust['data']['email'];
        $telephone          =   $result_cust['data']['telephone'];
        $address_1          =   $result_cust['data']['address_1'];
        $address_2          =   $result_cust['data']['address_2']; 
        $city               =   $result_cust['data']['city'];
        $postcode           =   $result_cust['data']['postcode'];
        $country_name       =   $result_cust['data']['country_name'];
        $country_id         =   $result_cust['data']['country_id'];
        $zone_name          =   $result_cust['data']['zone_name'];
        $zone_id            =   $result_cust['data']['zone_id'];
        $region_id			=	$result_cust['data']['region_id'];


        $stmt_tax_price = $this->conn_sms->prepare("SELECT value FROM  `oc_setting` WHERE  `key` LIKE 'flat_cost'");
        $result = $stmt_tax_price->execute();
        $stmt_tax_price->bind_result($flatTaxPrice);
        $stmt_tax_price->fetch();
        $stmt_tax_price->close();

        $stmt_order = $this->conn_sms->prepare("INSERT INTO `oc_order`(invoice_prefix,store_id,store_name,store_url,customer_id, customer_group_id,firstname,lastname,email,telephone,fax,payment_firstname,payment_lastname,payment_company,payment_company_id,payment_tax_id,payment_address_1,payment_address_2,payment_city,payment_postcode,payment_country,payment_country_id,payment_zone,payment_zone_id,payment_address_format,payment_method,payment_code,shipping_firstname,shipping_lastname,shipping_company,shipping_address_1,shipping_address_2,shipping_city,shipping_postcode,shipping_country,shipping_country_id,shipping_zone,shipping_zone_id,shipping_address_format,shipping_method,shipping_code,comment,order_status_id,affiliate_id,commission, language_id,currency_id,currency_code,currency_value,ip,forwarded_ip,user_agent,accept_language,date_added,date_modified)values(?,0,'Bydesign India Pvt Ltd',?,?,?,?,?,?,?,0,?,?,0,0,0,?,?,?,?,?,?,?,?,0,'Cash On Delivery','cod',?,?,0,?,?,?,?,?,?,?,?,0,'Flat Shipping Rate','flat.flat',0,5,0,'0.0000',1,4,'INR',1.000000,0,0,0,0,NOW(),NOW())");
        $stmt_order->bind_param("ssiisssssssssssisisssssssssi",$invoice_prefix,$store_url,$user_id,$customer_group_id,$firstname,$lastname,$email,$telephone,$firstname,$lastname,$address_1,$address_2,$city,$postcode,$country_name,$country_id,$zone_name,$zone_id,$firstname,$lastname,$address_1,$address_2,$city,$postcode,$country_name,$country_id,$zone_name,$zone_id);
        $result = $stmt_order->execute();
        $stmt_order->close(); 
        $order_id = $this->conn_sms->insert_id;

        //------------------------------------oc_product--------------------------------------------------- 

       

        //----------------------------------oc_order_product------------------------------ 

        //$total = $subsPrice + $basic_price;
        $stmt_or_prd = $this->conn_sms->prepare("INSERT INTO `oc_order_product` (order_id,product_id,name,model,quantity,price,total,tax,reward)values(?,?,?,?,?,?,?,?,0)");
        $stmt_or_prd->bind_param("iissiiis",$order_id,$package_id,$package_name,$model,$quantity,$subsPricePk,$subsPricePk,$taxprice);
        $result = $stmt_or_prd->execute();
        $stmt_or_prd->close();
        //-------------------------------------------Update oc_product---------------------------------------------


        //---------------------------------oc_order_product----------------------------------
        $stmt_or_prd = $this->conn_sms->prepare("SELECT `order_product_id` FROM `oc_order_product` WHERE `order_id` = ?");
        $stmt_or_prd->bind_param("i",$order_id);
        $stmt_or_prd->execute();
        $stmt_or_prd->bind_result($order_product_id);
        $stmt_or_prd->fetch();
        $stmt_or_prd->close();

        //----------------------------------oc_product_option-------------------------------------
        $stmt_op_prd = $this->conn_sms->prepare("SELECT `product_option_id`,`option_id` FROM `oc_product_option` WHERE `product_id` = ?");
        $stmt_op_prd->bind_param("i",$package_id);
        $stmt_op_prd->execute();
        $stmt_op_prd->bind_result($product_option_id,$option_id);
        $stmt_op_prd->fetch();
        $stmt_op_prd->close();

        //--------------------------------------oc_option_description---------------------------------
        $stmt_op_des = $this->conn_sms->prepare("SELECT `name` FROM `oc_option_description` WHERE `option_id` = ?");
        $stmt_op_des->bind_param("i",$option_id);
        $stmt_op_des->execute();
        $stmt_op_des->bind_result($option_name);
        $stmt_op_des->fetch();
        $stmt_op_des->close();    

        //---------------------------------------oc_product_option_value----------------------------------
        $stmt_op_val = $this->conn_sms->prepare("SELECT `product_option_value_id`,`option_value_id` FROM `oc_product_option_value` WHERE `product_option_id` = ? AND `product_id` = ?");
        $stmt_op_val->bind_param("ii",$product_option_id,$package_id);
        $stmt_op_val->execute();
        $stmt_op_val->bind_result($product_option_value_id,$option_value_id);
        $stmt_op_val->fetch();
        $stmt_op_val->close(); 

        //-----------------------------------oc_order-------------------------------
        $stmt_ord_op = $this->conn_sms->prepare("INSERT INTO oc_order_option (`order_id`,`order_product_id`,`product_option_id`,`product_option_value_id`,`name`,`value`,`type`,`sum`)values(?,?,?,?,?,?,'select',0)");
        $stmt_ord_op->bind_param("iiiiss",$order_id,$order_product_id,$product_option_id,$product_option_value_id,$option_name,$option_id_new);
        $result = $stmt_ord_op->execute();
        $stmt_ord_op->close(); 


        //---------------------------------------------product_option_value-----------------------------------------------
       
        //------------------------------------oc_order_total-------------------------------
        $Rs = "Rs ";
        $total = $subsPricePk + $basic_price;
        //var_dump($subsPricePk);die;
        $basic_prime = $Rs.$subsPricePk.'.00';
        $basic_prime1 = $subsPricePk.'.00';
        $total_price1 = $subsPricePk+$taxprice;
        $total_price = $Rs.$total_price1;
        
        $taxRes = array();
        foreach ($getTax as $key => $res) {
            
            $TextAmount = $Rs.$res['amount']; 
            $valAmount = (String)$res['amount'];
            $stmt_ord_tot = $this->conn_sms->prepare("INSERT INTO oc_order_total (`order_id`,`code`,`title`,`text`,`value`,`sort_order`)values(?,'tax',?,?,?,5)");
            $stmt_ord_tot->bind_param("isss",$order_id,$res['name'],$TextAmount,$valAmount);
            $result = $stmt_ord_tot->execute();
            $stmt_ord_tot->close();
        }
        
        $stmt_ord_tot = $this->conn_sms->prepare("INSERT INTO oc_order_total (`order_id`,`code`,`title`,`text`,`value`,`sort_order`)values(?,'sub_total','Sub-Total',?,?,0)");
        $stmt_ord_tot->bind_param("iss",$order_id,$basic_prime,$basic_prime1);
        $result = $stmt_ord_tot->execute();
        $stmt_ord_tot->close();

        $tax = $Rs.$flatTaxPrice;
                
        $stmt_ord_tot1 = $this->conn_sms->prepare("INSERT INTO oc_order_total (`order_id`,`code`,`title`,`text`,`value`,`sort_order`)values(?,'shipping','Flat Shipping Rate',?,?,3)");
        $stmt_ord_tot1->bind_param("iss",$order_id,$tax,$flatTaxPrice);
        $result = $stmt_ord_tot1->execute();
        $stmt_ord_tot1->close();

        $stmt_ord_tot2 = $this->conn_sms->prepare("INSERT INTO oc_order_total (`order_id`,`code`,`title`,`text`,`value`,`sort_order`)values(?,'total','Total',?,?,9)");
        $stmt_ord_tot2->bind_param("iss",$order_id,$total_price,$total_price1);
        $result = $stmt_ord_tot2->execute();
        $stmt_ord_tot2->close();


        //-------------------------------------oc_order-----------------------------------------
        $stmt_or_up = $this->conn_sms->prepare("UPDATE oc_order SET total = ?, affiliate_id = '0',commission ='0.00' WHERE order_id = ? ");    
        $stmt_or_up->bind_param("si",$total_price1,$order_id);
        $result = $stmt_or_up->execute();
        $stmt_or_up->close();

        //----------------------------------------oc_cas_op_transactions--------------------------------------------------------

        $exp_time = date('Y-m-d H:i:s', substr($end_time, 0,10));

            if(MSO_LCO_PAYMENT==0)
            {
                if($initiatedBy!=1)
                {
                    $stmt = $this->conn_sms->prepare("SELECT credit FROM oc_user WHERE user_id = ?");
                    $stmt->bind_param("i",$operator_id);
                    $result = $stmt->execute();
                    $stmt->bind_result($credit);
                    $stmt->fetch();
                    $stmt->close();
                   
                      
                    $stmt_in_credit = $this->conn_sms->prepare("INSERT INTO oc_lco_transactions(`lco_id`,`customer_id`,`stbno`,`order_id`,`initiated_by`,`amount`) VALUES (?,?,?,?,?,?)");
                    $stmt_in_credit->bind_param("iisiii",$operator_id,$user_id,$stb_no,$order_id,$initiatedBy,$total_price1);
                    $result = $stmt_in_credit->execute();
                    $stmt_in_credit->close();

                    $credit = $credit - $total_price1;

                    $stmt_update = $this->conn_sms->prepare("UPDATE oc_user SET credit = ? WHERE user_id = ?");
                    $stmt_update->bind_param("ii",$credit,$operator_id);
                    $result = $stmt_update->execute();
                    $stmt_update->close();
                }
                else
                {
                    $stmt_in_credit_op = $this->conn_sms->prepare("INSERT INTO oc_lco_transactions(`lco_id`,`customer_id`,`stbno`,`order_id`,`initiated_by`,`amount`) VALUES (?,?,?,?,?,?)");
                    $stmt_in_credit_op->bind_param("iisiis",$operator_id,$user_id,$stb_no,$order_id,$initiatedBy,$total_price1);
                    $result = $stmt_in_credit_op->execute();
                    $stmt_in_credit_op->close();
                }    
            }
      
        if($tx_id!=-1)
        {

                $DB_subscriptionData = array();
                $DB_subscriptionData = $this->checkPackageSubscriptionAvailable($package_id,$user_id);
                
                if($DB_subscriptionData[0]==2||$DB_subscriptionData[0]==3 )
                {
                    $stmt_subdes_in = $this->conn_sms->prepare("INSERT INTO oc_subscriptionDesubscription SET tx_id = ?,cmd_id = 6,product_id = ?,user_id = ?, stbno = ?, ack_ctr = ?,modify_date = NOW(),exp_date = ?,operator_id = ?");
                    $stmt_subdes_in->bind_param("iiisisi",$tx_id,$package_id,$user_id,$stb_no,$ack,$exp_time,$operator_id);
                    $result = $stmt_subdes_in->execute();
                    $stmt_subdes_in->close();
                    $finalExp = $exp_time;
          
                }
                else if($DB_subscriptionData[0]==1)
                { 
                    $timestamp = strtotime($DB_subscriptionData['expiry']);
                    $expi_date = strtotime("+".$option_id_new, $timestamp);
                    $finalExp = date('Y-m-d H:i:s',$expi_date);
                    $stmt_subdes_up = $this->conn_sms->prepare("UPDATE oc_subscriptionDesubscription SET  exp_date = ? WHERE id= ?"); 
                    $stmt_subdes_up->bind_param("si",$finalExp,$DB_subscriptionData['updateId']);
                    $result = $stmt_subdes_up->execute();
                    $stmt_subdes_up->close();
                }

                $stmt_cas = $this->conn_sms->prepare("INSERT INTO oc_cas_op_transactions(`tx_id`,`cmd_id`,`user_id`,`stbno`,`ack_ctr`,`nack_ctr`,`nack_type`,`initiated_by`,`payload`,`product_id`,`exp_date`,`target_level`,`order_id`,`operator_id`) VALUES (?,6,?,?,?,?,-1,?,?,?,?,1,?,?)");
                $stmt_cas->bind_param("iisiissisii",$tx_id,$user_id,$stb_no,$ack,$nack,$initiated_by,$payload,$package_id,$finalExp,$order_id,$operator_id);
                $result = $stmt_cas->execute();
                $stmt_cas->close(); 
                
                $response['error']=false;
                $response['errorCode'] = 0;
                $response['invoice_prefix'] = $invoice_prefix;
                $response['package_name'] = $package_name;
                $response['subscription'] = $option_id_new;
                $response['total_price'] = $total_price;
                $response['package_expiry'] = $finalExp;
                $response['data']['message']="Package Subscription is Successfully Done...!"; 
        }
        else
        {
            $response["error"] = true;
            $response['errorCode'] = 2;
        }
    return $response; 
}
/**
* Disable Package Activation.
* @param String stb_no,Integer operator_id,Integer tx_id,Integer target,Integer transaction_id,Integer command_id,Integer end_time,Integer ack,Integer nack.
* @return boolean
*/
function Disable_Package($stb_no,$tx_id,$target_level,$target,$transaction_id,$command_id,$product_no,$product_id,$operator_id,$broadcaster_id,$ack,$nack)
{
    
    $initiated_by = "iCAS_APP";
    $payload = $stb_no."#".$command_id."#".$target;
    $response = array();
 	$result_cust = $this->custDetails($stb_no,$operator_id);
    $region_id    = $result_cust['data']['region_id'];
    $stmt = $this->conn_sms->prepare("INSERT INTO oc_cas_op_transactions(tx_id,cmd_id,target_level,order_id,product_id,user_id,stbno,ack_ctr,nack_ctr,nack_type,initiated_by,payload,cmd_type,operator_id) values(?,?,?,0,?,?,?,?,?,-1,?,?,-1,?)");
    $stmt->bind_param("iiiiisiissi",$tx_id,$command_id,$target_level,$product_id,$target,$stb_no,$ack,$nack,$initiated_by,$payload,$operator_id);
    if($stmt->execute())
    {
        $response['error']=false;
        $response['errorCode']=0;

        //-----------------oc_subscription/desubscription---3.10P2--------//
        $currDate = new DateTime("now",new DateTimeZone('Asia/Calcutta'));  
        $current_date = $currDate->format('Y-m-d H:i:s');

        $stmt = $this->conn_sms->prepare("SELECT id,cmd_id FROM oc_subscriptionDesubscription WHERE cmd_id IN (6,7) AND user_id =? AND stbno = ? AND product_id =? ORDER BY id DESC LIMIT 1");
        $stmt->bind_param("isi",$target,$stb_no,$product_id);
        $result = $stmt->execute();
        $stmt->bind_result($id,$cmd_id);
        $stmt->fetch();
        $stmt->close();
        
        if($id!=null && $cmd_id==7){
            
            return;
        }
        else
        {    
            $stmt = $this->conn_sms->prepare("INSERT INTO oc_subscriptionDesubscription SET tx_id = ?,cmd_id = 7,product_id = ?,user_id = ?, stbno = ?, ack_ctr = ?,operator_id = ?");
            $stmt->bind_param("iiisii",$tx_id,$product_id,$target,$stb_no,$ack,$operator_id);
            $result = $stmt->execute();
            $stmt->close();
        }

    }
    else
    {
        $response['error']=true;
        $response['errorCode']=2;
       
    }
    return $response;
}
/**
* Disable Package Activation.
* @param String stb_no,Integer operator_id,Integer tx_id,Integer target,Integer transaction_id,Integer command_id,Integer end_time,Integer ack,Integer nack.
* @return boolean
*/
function Disable_Product($stb_no,$tx_id,$target_level,$target,$transaction_id,$command_id,$product_no,$product_id,$operator_id,$broadcaster_id,$ack,$nack)
{
    
    $initiated_by = "iCAS_APP";
    $payload = $stb_no."#".$command_id."#".$target;
    $response = array();
    $result_cust = $this->custDetails($stb_no,$operator_id);
    $region_id    = $result_cust['data']['region_id'];
    $stmt = $this->conn_sms->prepare("INSERT INTO oc_cas_op_transactions(tx_id,cmd_id,target_level,order_id,product_id,user_id,stbno,ack_ctr,nack_ctr,nack_type,initiated_by,payload,cmd_type,operator_id) values(?,?,?,0,?,?,?,?,?,-1,?,?,-1,?)");
    $stmt->bind_param("iiiiisiissi",$tx_id,$command_id,$target_level,$product_id,$target,$stb_no,$ack,$nack,$initiated_by,$payload,$operator_id);
    if($stmt->execute())
    {
        $response['error']=false;
        $response['errorCode']=0;

        //-----------------oc_subscription/desubscription---3.10P2--------//
        $currDate = new DateTime("now",new DateTimeZone('Asia/Calcutta'));  
        $current_date = $currDate->format('Y-m-d H:i:s');

        $stmt = $this->conn_sms->prepare("SELECT id,cmd_id FROM oc_subscriptionDesubscription WHERE cmd_id IN (10,11) AND user_id =? AND stbno = ? AND product_id =? ORDER BY id DESC LIMIT 1");
        $stmt->bind_param("isi",$target,$stb_no,$product_id);
        $result = $stmt->execute();
        $stmt->bind_result($id,$cmd_id);
        $stmt->fetch();
        $stmt->close();
        
        if($id!=null && $cmd_id==11){
            
            return;
        }
        else
        {    
            $stmt = $this->conn_sms->prepare("INSERT INTO oc_subscriptionDesubscription SET tx_id = ?,cmd_id = 11,product_id = ?,user_id = ?, stbno = ?, ack_ctr = ?,operator_id = ?");
            $stmt->bind_param("iiisii",$tx_id,$product_id,$target,$stb_no,$ack,$operator_id);
            $result = $stmt->execute();
            $stmt->close();
        }

    }
    else
    {
        $response['error']=true;
        $response['errorCode']=2;
       
    }
    return $response;
}
/**
* Disable Box Activation.
* @param String stb_no,Integer operator_id,Integer tx_id,Integer target,Integer transaction_id,Integer command_id,Integer end_time,Integer ack,Integer nack.
* @return boolean
*/
function Disable_Box($stb_no,$tx_id,$target_level,$target,$transaction_id,$command_id,$operator_id,$ack,$nack)
{
    $initiated_by = "iCAS_APP";
    $payload = $stb_no."#".$command_id."#".$target;
    $response = array();
   	$result_cust = $this->custDetails($stb_no,$operator_id);
    $region_id    = $result_cust['data']['region_id'];
    $stmt = $this->conn_sms->prepare("INSERT INTO oc_cas_op_transactions(tx_id,cmd_id,target_level,order_id,product_id,user_id,stbno,ack_ctr,nack_ctr,nack_type,initiated_by,payload,cmd_type,operator_id) values(?,?,?,0,0,?,?,?,?,-1,?,?,-1,?)");
    $stmt->bind_param("iiiisiissi",$tx_id,$command_id,$target_level,$target,$stb_no,$ack,$nack,$initiated_by,$payload,$operator_id);
    if($stmt->execute())
    {
        
        $response['error']=false;
        $response['errorCode']=0;
        $stmt = $this->conn_sms->prepare("UPDATE oc_stb SET is_active = 0 WHERE stb_no = ?");
        $stmt->bind_param("s", $stb_no);
        $result = $stmt->execute();
        $stmt->close();

        $currDate = new DateTime("now",new DateTimeZone('Asia/Calcutta'));  
        $current_date = $currDate->format('Y-m-d H:i:s');

        $stmt = $this->conn_sms->prepare("SELECT id,cmd_id FROM oc_activationDeactivation WHERE cmd_id IN (0,1) AND user_id =? AND stbno = ? ORDER BY id DESC LIMIT 1");
        $stmt->bind_param("is",$target,$stb_no);
        $result = $stmt->execute();
        $stmt->bind_result($id,$cmd_id);
        $stmt->fetch();
        $stmt->close();
 
        if($id!=null && $cmd_id==1){
            return;
        }
        else
        {    
            $stmt = $this->conn_sms->prepare("INSERT INTO oc_activationDeactivation SET tx_id = ?,cmd_id = 1,user_id = ?, stbno = ?, ack_ctr = ?,modify_date = ?,operator_id = ?");
            $stmt->bind_param("iisisi",$tx_id,$target,$stb_no,$ack,$current_date,$operator_id);
            $result = $stmt->execute();
            $stmt->close();
        } 
      
    }
    else
    {
        $response['error']=true;
        $response['errorCode']=2;
       
    }
    return $response;
}
function Suspend_Resume_STB($stb_no,$user_id,$target_level,$tx_id,$type,$cmd_type,$state,$operator_id,$ack,$nack)
{
    if($state==1){
        $payload = "suspend#".$target_level."#".$stb_no."#".$type."#".$state;
        $is_suspend = 1;
    }else{
        $payload = "resume#".$target_level."#".$user_id."#".$type."#".$state;
        $is_suspend = 0;
    }
    $initiated_by = "iCAS_APP";
    $response = array();
    $command_id = 23;
    $order_id = 0;
    $product_id = 0;
    
    $stmt = $this->conn_sms->prepare("INSERT INTO oc_cas_op_transactions(tx_id,cmd_id,target_level,order_id,product_id,user_id,stbno,ack_ctr,nack_ctr,nack_type,modify_date,exp_date,initiated_by,payload,cmd_type,operator_id) values(?,?,?,0,0,?,?,?,?,-1,NOW(),NOW(),?,?,?,?)");
    $stmt->bind_param("iiiisiissii",$tx_id,$command_id,$target_level,$user_id,$stb_no,$ack,$nack,$initiated_by,$payload,$cmd_type,$operator_id);
    if($stmt->execute())
    {
       
            $stmt = $this->conn_sms->prepare("UPDATE oc_stb SET is_suspend = ? WHERE stb_no = ?");
            $stmt->bind_param("is", $is_suspend,$stb_no);
            $result = $stmt->execute();
            $stmt->close();
            $response['error']=false;
            $response['errorCode']=0;
    }
    else
    {
        $response['error']=true;
        $response['errorCode']=2;
       
    }
    return $response;
}

/**
* Subscribing Product.
* @param String stb_no,Integer user_id,Integer package_id,Integer operator_id,Integer start_time,Integer end_time,String *store_url,Integer option_id_new,Integer ack,Integer nack,Integer initiatedBy.
* @return boolean
*/
public function enableProductSubscription($stb_no,$user_id,$operator_id,$product_id,$start_time,$end_time,$store_url,$option_id_new,$broadcaster_id,$tx_id,$ack,$nack,$initiatedBy,$tax_class_id)
{
    /*var_dump($stb_no."~".$user_id."~".$operator_id."~".$product_id."~".$start_time."~".$end_time."~".$store_url."~".$option_id_new."~".$tx_id."~".$broadcaster_id."~".$ack."~".$nack."~".$initiatedBy."~".$tax_class_id);die;  */  
    $response = array();
    $error_encountered=0;
    $quantity=1;
    $stmt_price = $this->conn_sms->prepare("SELECT pxd.name ,o.price,p.price,p.model FROM `oc_product_option_value` o 
            INNER JOIN oc_option_value_description pd ON (pd.option_value_id = o.option_value_id) 
            INNER JOIN `oc_product` p ON (o.product_id = p.product_id) 
            INNER JOIN oc_product_description pxd on p.product_id = pxd.product_id
            WHERE pd.name = ? AND o.product_id = ?");
        $stmt_price->bind_param("si",$option_id_new,$product_id);
        $stmt_price->execute();
        $stmt_price->bind_result($product_name,$subsPriceP,$basic_price,$model);
        $stmt_price->fetch();
        $stmt_price->close();
        
        //var_dump($product_name."~".$basic_price."~".$model);die;
        $subsPricePk = $subsPriceP+$basic_price;
        //var_dump($stb_no."~".$operator_id."~".$user_id."~".$subsPricePk."~".$tax_class_id);die;
        $getTax = $this->getTaxRate($stb_no,$operator_id,$user_id,$subsPricePk,$tax_class_id);
        $taxDetails = array();
        foreach ($getTax as $key => $value) {
                $taxDetails[$key] = $value['amount'];
        }
        $txamt = array_values($taxDetails); 
        $taxprice = array_sum($txamt);
        $subsPrice = $subsPricePk + $taxprice; 

        //var_dump($taxprice."~".$subsPrice);die;

        $initiated_by= "iCAS_APP";
        $payload=$tx_id."#"."10"."#". $user_id."#".$product_id."#".$start_time."#".$end_time;

        //--------------------oc_setting for getting invoice prefix-----------------------------------------------    

        $stmt = $this->conn_sms->prepare("SELECT `value` FROM `oc_setting` WHERE `key` = 'config_invoice_prefix'");
        $stmt->bind_param("s",$value);
        $stmt->execute();
        $stmt->bind_result($invoice_prefix);
        $stmt->fetch();
        $response['inside'] = $invoice_prefix;
        $stmt->close();


        //-------------------oc_coustomer_description for getting customer group_id--------------------------------------------

        $result_cust = $this->custDetails($stb_no,$operator_id);

        $customer_group_id  =   $result_cust['data']['group_id']; 
        $firstname          =   $result_cust['data']['firstname'];
        $lastname           =   $result_cust['data']['lastname'];
        $email              =   $result_cust['data']['email'];
        $telephone          =   $result_cust['data']['telephone'];
        $address_1          =   $result_cust['data']['address_1'];
        $address_2          =   $result_cust['data']['address_2']; 
        $city               =   $result_cust['data']['city'];
        $postcode           =   $result_cust['data']['postcode'];
        $country_name       =   $result_cust['data']['country_name'];
        $country_id         =   $result_cust['data']['country_id'];
        $zone_name          =   $result_cust['data']['zone_name'];
        $zone_id            =   $result_cust['data']['zone_id'];
        $region_id          =   $result_cust['data']['region_id'];


        $stmt_tax_price = $this->conn_sms->prepare("SELECT value FROM  `oc_setting` WHERE  `key` LIKE 'flat_cost'");
        $result = $stmt_tax_price->execute();
        $stmt_tax_price->bind_result($flatTaxPrice);
        $stmt_tax_price->fetch();
        $stmt_tax_price->close();

        $stmt_order = $this->conn_sms->prepare("INSERT INTO `oc_order`(invoice_prefix,store_id,store_name,store_url,customer_id, customer_group_id,firstname,lastname,email,telephone,fax,payment_firstname,payment_lastname,payment_company,payment_company_id,payment_tax_id,payment_address_1,payment_address_2,payment_city,payment_postcode,payment_country,payment_country_id,payment_zone,payment_zone_id,payment_address_format,payment_method,payment_code,shipping_firstname,shipping_lastname,shipping_company,shipping_address_1,shipping_address_2,shipping_city,shipping_postcode,shipping_country,shipping_country_id,shipping_zone,shipping_zone_id,shipping_address_format,shipping_method,shipping_code,comment,order_status_id,affiliate_id,commission, language_id,currency_id,currency_code,currency_value,ip,forwarded_ip,user_agent,accept_language,date_added,date_modified)values(?,0,'Bydesign India Pvt Ltd',?,?,?,?,?,?,?,0,?,?,0,0,0,?,?,?,?,?,?,?,?,0,'Cash On Delivery','cod',?,?,0,?,?,?,?,?,?,?,?,0,'Flat Shipping Rate','flat.flat',0,5,0,'0.0000',1,4,'INR',1.000000,0,0,0,0,NOW(),NOW())");
        $stmt_order->bind_param("ssiisssssssssssisisssssssssi",$invoice_prefix,$store_url,$user_id,$customer_group_id,$firstname,$lastname,$email,$telephone,$firstname,$lastname,$address_1,$address_2,$city,$postcode,$country_name,$country_id,$zone_name,$zone_id,$firstname,$lastname,$address_1,$address_2,$city,$postcode,$country_name,$country_id,$zone_name,$zone_id);
        $result = $stmt_order->execute();
        $stmt_order->close(); 
        $order_id = $this->conn_sms->insert_id;
        //----------------------------------oc_order_product------------------------------ 

        //$total = $subsPrice + $basic_price;

        $stmt_or_prd = $this->conn_sms->prepare("INSERT INTO `oc_order_product` (order_id,product_id,name,model,quantity,price,total,tax,reward)values(?,?,?,?,?,?,?,?,0)");
        $stmt_or_prd->bind_param("iissiiis",$order_id,$product_id,$product_name,$model,$quantity,$subsPricePk,$subsPricePk,$taxprice);
        $result = $stmt_or_prd->execute();
        $stmt_or_prd->close();
      
        //---------------------------------oc_order_product----------------------------------
        $stmt_or_prd = $this->conn_sms->prepare("SELECT `order_product_id` FROM `oc_order_product` WHERE `order_id` = ?");
        $stmt_or_prd->bind_param("i",$order_id);
        $stmt_or_prd->execute();
        $stmt_or_prd->bind_result($order_product_id);
        $stmt_or_prd->fetch();
        $stmt_or_prd->close();

        //----------------------------------oc_product_option-------------------------------------
        $stmt_op_prd = $this->conn_sms->prepare("SELECT `product_option_id`,`option_id` FROM `oc_product_option` WHERE `product_id` = ?");
        $stmt_op_prd->bind_param("i",$product_id);
        $stmt_op_prd->execute();
        $stmt_op_prd->bind_result($product_option_id,$option_id);
        $stmt_op_prd->fetch();
        $stmt_op_prd->close();

        //--------------------------------------oc_option_description---------------------------------
        $stmt_op_des = $this->conn_sms->prepare("SELECT `name` FROM `oc_option_description` WHERE `option_id` = ?");
        $stmt_op_des->bind_param("i",$option_id);
        $stmt_op_des->execute();
        $stmt_op_des->bind_result($option_name);
        $stmt_op_des->fetch();
        $stmt_op_des->close();    

        //---------------------------------------oc_product_option_value----------------------------------
        $stmt_op_val = $this->conn_sms->prepare("SELECT `product_option_value_id`,`option_value_id` FROM `oc_product_option_value` WHERE `product_option_id` = ? AND `product_id` = ?");
        $stmt_op_val->bind_param("ii",$product_option_id,$product_id);
        $stmt_op_val->execute();
        $stmt_op_val->bind_result($product_option_value_id,$option_value_id);
        $stmt_op_val->fetch();
        $stmt_op_val->close(); 

        //-----------------------------------oc_order-------------------------------
        $stmt_ord_op = $this->conn_sms->prepare("INSERT INTO oc_order_option (`order_id`,`order_product_id`,`product_option_id`,`product_option_value_id`,`name`,`value`,`type`,`sum`)values(?,?,?,?,?,?,'select',0)");
        $stmt_ord_op->bind_param("iiiiss",$order_id,$order_product_id,$product_option_id,$product_option_value_id,$option_name,$option_id_new);
        $result = $stmt_ord_op->execute();
        $stmt_ord_op->close(); 

        //------------------------------------oc_order_total-------------------------------
        $Rs = "Rs ";
        $total = $subsPricePk + $basic_price;
        //var_dump($subsPricePk);die;
        $basic_prime = $Rs.$subsPricePk.'.00';
        $basic_prime1 = $subsPricePk.'.00';
        $total_price1 = $subsPricePk+$taxprice;
        $total_price = $Rs.$total_price1;
        
        $taxRes = array();
        foreach ($getTax as $key => $res) {
            
            $TextAmount = $Rs.$res['amount']; 
            $valAmount = (String)$res['amount'];
            $stmt_ord_tot = $this->conn_sms->prepare("INSERT INTO oc_order_total (`order_id`,`code`,`title`,`text`,`value`,`sort_order`)values(?,'tax',?,?,?,5)");
            $stmt_ord_tot->bind_param("isss",$order_id,$res['name'],$TextAmount,$valAmount);
            $result = $stmt_ord_tot->execute();
            $stmt_ord_tot->close();
        }

        $stmt_ord_tot = $this->conn_sms->prepare("INSERT INTO oc_order_total (`order_id`,`code`,`title`,`text`,`value`,`sort_order`)values(?,'sub_total','Sub-Total',?,?,0)");
        $stmt_ord_tot->bind_param("iss",$order_id,$basic_prime,$basic_prime1);
        $result = $stmt_ord_tot->execute();
        $stmt_ord_tot->close();
 
        $tax = $Rs.$flatTaxPrice;
                
        $stmt_ord_tot1 = $this->conn_sms->prepare("INSERT INTO oc_order_total (`order_id`,`code`,`title`,`text`,`value`,`sort_order`)values(?,'shipping','Flat Shipping Rate',?,?,3)");
        $stmt_ord_tot1->bind_param("iss",$order_id,$tax,$flatTaxPrice);
        $result = $stmt_ord_tot1->execute();
        $stmt_ord_tot1->close();

        $stmt_ord_tot2 = $this->conn_sms->prepare("INSERT INTO oc_order_total (`order_id`,`code`,`title`,`text`,`value`,`sort_order`)values(?,'total','Total',?,?,9)");
        $stmt_ord_tot2->bind_param("iss",$order_id,$total_price,$total_price1);
        $result = $stmt_ord_tot2->execute();
        $stmt_ord_tot2->close();

        //-------------------------------------oc_order-----------------------------------------
        
        $stmt_or_up = $this->conn_sms->prepare("UPDATE oc_order SET total = ?, affiliate_id = '0',commission ='0.00' WHERE order_id = ? ");    
        $stmt_or_up->bind_param("si",$total_price1,$order_id);
        $result = $stmt_or_up->execute();
        $stmt_or_up->close();
        //----------------------------------------oc_cas_op_transactions--------------------------------------------------------
        $exp_time = date('Y-m-d H:i:s', substr($end_time, 0,10));
            if(MSO_LCO_PAYMENT==0)
            {
                if($initiatedBy!=1)
                {
                    $stmt = $this->conn_sms->prepare("SELECT credit FROM oc_user WHERE user_id = ?");
                    $stmt->bind_param("i",$operator_id);
                    $result = $stmt->execute();
                    $stmt->bind_result($credit);
                    $stmt->fetch();
                    $stmt->close();
                                     
                    $stmt_in_credit = $this->conn_sms->prepare("INSERT INTO oc_lco_transactions(`lco_id`,`customer_id`,`stbno`,`order_id`,`initiated_by`,`amount`) VALUES (?,?,?,?,?,?)");
                    $stmt_in_credit->bind_param("iisiii",$operator_id,$user_id,$stb_no,$order_id,$initiatedBy,$total_price1);
                    $result = $stmt_in_credit->execute();
                    $stmt_in_credit->close();

                    $credit = $credit - $total_price1;

                    $stmt_update = $this->conn_sms->prepare("UPDATE oc_user SET credit = ? WHERE user_id = ?");
                    $stmt_update->bind_param("ii",$credit,$operator_id);
                    $result = $stmt_update->execute();
                    $stmt_update->close();
                }
                else
                {
                    $stmt_in_credit_op = $this->conn_sms->prepare("INSERT INTO oc_lco_transactions(`lco_id`,`customer_id`,`stbno`,`order_id`,`initiated_by`,`amount`) VALUES (?,?,?,?,?,?)");
                    $stmt_in_credit_op->bind_param("iisiii",$operator_id,$user_id,$stb_no,$order_id,$initiatedBy,$total_price1);
                    $result = $stmt_in_credit_op->execute();
                    $stmt_in_credit_op->close();
                }    
            }
      
        if($tx_id!=-1)
        {

                $DB_subscriptionData = array();
                $DB_subscriptionData = $this->checkProductSubscriptionAvailable($product_id,$user_id);
                
                if($DB_subscriptionData[0]==2||$DB_subscriptionData[0]==3 )
                {
                    $stmt_subdes_in = $this->conn_sms->prepare("INSERT INTO oc_subscriptionDesubscription SET tx_id = ?,cmd_id = 10,product_id = ?,user_id = ?, stbno = ?, ack_ctr = ?,modify_date = NOW(),exp_date = ?,operator_id = ?");
                    $stmt_subdes_in->bind_param("iiisisi",$tx_id,$product_id,$user_id,$stb_no,$ack,$exp_time,$operator_id);
                    $result = $stmt_subdes_in->execute();
                    $stmt_subdes_in->close();
                    $finalExp = $exp_time;
          
                }
                else if($DB_subscriptionData[0]==1)
                { 
                    $timestamp = strtotime($DB_subscriptionData['expiry']);
                    $expi_date = strtotime("+".$option_id_new, $timestamp);
                    $finalExp = date('Y-m-d H:i:s',$expi_date);
                    $stmt_subdes_up = $this->conn_sms->prepare("UPDATE oc_subscriptionDesubscription SET  exp_date = ? WHERE id= ?"); 
                    $stmt_subdes_up->bind_param("si",$finalExp,$DB_subscriptionData['updateId']);
                    $result = $stmt_subdes_up->execute();
                    $stmt_subdes_up->close();
                }

                $stmt_cas = $this->conn_sms->prepare("INSERT INTO oc_cas_op_transactions(`tx_id`,`cmd_id`,`user_id`,`stbno`,`ack_ctr`,`nack_ctr`,`nack_type`,`initiated_by`,`payload`,`product_id`,`exp_date`,`target_level`,`order_id`,`operator_id`) VALUES (?,10,?,?,?,?,-1,?,?,?,?,1,?,?)");
                $stmt_cas->bind_param("iisiissisii",$tx_id,$user_id,$stb_no,$ack,$nack,$initiated_by,$payload,$product_id,$finalExp,$order_id,$operator_id);
                $result = $stmt_cas->execute();
                $stmt_cas->close(); 
                
                $response['error']=false;
                $response['errorCode'] = 0;
                $response['invoice_prefix'] = $invoice_prefix;
                $response['package_name'] = $product_name;
                $response['subscription'] = $option_id_new;
                $response['total_price'] = $total_price;
                $response['package_expiry'] = $finalExp;
                $response['data']['message']="Product Subscription is Successfully Done...!"; 
        }
        else
        {
            $response["error"] = true;
            $response['errorCode'] = 2;
        }
    return $response; 
}


}
?>