<?php 
/**
 * Class to handle all API operations
 * 
 * @author Patil Prashant
 * Date: 26th July 2018
 */

require_once '../include/DbHandler.php';
require_once '../include/PassHash.php';
require_once '.././libs/Slim/Slim.php';
require_once '../include/Restapi.php';
require_once '../include/helper.php';
require_once '../include/enum.php';
require_once '../../config.php';
require_once '../include/Config.php';

declare(ticks=1);
$lock = '/tmp/myscript.lock';
error_reporting(~E_ALL);
\Slim\Slim::registerAutoloader();
$app = new \Slim\Slim();


function authenticate(\Slim\Route $route)
{
    // Getting request headers
    $headers = apache_request_headers();
    $response = array();
    $app = \Slim\Slim::getInstance();
   
    $db = new DbHandler();
    $res = $db->getSuperPermission();
    if($res['error']==true)
    {
        $response["error"] = true;
        $response["errorCode"] = 24;
        echoResponse(201, $response);
        $app->stop();

    }
     
}
/**
* Verifying required params posted or not
*/
function verifyRequiredParams($required_fields)
{
    $error = false;
    $error_fields = "";
    $request_params = array();
    $request_params = $_REQUEST;
    // Handling PUT request params
    if ($_SERVER['REQUEST_METHOD'] == 'POST')
    {
        $app = \Slim\Slim::getInstance();
        parse_str($app->request()->getBody(), $request_params);
    }
    foreach ($required_fields as $field)
    {
        if (!isset($request_params[$field]) || strlen(trim($request_params[$field])) <= 0)
        {
            $error = true;
            $error_fields .= $field . ', ';
        }
    }
    if($error)
    {
        // Required field(s) are missing or empty
        $response = array();
        $app = \Slim\Slim::getInstance();
        $response["error"] = true;
        $response["message"] = 'Required field(s) ' . substr($error_fields, 0, -2) . ' is missing or empty';
        echoResponse(400, $response);
        $app->stop();
    }
}

/**
* Echoing json response to client
* @param String $status_code Http response code
* @param Int $response Json response
*/
function echoResponse($status_code, $response)
{

    $app = \Slim\Slim::getInstance();
    // Http response code
    $app->status($status_code);
    // setting response content type to json
    $app->contentType('application/json');
    echo json_encode($response);//die;
}

$app->post('/status' , function()
{
    $response = array();
    echoResponse(200, $response);
});

/**
 *     Android API's  
 *
 */
/**
 * To Track Mobile and Operator location
 * url - /restrictAccess
 * method - POST
 * @param - String none 
 */

$app->post('/restrictAccess' , function() use ($app)
{
    $response = array();
    $error=array();
    $db = new DbHandler();
    $helper = new Helper();
    // check for required params
    $status = 0;
    $res = $db->restrictAccess($status);
    foreach($res as $key => $value){
            $response[$key]    = $value;
    	}
    echoResponse(201, $response);
    
});
/**
 * To Track Mobile and Operator location
 * url - /allowAccess
 * method - POST
 * @param - String none 
 */

$app->post('/allowAccess' , function() use ($app)
{
     
    $response = array();
    $error=array();
    $db = new DbHandler();
    $helper = new Helper();
    // check for required params
    $status = 1;
    $res = $db->restrictAccess($status);
    foreach($res as $key => $value){
            $response[$key] = $value;
    	}
    echoResponse(201, $response);
    
});
/**
 * To Track Mobile and Operator location
 * url - /trackPublicIP
 * method - POST
 * @param - String none 
 */

$app->post('/trackPublicIP' , function() use ($app)
{
     
    $response = array();
    $error=array();
    $db = new DbHandler();
    $helper = new Helper();
    $obj = new restapi(); 
    // check for required params
    $public_ip = $app->request->post('public_ip');
    $data="public_ip=".$public_ip;
    // Method is POST
    $method ="POST";
    $url = DASH_BOARD_API."/trackPublicIP";
    $hdr = array('Content-Type: application/x-www-form-urlencoded',API_AUTH_NAME .':'.API_AUTH);
    $apiresult = $obj->callAPI($method,$hdr,$url,$data);

});
/**
 * To Track Mobile and Operator location
 * url - /sendLocation
 * method - POST
 * @param - String none 
 */

$app->post('/sendLocation' , 'authenticate', function() use ($app)
{
    $response = array();
    $error=array();
    $db = new DbHandler();
    $helper = new Helper();
    $obj = new restapi();
    // check for required params
    if(DASH_BOARD_ENTRY==1)
    {    
        
        $lattitude = $app->request->post('lattitude');
        $longitude = $app->request->post('longitude');
        $mac_address = $app->request->post('mac_address');
        $operator_id = $app->request->post('operator_id');
        $operator_name   = $app->request->post('operator');
        $operator = $operator_name."".NETWORK_NAME;

        $data="lattitude=".$lattitude."&longitude=".$longitude."&mac_address=".$mac_address."&operator_id=".$operator_id."&operator_name=".$operator_name."&operator=".$operator;
            // Method is POST
        $method ="POST";
        $url = DASH_BOARD_API."/sendLocation";
        $hdr = array('Content-Type: application/x-www-form-urlencoded',API_AUTH_NAME .':'.API_AUTH);
        $apiresult = $obj->callAPI($method,$hdr,$url,$data);

    }    
});
/**
 * To get device's mac_address.
 * url - /getMacAddress
 * method - POST
 * @param - String operator 
 */

$app->post('/getMacAddress' , 'authenticate', function() use ($app)
{
    $response = array();
    $error=array();
    $db = new DbHandler();
    $helper = new Helper();
    $obj = new restapi();

    if(DASH_BOARD_ENTRY==1)
    {
        $operator_name = $app->request->post('operator');
        $operator = $operator_name."".NETWORK_NAME;
        $data="operator_name=".$operator_name."&operator=".$operator;
            // Method is POST
        $method ="POST";
        $url = DASH_BOARD_API."/getMacAddress";
        $hdr = array('Content-Type: application/x-www-form-urlencoded',API_AUTH_NAME .':'.API_AUTH);
        $apiresult = $obj->callAPI($method,$hdr,$url,$data);
    }
});
/**
 * To set MSO Status.
 * url - /setMSOStatus
 * method - POST
 * @param - String operator 
 */

$app->post('/setMSOStatus' , 'authenticate', function() use ($app)
{
    $response = array();
    $error=array();
    $db = new DbHandler();
    $helper = new Helper();
    $obj = new restapi();
   // check for required params
    if(DASH_BOARD_ENTRY==1)
    {
        $operator_id = $app->request->post('operator_id');
        $operator_name = $app->request->post('operator');
        $online = $app->request->post('online');
        $operator = $operator_name."".NETWORK_NAME;
        $data="operator=".$operator."&operator_id=".$operator_id."&online=".$online;
            // Method is POST
        $method ="POST";
        $url = DASH_BOARD_API."/setMSOStatus";
        $hdr = array('Content-Type: application/x-www-form-urlencoded',API_AUTH_NAME .':'.API_AUTH);
        $apiresult = $obj->callAPI($method,$hdr,$url,$data);
    }
});
/**
 * To check public ip is reachable or not
 * If reachable fetch the operator logo.  
 * url - /publicIP
 * method - POST
 * @param - String none 
 */

$app->post('/isReachablePublicIP' , 'authenticate', function() use ($app)
{
    $response = array();
    $db = new DbHandler();
    $res = $db->getOperatorlogo();
    foreach ($res as $key => $value){
        $response[$key]    = $value;
    }
    echoResponse(201, $response);
});
/**
 * Get URL for displaying logo
 * url - /getUrl
 * method - POST
 * @param - String none 
 */
$app->post('/getUrl' , 'authenticate', function() use ($app)
{
    $response = array();
    $response['error']=false; 
    $response['url']=HTTP_SERVER;
    $response['version'] = APP_VERSION;
    echoResponse(201, $response);
});
/**
 * To Track Mobile and Operator location
 * url - /getServerIP
 * method - POST
 * @param - String none 
 */
$app->post('/getServerIP' , 'authenticate', function() use ($app)
{
    $response = array();
    $db = new DbHandler();
    $res = $db->getServerIP();
    foreach ($res as $key => $value){
        $response[$key]    = $value;
    }
    echoResponse(201, $response);
});
/**
 * To Track Mobile and Operator location
 * url - /updateServerIP
 * method - POST
 * @param - String none 
 */
$app->post('/updateServerIP' , 'authenticate', function() use ($app)
{
    $response = array();
    $db = new DbHandler();
    $server_ip = $app->request->post('server_ip');    
    $res = $db->updateServerIP($server_ip);
    foreach ($res as $key => $value){
        $response[$key]    = $value;
    }
    echoResponse(201, $response);
});

/**
 * For user login
 * url - /isLogin
 * method - POST
 * @param - String username,String password 
 */
$app->post('/isLogin' , 'authenticate', function() use ($app) {
    $response = array();
    $error=array();
    $db = new DbHandler();
    $helper = new Helper();
    // check for required params
    verifyRequiredParams(array('username','password'));
    // reading post params
    $username = $app->request->post('username');
    $password = $app->request->post('password');

    $error['username']=$helper->verifyStringParams($username,100);
    $error['password']=$helper->verifyStringParams($password,100);      

    $error_encountered=0;
    foreach ($error as $key => $value) {
        if($value){
            $response[$key]=$value;
            $error_encountered=1;
        }
    }
    if($error_encountered) {
        $response["error"] = true;
        echoResponse(400, $response);
        $app->stop();
    }else{
        $res = $db->isLogin($username,$password);
        foreach($res as $key => $value){
            $response[$key]    = $value;
        }
        //Android Logs
        $db->CaptureAndroidLogs("isLogin",$response['data']['user_id']);
        echoResponse(201, $response);
     }
    
});
/**
 * Checking Stb is mapped with operator or not.
 * url - /stbMap
 * method - POST
 * @param - String stb_no,Integer operator_id 
 */
$app->post('/stbMap' , 'authenticate', function() use ($app)
{
    $response = array();
    $error=array();
    $db = new DbHandler();
    $helper = new Helper();
    verifyRequiredParams(array('stb_no','operator_id'));    
    $stb_no = $app->request->post('stb_no');
    $operator_id = $app->request->post('operator_id');
    $error['stb_no']=$helper->verifyStbNo($stb_no,14); 
    $error['operator_id'] = $helper->verifyIntegerParams($operator_id,100);
    $stb_flag = 1;                      //Handling Validate response. 
    $result = $db->isValidate($stb_no,$operator_id,$stb_flag);
    if($result['error']=== true && ($result['errorCode']==5 || $result['errorCode']==3||$result['errorCode']==6 ||$result['errorCode']==9||$result['errorCode']==100))
    {
        foreach ($result as $key => $value){
            $response[$key]=$value;
        }
        echoResponse(201, $response);
    }
    else
    {
        $res = $db->stbMap($stb_no,$operator_id);
        foreach ($res as $key => $value)
        {
            $response[$key]    = $value;
        }
        echoResponse(201, $response);
      
    }
});
/**
 * Fetching customer details.
 * url - /custDetails
 * method - POST
 * @param - String stb_no,Integer operator_id 
 */
$app->post('/custDetails' , 'authenticate', function() use ($app)
{
	$response = array();
    $error=array();
    $db = new DbHandler();
    $helper = new Helper();
    // check for required params
    verifyRequiredParams(array('stb_no','operator_id'));    
    // reading post params
    $stb_no = $app->request->post('stb_no');
    $operator_id = $app->request->post('operator_id');
    
    $error['stb_no']=$helper->verifyStbNo($stb_no,14); 
    $error['operator_id'] = $helper->verifyIntegerParams($operator_id,100);
    
    $error_encountered=0;
        foreach ($error as $key => $value) {
        if($value){
            $response[$key]=$value;
            $error_encountered=1;
        }
    }

    if($error_encountered)
    {
        $response["error"] = true;
        echoResponse(400, $response);
        $app->stop();
    }
    else
    {

        $res = $db->custDetails($stb_no,$operator_id);
        foreach ($res as $key => $value)
        {
            $response[$key]    = $value;
        }
        echoResponse(201, $response);
  
    }
});
/**
 * Fetching customer group details.
 * url - /getGroupDetails
 * method - POST
 * @param - none 
 */
$app->post('/getGroupDetails' , 'authenticate', function() use ($app)
{
    $response = array();
    $error=array();
    $db = new DbHandler();
    if($error_encountered) 
    {
        $response["error"] = true;
        echoResponse(400, $response);
        $app->stop();
    }
    else
    {         
        $res = $db->getGroupDetails();
        foreach ($res as $key => $value)
        {
            $response[$key]    = $value;
        }
        echoResponse(201, $response);
    }

});
/**
 * Fetching customer group details.
 * url - /getCountryDetails
 * method - POST
 * @param - none 
 */
$app->post('/getCountryDetails' , 'authenticate', function() use ($app)
{
    $response = array();
    $error=array();
    $db = new DbHandler();
    if($error_encountered) 
    {
        $response["error"] = true;
        echoResponse(400, $response);
        $app->stop();
    }
    else
    {         
        $res = $db->getCountryDetails();
        foreach ($res as $key => $value)
        {
            $response[$key]    = $value;
        }
        echoResponse(201, $response);
    }
});
/**
 * Fetching customer group details.
 * url - /getStateRegion
 * method - POST
 * @param - Integer country_id
 */
$app->post('/getStateRegion' , 'authenticate', function() use ($app)
{
	$response = array();
    $error=array();
    $db = new DbHandler();
    $helper = new Helper();
    // check for required params
    verifyRequiredParams(array('country_id'));
    // reading post params
    $country_id = $app->request->post('country_id');
    $error['country_id'] = $helper->verifyIntegerParams($country_id,7,0);
    
    $error_encountered=0;
    foreach ($error as $key => $value)
    {
        if($value){
            $response[$key]=$value;
            $error_encountered=1;
        }
    }
    if($error_encountered)
    {
        $response["error"] = true;
        echoResponse(400, $response);
        $app->stop();
    }
    else
    {  
    	$res = $db->getStateRegion($country_id);
        foreach ($res as $key => $value)
        {
            $response[$key]    = $value;
        }
        echoResponse(201, $response);
    }
});
/**
 * Fetching customer group details.
 * url - /getRegions
 * method - POST
 * @param - Integer zone_id
 */
$app->post('/getRegions' , 'authenticate', function() use ($app)
{
    $response = array();
    $error=array();
    $db = new DbHandler();
    $helper = new Helper();
    // check for required params
    verifyRequiredParams(array('zone_id'));
    // reading post params
    $zone_id = $app->request->post('zone_id');
    $error['zone_id']=$helper->verifyIntegerParams($zone_id,7,0);
    $error_encountered=0;
    foreach ($error as $key => $value)
    {
        if($value){
        $response[$key]=$value;
        $error_encountered=1;
        }
    }
    if($error_encountered)
    {
        $response["error"] = true;
        echoResponse(400, $response);
        $app->stop();
    }
    else
    {         
        $res = $db->getRegions($zone_id);
        foreach ($res as $key => $value)
        {
            $response[$key]    = $value;
        }
        echoResponse(201, $response);
    }
});
/**
 * Adding new customer.
 * url - /enableUser
 * method - POST
 * @param - Integer operator_id,String first_name,String last_name,String stb_no,String sc_no,String email,
 			Integer mobile_no,String address_1,String address_2,Integer country_id,Integer zone_id,String city,Integer region_pin,Integer sms_group_id,Integer customer_no,Integer kms_group_id,Integer user_id,Integer region_id.
 */
$app->post('/enableUser' , 'authenticate', function() use ($app) {

    $response = array();
    $error=array();
    $db = new DbHandler();
    $obj = new restapi(); 
    $helper = new Helper(); 
    // check for required params
    verifyRequiredParams(array('operator_id','first_name','last_name','stb_no','mobile_no','address_1','region_pin','email','country_id','zone_id','city','region_id'));
    // reading post params
    $operator_id = $app->request->post('operator_id');
    $first_name = $app->request->post('first_name');
    $last_name = $app->request->post('last_name');
    $stb_no = $app->request->post('stb_no');
    $sc_no = $app->request->post('sc_no');
    $email = $app->request->post('email');
    $mobile_no = $app->request->post('mobile_no');
    $address_1 = $app->request->post('address_1');
    $address_2 = $app->request->post('address_2');
    $country_id= $app->request->post('country_id');
    $zone_id = $app->request->post('zone_id');
    $city = $app->request->post('city');
    $region_pin = $app->request->post('region_pin');
    $region_id = $app->request->post('region_id');
    $sms_group_id = $app->request->post('customer_group_id');
    $kms_group_id = $db->getKMSGroupID($sms_group_id);

    /*var_dump($operator_id."~".$first_name."~".$last_name."~".$stb_no."~".$sc_no."~".$mobile_no."~".$address_1."~".$address_2."~".$region_pin."~".$email."~".$country_id."~".$zone_id."~".$city."~".$region_id."~".$sms_group_id);die;*/
    
    $error['first_name']=$helper->verifyStringParams($first_name,100);
    $error['last_name']=$helper->verifyStringParams($last_name,100);      
    $error['stb_no']=$helper->verifyStbNo($stb_no,14);        
    $error['mobile_no']=$helper->verifyIntegerParams($mobile_no,10,1);
    $error['region_pin']=$helper->verifyIntegerParams($region_pin,6,1);

    $customer_no = $db->generateUniqueCustomerID();
    $stb_flag = 1;                      //Handling Validate response. 
    $error_encountered=0;
    foreach ($error as $key => $value)
    {
        if($value){
        $response[$key]=$value;
        $error_encountered=1;
        }
    }
    if($error_encountered)
    {
        $response["error"] = true;
        echoResponse(400, $response);
        $app->stop();
    }
    else
    {   
        $ValidateResp = $db->validateCustomerData($sc_no,$mobile_no,$stb_no,$operator_id,$stb_flag);
        $OperatorStatus = $db->ValidateOperator($operator_id);
        $stbMappedOperatorId = $db->getOperatorID($stb_no);
        if($ValidateResp['error']==1 && $ValidateResp['errorCode']==13){
            $response["error"] = true;
            $response["errorCode"] = 13;
            echoResponse(201, $response);
        }
        else if($ValidateResp['error']==1 && $ValidateResp['errorCode']==14){
            $response["error"] = true;
            $response["errorCode"] = 14;
            echoResponse(201, $response);
        }
        else if(($ValidateResp['error']==1 && $ValidateResp['errorCode']==5) || $stbMappedOperatorId['error']==1){
            $response["error"] = true;
            $response["errorCode"] = 5;
            echoResponse(201, $response);
        }
        else if($ValidateResp['error']==1 && $ValidateResp['errorCode']==3){
            $response["error"] = true;
            $response["errorCode"] = 3;
            echoResponse(201, $response);
        }
        else if($ValidateResp['error']==1 && $ValidateResp['errorCode']==6){
            $response["error"] = true;
            $response["errorCode"] = 6;
            echoResponse(201, $response);
        }
        else{
              $stbMappedOperatorId = $stbMappedOperatorId['operator_id'];
              $data="customer_no=".$customer_no."&first_name=".$first_name."&last_name=".$last_name."&stb_no=".$stb_no."&email=".$email.
            "&mobile_no=".$mobile_no."&region_pin=".$region_pin."&group_id=".$kms_group_id;
            // Method is POST
            $method ="POST";
            $url = KMS_API."/enableUser";
            $hdr = array('Content-Type: application/x-www-form-urlencoded',API_AUTH_NAME .':'.API_AUTH);
            //by this we are calling KMS API 
            $apiresult = $obj->callAPI($method,$hdr,$url,$data);
            $kmsResp = json_decode($apiresult, true);
            $user_id = $kmsResp['id'];
            if($kmsResp['error'] === false)
            {
                /*var_dump($operator_id."~".$first_name."~".$last_name."~".$stb_no."~".$sc_no."~".$mobile_no."~".$address_1."~".$address_2."~".$region_pin."~".$email."~".$country_id."~".$zone_id."~".$city."~".$region_id."~".$sms_group_id."~".$user_id);die;*/
                $result = $db->enableUser($stbMappedOperatorId,$first_name,$last_name,$stb_no,$sc_no,$email,$mobile_no,$address_1,$address_2,$country_id,$zone_id,$city,$region_pin,$sms_group_id,$customer_no,$kms_group_id,$user_id,$region_id);
                
                foreach ($result as $key => $value)
		        {
		            $response[$key]    = $value;
		        }
        		echoResponse(201, $response);
                    //Android Logs
        		$db->CaptureAndroidLogs("enableUser",$operator_id);
            }
            else
            {
            	foreach ($kmsResp as $key => $value)
                    {
                        $response["error"] = true;
                        $response[$key]=$value;
                    }
                    echoResponse(201, $response);
            }
        }
    }
});
/**
 * Fetching operator details.
 * url - /getOperatorDetail
 * method - POST
 * @param - Integer operator_id
 */
$app->post('/getOperatorDetail' , 'authenticate', function() use ($app) {
   
    $response = array();
    $error=array();
    $db = new DbHandler();
    $obj = new restapi(); 
    $helper = new Helper();
    verifyRequiredParams(array('operator_id'));
    $operator_id = $app->request->post('operator_id');

    $error['operator_id'] = $helper->verifyIntegerParams($operator_id,100);

    $error_encountered=0;
    foreach ($error as $key => $value) {
        if($value){
            $response[$key]=$value;
            $error_encountered=1;
        }
    }
    if($error_encountered) {
       
        $response["error"] = true;
        echoResponse(400, $response);
        $app->stop();
    }else{
        
        $res = $db->getOperatorDetail($operator_id);
        foreach ($res as $key => $value) {
          $response[$key]    = $value;
        }
            //Android Logs
        $db->CaptureAndroidLogs("getOperatorDetail",$operator_id);
        echoResponse(201, $response);

    }

});
/**
 * Searching stb details.
 * url - /searchStbNo
 * method - POST
 * @param - Integer operator_id, String stb_no.
 */
$app->post('/searchStbNo' , 'authenticate', function() use ($app) 
{
    $response = array();
    $error=array();
    $db = new DbHandler();
    $helper = new Helper(); 
    verifyRequiredParams(array('stb_no','operator_id'));    
    $stb_no = $app->request->post('stb_no');
    $operator_id = $app->request->post('operator_id');
    
    $error['stb_no']=$helper->verifyStbNo($stb_no,14);
    if($error_encountered) 
    {
        $response["error"] = true;
        echoResponse(400, $response);
        $app->stop();
    }
    else
    {         
        $res = $db->searchStbNo($stb_no,$operator_id);
        foreach ($res as $key => $value)
        {
            $response[$key]    = $value;
        }
            //Android Logs
        $db->CaptureAndroidLogs("searchStbNo",$operator_id);
        echoResponse(201, $response);
    }
});
/**
 * Checking command permissions.
 * url - /getCommandList
 * method - POST
 * @param - Integer operator_id, String stb_no.
 */
$app->post('/getCommandList' , 'authenticate', function() use ($app)
{
    $response = array();
    $error=array();
    $db = new DbHandler();
    $helper = new Helper(); 

    $stb_no = $app->request->post('stb_no');
    $operator_id = $app ->request->post('operator_id');

    $error['stb_no'] = $helper->verifyStbNo($stb_no,14); 
    $error['operator_id'] = $helper->verifyIntegerParams($operator_id,100);

    $error_encountered=0;
    foreach ($error as $key => $value) {
        if($value){
            $response[$key]=$value;
            $error_encountered=1;
        }
    }
    
    if($error_encountered) 
    {
        $response["error"] = true;
        echoResponse(400, $response);
        $app->stop();
    }
    else
    {	
    	$res = $db->getCommandList($stb_no,$operator_id);
        foreach ($res as $key => $value)
        {
            $response[$key]    = $value;
        }
        	//Android Logs
        $db->CaptureAndroidLogs("getCommandList",$operator_id);
        echoResponse(201, $response);
    }
});
/**
 * Activate the stb.
 * url - /enableSTBActivation
 * method - POST
 * @param - Integer operator_id, String stb_no.
 */

$app->post('/enableSTBActivation' , 'authenticate', function() use ($app)
{
	$response = array();
    $error=array();
    $db = new DbHandler();
    $obj = new restapi();
    $helper = new Helper(); 

    verifyRequiredParams(array('stb_no','operator_id'));
    $stb_no = $app->request->post('stb_no');
    $operator_id = $app->request->post('operator_id');
    $now_datetime = new DateTime("now", new DateTimeZone('Asia/Kolkata'));
    $start_time =  $now_datetime->getTimestamp();
    $expiry = strtotime("+10 year",$start_time);
    
    $error['stb_no'] = $helper->verifyStbNo($stb_no,14); 
    $error['operator_id'] = $helper->verifyIntegerParams($operator_id,100);
    $error_encountered=0;
    foreach ($error as $key => $value) {
        if($value){
            $response[$key]=$value;
            $error_encountered=1;
        }
    }
    
    if($error_encountered) 
    {
        $response["error"] = true;
        echoResponse(400, $response);
        $app->stop();
    }
    else
    {
        $stb_flag = 0;                      //Handling Validate response. 
	    $hasPermission = $db->getCommandPermission(0,$operator_id);
	    if(!$hasPermission)
	    {
	        $response["error"] = true;
	        $response['errorCode'] = 15;
	        echoResponse(201, $response);
	    }
        $stbMappedOperatorId = $db->getOperatorID($stb_no);
        $stbMappedOperatorId = $stbMappedOperatorId['operator_id'];
	    $result = $db->isValidate($stb_no,$stbMappedOperatorId,$stb_flag);
        $userStatus = $db->isStatus($stb_no);
        if($result['error']=== false && $response['errorCode']=22)
	    {
	        foreach ($result as $key => $value)
	        {
	            $response[$key]=$value;
	        }
	        echoResponse(201, $response);
	    }
        else if($result['error']=== true && $result['errorCode']!=100)
        {
            foreach ($result as $key => $value)
            {
                $response[$key]=$value;
            }
            echoResponse(201, $response);
        }
        else if($userStatus['error']=== true && $userStatus['errorCode']=9)
        {
            foreach ($userStatus as $key => $value)
            {
                $response[$key]=$value;
            }
            echoResponse(201, $response);
        }
	    else
	    {   
	        $data="stb_no=".$stb_no."&expiry=".$expiry;
            //var_dump($data);die;
	        // Method is POST
	        $method ="POST";
	        $url = KMS_API."/enableSTBActivation";
	        $hdr = array('Content-Type: application/x-www-form-urlencoded',API_AUTH_NAME .':'.API_AUTH);
	        $apiresult = $obj->callAPI($method,$hdr,$url,$data);
	        $kmsResp = json_decode($apiresult, true);
	        $tx_id = $kmsResp['id'];
	        $mq_response = $kmsResp['mq_response'];
	        $mqError = $kmsResp['error'];
	       	if($mq_response=="ACK")
	        {
	            $ack  = 1;
	            $nack  = -1;
	        }
	        else
	        {
	        	 $ack  = -1;
	            $nack = 1; 
	        }
	        if($mqError === false)
	        {
	        	
	        	$result = $db->enableSTBActivation($stb_no,$stbMappedOperatorId,$expiry,$tx_id,$ack,$nack);
	        	
	        	if($result['error']=== true)
	            {
	                foreach ($result as $key => $value)
	                {
	                    $response[$key]=$value;
	                }
	                echoResponse(201, $response);
	            }
	            else
	            {
	            	$resend_status = 0;
	                $command_id = 0;
	                $log_target_level = 1;
	                $log_target = $stb_no;
	                $db->genericLogCommandsFunc($tx_id,$mq_response,$log_target_level,$log_target,$command_id,$resend_status,$stbMappedOperatorId,$operator_id);
	                
	                foreach ($result as $key => $value)
	                {
	                    $response[$key]=$value;
	                }
	                echoResponse(201,$response);
	            }
	        }
	    }
	}
    $db->CaptureAndroidLogs("enableSTBActivation",$operator_id);
});
/**
* Addition of Get Transaction 
* url - /getTranscation 
* method - POST
* @param - null.
*/
$app->post('/getRecentTransaction' , 'authenticate', function() use ($app)
{

	$response = array();
	$error=array();
	$db = new DbHandler();
	$helper = new Helper(); 
	// check for required params
	verifyRequiredParams(array('stb_no','command_id','operator_id'));

	$stb_no     = $app->request->post('stb_no');
	$command_id = $app->request->post('command_id');
	$operator_id = $app->request->post('operator_id');

	if($command_id == 6 || $command_id == 10)
	{
		$product_id = $app->request->post('product_id'); 
	}

	$error['stb_no'] = $helper->verifyStbNo($stb_no,14); 

	$error_encountered=0;
	foreach ($error as $key => $value)
	{
		if($value){
		$response[$key]=$value;
		$error_encountered=1;
		}
	}
	if($error_encountered)
	{
		$response["error"] = true;
		echoResponse(400, $response);
		$app->stop();
	}
	else
	{  
		if($command_id == 6)
		{
			$result = $db->packageStatus($product_id,$stb_no,$operator_id);
            if($result['error']=== true)
			{
				foreach ($result as $key => $value)
				{
					$response["error"] = true;
				}
				echoResponse(201, $response);
			}
			else
			{
				$res = $db->getRecentTransaction($stb_no,$command_id,$operator_id);
				if($res['error']==true)
				{
					$res['errorCode']=2;	
				}
				foreach ($res as $key => $value)
				{
					$response[$key]    = $value;
				}
				echoResponse(201, $response);
			}    
		}
		else if($command_id == 10)
		{
			$result = $db->productStatus($product_id,$stb_no,$operator_id);
			if($result['error']=== true)
			{
				foreach ($result as $key => $value)
				{
					$response["error"] = true;
				}
				echoResponse(201, $response);
			}
			else
			{
				$res = $db->getRecentTransaction($stb_no,$command_id,$operator_id);
				if($res['error']==true)
				{
					$res['errorCode']=2;	
				}
				foreach ($res as $key => $value)
				{
					$response[$key]    = $value;
				}
				echoResponse(201, $response);
			}    
		}
		else
		{
			$res = $db->getRecentTransaction($stb_no,$command_id,$operator_id);
            if($res['error']==true)
			{
				$res['errorCode']=2;
			}
			foreach ($res as $key => $value)
			{
				$response[$key]    = $value;
			}
			echoResponse(201, $response);
		}    
	}
});
/**
 * Checking Packages.
 * url - /getPackages
 * method - POST
 * @param - none.
 */
$app->post('/getPackages' , 'authenticate', function() use ($app) 
{
    $response = array();
    $error=array();
    $db = new DbHandler();
    $helper = new Helper(); 
    // check for required params
    verifyRequiredParams(array('region_id'));
    // reading post params
    $region_id = $app->request->post('region_id');
    $error['region_id']=$helper->verifyIntegerParams($region_id,7,0);
    $error_encountered=0;
    foreach ($error as $key => $value) {
        if($value){
            $response[$key]=$value;
            $error_encountered=1;
        }
    }
    if($error_encountered)
    {
        $response["error"] = true;
        echoResponse(400, $response);
        $app->stop();
    }
    else
    { 
        $res = $db->getPackages($region_id);
        foreach ($res as $key => $value)
        {
            $response[$key]    = $value;
        }
        echoResponse(201, $response);
    }
});
/**
 * Checking Package Details.
 * url - /getPackageDetails
 * method - POST
 * @param - none.
 */
$app->post('/getPackageDetails' , 'authenticate', function() use ($app)
{
    $response = array();
    $error=array();
    $db = new DbHandler();
    $helper = new Helper(); 
    // check for required params
    verifyRequiredParams(array('package_id'));
    // reading post params
    $package_id = $app->request->post('package_id');
    $error['package_id']=$helper->verifyIntegerParams($package_id,7,0);
   
    $error_encountered=0;
    foreach ($error as $key => $value) {
        if($value){
            $response[$key]=$value;
            $error_encountered=1;
        }
    }
    if($error_encountered)
    {
        $response["error"] = true;
        echoResponse(400, $response);
        $app->stop();
    }
    else
    {         
       
        $res = $db->getPackageDetails($package_id);
        foreach ($res as $key => $value)
        {
            $response[$key]    = $value;
        }
        echoResponse(201, $response);
    }
});
/**
 * Subscribing Package.
 * url - /enablePackageSubscription
 * method - POST
 * @param - String stb_no,Integer user_id,Integer operator_id,Integer package_id,String store_url,Integer option_id.
 */
$app->post('/enablePackageSubscription' , 'authenticate', function() use ($app)
{
	$response = array();
    $error=array();
    $db = new DbHandler();
    $obj = new restapi();
    $helper = new Helper();     
    // check for required params
    verifyRequiredParams(array('stb_no','user_id','operator_id','package_id','store_url','option_id','broadcaster_id','tax_class_id'));
    // reading post params
    $stb_no = $app->request->post('stb_no');
    $user_id = $app->request->post('user_id');
    $operator_id = $app->request->post('operator_id');
    $package_id = $app->request->post('package_id');
    $store_url = $app->request->post('store_url');
    $option_id = $app->request->post('option_id'); 
    $broadcaster_id = $app->request->post('broadcaster_id');
    $tax_class_id = $app->request->post('tax_class_id');
    $error['operator_id']=$helper->verifyIntegerParams($operator_id,7,0);
    $error['package_id']=$helper->verifyIntegerParams($package_id,7,0);
   /* var_dump($stb_no."~".$user_id."~".$operator_id."~".$package_id."~".$store_url."~".$option_id."~".$broadcaster_id);die;*/
    $error_encountered=0;
    foreach ($error as $key => $value) {
        if($value){
            $response[$key]=$value;
            $error_encountered=1;
        }
    }
    if($error_encountered)
    {
        $response["error"] = true;
        echoResponse(400, $response);
        $app->stop();
    }
    else
    {         
	    $hasPermission = $db->getCommandPermission(6,$operator_id);
        if(!$hasPermission){
	        $response["error"] = true;
	        $response['errorCode'] = 15;
	        echoResponse(201, $response);
	    }
        $stb_flag = 0;                      //Handling Validate response. 
	    $result = $db->isValidate($stb_no,$operator_id,$stb_flag);
	    $result_pay = $db->isLCO_MSO_PAYMENT($operator_id,$package_id,$option_id);
        $package_type = $db->getPackageType($package_id);
        $subscribed_pack = $db->getSubscribed_Package($stb_no);
        $is_suspend = $db->isSTBSuspended($stb_no);
        
        if($subscribed_pack['data'][0]['package_type']!='')
        {    
            if(($subscribed_pack['data'][0]['package_type']!=1) ||$subscribed_pack['data'][0]['package_type']!=NA)
            {
                if(($package_type == $subscribed_pack['data'][0]['package_type'])&& $package_id !=$subscribed_pack['data'][0]['package_id'])
                {
                    $response["error"] = true;
                    $response['errorCode'] = 23;
                    echoResponse(201, $response);
                    die;
                }
            }
            else
            {
                $response["error"] = true;
                $response['errorCode'] = 26;
                echoResponse(201, $response);
            }
        }
        if($is_suspend==1)
       	{
          $response["error"] = true;
          $response['errorCode'] = 25;
          echoResponse(201, $response);
       	} 
        else 
        {
        	if($result['error']=== true)
    	    {
    	    	foreach ($result as $key => $value)
    	        {
    	            $response[$key]=$value;
    	        }
    	        echoResponse(201, $response);
    	    }
    	    else if($result_pay['error']=== true)
    	    {
    	        foreach ($result_pay as $key => $value)
    	        {
    	            $response[$key]=$value;
    	        }
    	        echoResponse(201, $response);
    	    }
    	    else{   

                    $stbMappedOperatorId = $db->getOperatorID($stb_no);
                    $stbMappedOperatorId = $stbMappedOperatorId['operator_id'];
                    $operator_status = $db->getStatusOfOperator($stbMappedOperatorId);
                    if($operator_status==1)
                    {
                        $response["error"] = true;
                        $response['errorCode'] = 6;
                        echoResponse(201, $response);
                    }
                    else
                    {
                        $package_id_kms = $db->getKMSPackageID($package_id);                //getting package id for kms
    	                $user_id_kms    = $db->getKmsUserID($stb_no);                     // getting user_id for kms
                       	$result_date    = $db->getSubscriptionDate($option_id);
    	                $start_time     = $result_date['start_time'];    
    	                $end_time       = $result_date['end_time'];
    	                $option_id_new  = $result_date['option'];                            // date for subscription.
    	                $exp_date       = $db->getValidOldSubscription($operator_id,$package_id,$stb_no);     // checking package expiry
    	                if($exp_date !=NULL){  
    	                    $SubOldExp = new DateTime($exp_date, new DateTimeZone('Asia/Kolkata'));
    	                    $SubOldExpTimestamp =  $SubOldExp->getTimestamp();
                            $expi_date = strtotime("+".$option_id_new, $SubOldExpTimestamp);
                        }else{
                            $expi_date = $end_time;
                        }
                        /*$stbMappedOperatorId = $stbMappedOperatorId['operator_id'];*/
    	                $data="package_id=".$package_id_kms."&user_id=".$user_id_kms."&start_time=".$start_time."&end_time=".$expi_date;
                        $method ="POST";
                        $url= KMS_API."/enablePackageSubscription";
    	                $hdr = array('Content-Type: application/x-www-form-urlencoded',API_AUTH_NAME .':'.API_AUTH);
    	                //by this we are calling KMS API 
    	                $apiresult = $obj->callAPI($method,$hdr,$url,$data);
                        $kmsResp = json_decode($apiresult, true);
    			        $tx_id = $kmsResp['id'];
                        $mq_response = $kmsResp['mq_response'];
    			        $mqError = $kmsResp['error'];
    			       	if($mq_response=="ACK")
    	                {
    	                   $ack  = 1;
    	                   $nack = -1; 
    	                }
    	                else
    	                {
    	                   $ack = -1; 
    	                   $nack = 1; 
    	                }
    	                
    	                if($mqError === false)
    	                {
    	                    $result = $db->enablePackageSubscription($stb_no,$user_id,$stbMappedOperatorId,$package_id,$start_time,$expi_date,$store_url,$option_id_new,$broadcaster_id,$tx_id,$ack,$nack,$operator_id,$tax_class_id);
    	                    $resend_status = 0;
    	                    $command_id = 6;
    	                    $log_target_level = 1;
    	                    $log_target = $stb_no;
    	                    $command = "PACKAGE SUBSCRIPTION";
    	                   
    	                   $db->genericLogCommandsFunc($tx_id,$mq_response,$log_target_level,$log_target,$command_id,$resend_status,$stbMappedOperatorId,$operator_id,$package_id);
    	                    foreach ($result as $key => $value)
    	                    {
    	                        $response[$key]=$value;
    	                    }          
    	                    echoResponse(201,$response); 
    	                }
    	        }
            }
        }
    }
    $db->CaptureAndroidLogs("enablePackageSubscription",$operator_id); 
});
/**
 * Checking A-LA-CARTE.
 * url - /getProduct
 * method - POST
 * @param - none.
 */
$app->post('/getProducts' , 'authenticate', function() use ($app) 
{
    $response = array();
    $db = new DbHandler();
    $res = $db->getProducts();
    foreach ($res as $key => $value)
    {
        $response[$key]    = $value;
    }
    echoResponse(201, $response);
});
/**
 * Checking Product Details.
 * url - /getProductDetails
 * method - POST
 * @param - none.
 */
$app->post('/getProductDetails' , 'authenticate', function() use ($app)
{
    $response = array();
    $error=array();
    $db = new DbHandler();
    $helper = new Helper(); 
    // check for required params
    verifyRequiredParams(array('product_id'));
    // reading post params
    $product_id = $app->request->post('product_id');
    $error['product_id']=$helper->verifyIntegerParams($product_id,7,0);
   
    $error_encountered=0;
    foreach ($error as $key => $value) {
        if($value){
            $response[$key]=$value;
            $error_encountered=1;
        }
    }
    if($error_encountered)
    {
        $response["error"] = true;
        echoResponse(400, $response);
        $app->stop();
    }
    else
    {         
       
        $res = $db->getProductDetails($product_id);
        foreach ($res as $key => $value)
        {
            $response[$key]    = $value;
        }
        echoResponse(201, $response);
    }
});
/**
 * Subscribing Product.
 * url - /enableProductSubscription
 * method - POST
 * @param - String stb_no,Integer user_id,Integer operator_id,Integer package_id,String store_url,Integer option_id.
 */
$app->post('/enableProductSubscription' , 'authenticate', function() use ($app)
{
    $response = array();
    $error=array();
    $db = new DbHandler();
    $obj = new restapi();
    $helper = new Helper();     
    // check for required params
    verifyRequiredParams(array('stb_no','user_id','operator_id','product_id','store_url','option_id','broadcaster_id','tax_class_id'));
    // reading post params
    $stb_no = $app->request->post('stb_no');
    $user_id = $app->request->post('user_id');
    $operator_id = $app->request->post('operator_id');
    $product_id = $app->request->post('product_id');
    $store_url = $app->request->post('store_url');
    $option_id = $app->request->post('option_id'); 
    $broadcaster_id = $app->request->post('broadcaster_id');
    $tax_class_id = $app->request->post('tax_class_id');
    $error['operator_id']=$helper->verifyIntegerParams($operator_id,7,0);
    $error['product_id']=$helper->verifyIntegerParams($product_id,7,0);
    
    $error_encountered=0;
    foreach ($error as $key => $value) {
        if($value){
            $response[$key]=$value;
            $error_encountered=1;
        }
    }
    if($error_encountered)
    {
        $response["error"] = true;
        echoResponse(400, $response);
        $app->stop();
    }
    else
    {         
        $hasPermission = $db->getCommandPermission(10,$operator_id);
        if(!$hasPermission){
            $response["error"] = true;
            $response['errorCode'] = 15;
            echoResponse(201, $response);
        }
        $stb_flag = 0;                      //Handling Validate response. 
        $result = $db->isValidate($stb_no,$operator_id,$stb_flag);
        $result_pay = $db->isLCO_MSO_PAYMENT($operator_id,$product_id,$option_id);
        $subscribed_pack = $db->getSubscribed_Package($stb_no);
        $is_suspend = $db->isSTBSuspended($stb_no);
        /*Remove $subscribed_pack['data'][0]['package_type'] !=NA after base pack impl */
        if($subscribed_pack['data'][0]['product_id']=='')
        {
            $response["error"] = true;
            $response['errorCode'] = 26;
            echoResponse(201, $response);
        }
        else if($is_suspend==1)
        {
          $response["error"] = true;
          $response['errorCode'] = 25;
          echoResponse(201, $response);
        } 
        else
        {
            if($result['error']=== true)
            {
                foreach ($result as $key => $value)
                {
                    $response[$key]=$value;
                }
                echoResponse(201, $response);
            }
            else if($result_pay['error']=== true)
            {
                foreach ($result_pay as $key => $value)
                {
                    $response[$key]=$value;
                }
                echoResponse(201, $response);
            }
            else{  
                    $stbMappedOperatorId = $db->getOperatorID($stb_no);
                    $stbMappedOperatorId = $stbMappedOperatorId['operator_id'];
                    $operator_status = $db->getStatusOfOperator($stbMappedOperatorId);
                    if($operator_status==1)
                    {
                        $response["error"] = true;
                        $response['errorCode'] = 6;
                        echoResponse(201, $response);
                    }
                    else
                    {
                        $product_id_kms = $db->getKMSProductID($product_id);                //getting package id for kms
                        $user_id_kms    = $db->getKmsUserID($stb_no);                     // getting user_id for kms
                        $result_date    = $db->getSubscriptionDate($option_id);
                        $start_time     = $result_date['start_time'];    
                        $end_time       = $result_date['end_time'];
                        $option_id_new  = $result_date['option'];                            // date for subscription.
                        $exp_date       = $db->getValidOldSubscriptionForProduct($operator_id,$product_id); // checking package expiry
                        if($exp_date !=NULL){  
                            $SubOldExp = new DateTime($exp_date, new DateTimeZone('Asia/Kolkata'));
                            $SubOldExpTimestamp =  $SubOldExp->getTimestamp();
                            $expi_date = strtotime("+".$option_id_new, $SubOldExpTimestamp);
                        }else{
                            $expi_date = $end_time;
                        }
                        //$stbMappedOperatorId = $stbMappedOperatorId['operator_id'];
                        $data="product_id=".$product_id_kms."&user_id=".$user_id_kms."&start_time=".$start_time."&end_time=".$expi_date;
                        $method ="POST";
                        $url= KMS_API."/enableProductSubscription";
                        $hdr = array('Content-Type: application/x-www-form-urlencoded',API_AUTH_NAME .':'.API_AUTH);
                        //by this we are calling KMS API 
                        $apiresult = $obj->callAPI($method,$hdr,$url,$data);
                        $kmsResp = json_decode($apiresult, true);
                        $tx_id = $kmsResp['id'];
                        $mq_response = $kmsResp['mq_response'];
                        $mqError = $kmsResp['error'];
                        if($mq_response=="ACK")
                        {
                           $ack  = 1;
                           $nack = -1; 
                        }
                        else
                        {
                           $ack = -1; 
                           $nack = 1; 
                        }
                        
                        if($mqError === false)
                        {
                            $result = $db->enableProductSubscription($stb_no,$user_id,$stbMappedOperatorId,$product_id,$start_time,$expi_date,$store_url,$option_id_new,$broadcaster_id,$tx_id,$ack,$nack,$operator_id,$tax_class_id);
                            $resend_status = 0;
                            $command_id = 6;
                            $log_target_level = 1;
                            $log_target = $stb_no;
                            $command = "PRODUCT SUBSCRIPTION";
                           
                           $db->genericLogCommandsFunc($tx_id,$mq_response,$log_target_level,$log_target,$command_id,$resend_status,$stbMappedOperatorId,$operator_id,$product_id);
                            foreach ($result as $key => $value)
                            {
                                $response[$key]=$value;
                            }          
                            echoResponse(201,$response); 
                        }
                }
            }
        }
    }
    $db->CaptureAndroidLogs("enablePackageSubscription",$operator_id);
});
/**
 * Get Subscribed Package.
 * url - /getSubscribed_Package
 * method - POST
 * @param - String stb_no.
 */
$app->post('/getSubscribed_Package' , 'authenticate', function() use ($app) {
    $response = array();
    $error=array();
    $db = new DbHandler();
    $helper = new Helper();
    verifyRequiredParams(array('stb_no'));
    $stb_no = $app->request->post('stb_no');
    $error['stb_no'] = $helper->verifyStbNo($stb_no,14); 
    $error_encountered=0;
    foreach ($error as $key => $value) {
        if($value){
            $response[$key]=$value;
            $error_encountered=1;
        }
    }
    if  ($error_encountered) {
        $response["error"] = true;
        echoResponse(400, $response);
        $app->stop();
    }else{
	        $res = $db->getSubscribed_Package($stb_no);
	        foreach ($res as $key => $value) {
	          $response[$key]    = $value;
	        }
        echoResponse(201, $response);
    }
});
/**
 * Get Subscribed Products.
 * url - /getSubscribed_Product
 * method - POST
 * @param - String stb_no.
 */
$app->post('/getSubscribed_Products' , 'authenticate', function() use ($app) {
    $response = array();
    $error=array();
    $db = new DbHandler();
    $helper = new Helper();
    verifyRequiredParams(array('stb_no'));
    $stb_no = $app->request->post('stb_no');
    $error['stb_no'] = $helper->verifyStbNo($stb_no,14); 
    $error_encountered=0;
    foreach ($error as $key => $value) {
        if($value){
            $response[$key]=$value;
            $error_encountered=1;
        }
    }
    if  ($error_encountered) {
        $response["error"] = true;
        echoResponse(400, $response);
        $app->stop();
    }else{
            $res = $db->getSubscribed_Product($stb_no);
            foreach ($res as $key => $value) {
              $response[$key]    = $value;
            }
        echoResponse(201, $response);
    }
});
/**
 * Resend Box Activation.
 * url - /Resend
 * method - POST
 * @param - String stb_no,Integer target_level,Integer operator_id,Integer target,String expiry,Integer transaction_id.
 */
$app->post('/Resend' , 'authenticate', function() use ($app)
{
    $response = array();
    $db = new DbHandler();
    $obj = new restapi(); 
    
    verifyRequiredParams(array('target_level','stb_no','target','transaction_id','command_id','expiry','operator_id'));
    $stb_no         = $app->request->post('stb_no');   
    $target_level   = $app->request->post('target_level');
    $target         = $app->request->post('target');
    $transaction_id = $app->request->post('transaction_id');
    $command_id     = $app->request->post('command_id');
    $expiry         = $app->request->post('expiry');
    $operator_id    = $app->request->post('operator_id');
    $stb_flag = 0;                      //Handling Validate response. 
	$result = $db->isValidate($stb_no,$operator_id,$stb_flag);
    $is_suspend = $db->isSTBSuspended($stb_no);

      if($result['error']=== true)
	    {
	        foreach ($result as $key => $value)
	        {
	            $response[$key]=$value;
	        }
	        echoResponse(201, $response);
	    }
      else if($is_suspend==1)
       {
          $response["error"] = true;
          $response['errorCode'] = 25;
          echoResponse(201, $response);
       }  
     else
        {   
            $stbMappedOperatorId = $db->getOperatorID($stb_no);
            $stbMappedOperatorId = $stbMappedOperatorId['operator_id'];
            $operator_status = $db->getStatusOfOperator($stbMappedOperatorId);
            if($operator_status==1)
            {
                $response["error"] = true;
                $response['errorCode'] = 6;
                echoResponse(201, $response);
            }
            else
            {    
                $user_id_kms    = $db->getKmsUserID($stb_no);
                $data="target_level=".$target_level."&target=".$user_id_kms."&transaction_id=".$transaction_id."&command_id=".$command_id;
                // Method is POST
                 $method ="POST";
                 $url = KMS_API."/Resend";
                 $hdr = array('Content-Type: application/x-www-form-urlencoded',API_AUTH_NAME .':'.API_AUTH);
                 
                 //by this we are calling KMS API 
                $apiresult = $obj->callAPI($method,$hdr,$url,$data);
                $kmsResp = json_decode($apiresult, true);
    	        $tx_id = $kmsResp['id'];
    	        $mq_response = $kmsResp['mq_response'];
    	        $mqError = $kmsResp['error'];
    	       	if($mq_response=="ACK")
                {
                   $ack  = 1;
                   $nack = -1; 
                }
                else
                {
                   $ack = -1; 
                   $nack = 1; 
                }
                if($mqError === false)
    	        {
    	            $result = $db->Resend_Box($tx_id,$target_level,$target,$transaction_id,$command_id,$expiry,$stbMappedOperatorId,$stb_no,$ack,$nack);
    	          	
    	            $resend_status = 1;
    	            $command_id = 0;
    	            $log_target_level = "Individual";
    	            $log_target = $stb_no;
    	           
    	            $db->genericLogCommandsFunc($tx_id,$mq_response,$log_target_level,$log_target,$command_id,$resend_status,$stbMappedOperatorId,$operator_id);
    	            foreach ($result as $key => $value)
    	            {
    	                $response[$key]=$value;
    	            }
    	            echoResponse(201,$response); 
                }
            }  
        }
    $db->CaptureAndroidLogs("Resend",$operator_id);     
});
/**
 * Deactivate Box and Package.
 * url - /Disable
 * method - POST
 * @param - String stb_no,Integer target_level,Integer operator_id,Integer target,String expiry,Integer transaction_id.
 */
$app->post('/Disable' , 'authenticate', function() use ($app)
{    
	$db = new DbHandler();
    $response = array();
    $error=array();
    $obj = new restapi();
    $target_level = 1;
    verifyRequiredParams(array('target_level','stb_no','target','transaction_id','command_id','expiry','operator_id'));
    $stb_no            = $app->request->post('stb_no');
    $target_level      = $app->request->post('target_level');
    $target            = $app->request->post('target');
    $transaction_id    = $app->request->post('transaction_id');
    $command_id        = $app->request->post('command_id');
    $expiry            = $app->request->post('expiry');
    $operator_id       = $app->request->post('operator_id');
    /*$box_pack_deact    = $app->request->post('box_pack_deact');*/

    $stb_flag = 0;                      //Handling Validate response.
    $user_id_kms    = $db ->getKmsUserID($stb_no);
    $result = $db->isValidate($stb_no,$operator_id,$stb_flag);
    if($result['error']=== true)
    {
        foreach ($result as $key => $value)
        {
            $response[$key]=$value;
        }
        echoResponse(201, $response);
    }
    else
    {       $stbMappedOperatorId = $db->getOperatorID($stb_no);
            $stbMappedOperatorId = $stbMappedOperatorId['operator_id'];
            $operator_status = $db->getStatusOfOperator($stbMappedOperatorId);
            if($operator_status==1)
            {
                $response["error"] = true;
                $response['errorCode'] = 6;
                echoResponse(201, $response);
            }
            else
            {
               switch($command_id)
                {
                    case 0 :
                            $result = $db->getSubscriptionStatus($stb_no,$operator_id);
                            if($result['error']=== true)
                            {
                                foreach ($result as $key => $value)
                                {
                                    $response[$key]=$value;
                                }
                                echoResponse(201, $response);
                            }
                            else
                            {
                                $data="stb_no=".$stb_no."&command_id=".$command_id."&target=".$user_id_kms."&target_level=".$target_level;
                                // Method is POST
                                $method ="POST";
                                $url = KMS_API."/Disable";
                                $hdr = array('Content-Type: application/x-www-form-urlencoded',API_AUTH_NAME .':'.API_AUTH);

                                //by this we are calling KMS API 
                                $apiresult = $obj->callAPI($method,$hdr,$url,$data);
        				        $kmsResp = json_decode($apiresult, true);
        				        $tx_id = $kmsResp['id'];
        				        $mq_response = $kmsResp['mq_response'];
        				        $mqError = $kmsResp['error'];
        				       	if($mq_response=="ACK")
        			            {
        			               $ack  = 1;
        			               $nack = -1; 
        			            }
        			            else
        			            {
        			               $ack = -1; 
        			               $nack = 1; 
        			            }
        			            if($mqError === false)
        				        {
        	                        $command_id = 1;
        	                        $result_bx = $db->getIdsForExpiryUpdateBox($target);
        	                        if($result_bx['error']=== true)
        	                        {
        	                            foreach ($result_bx as $key => $value)
        	                            {
        	                                $response[$key]=$value;
        	                            }
        	                            echoResponse(201, $response);
        	                        }
        	                        else
        	                        {  
        	                            $result = $db->Disable_Box($stb_no,$tx_id,$target_level,$target,$transaction_id,$command_id,$stbMappedOperatorId,$ack,$nack);
        	                            if($result['error']=== true)
        	                            {
        	                                foreach ($result as $key => $value)
        	                                {
        	                                    $response[$key]=$value;
        	                                }
        	                                echoResponse(201, $response);
        	                            }
        	                            else
        	                            {
        	                                	                             	
        	                                $resend_status = 0;
        	                                $command_id = 1;
        	                                $log_target_level = "Individual";
        	                                $log_target = $stb_no;
        	                                $command = "BOX De-ACTIVATION";
        	                                $db->genericLogCommandsFunc($tx_id,$mq_response,$log_target_level,$log_target,$command_id,$resend_status,$stbMappedOperatorId,$operator_id);
        						            foreach ($result as $key => $value)
        						            {
        						                $response[$key]=$value;
        						            }
        						            echoResponse(201,$response); 
        	                            }
        	                        }
        	                    }    
                            }
                            $db->CaptureAndroidLogs("BOX De-ACTIVATION",$operator_id);
                            break;
                    case 6  :
                            $product_no = $app->request->post('package_no');
                            $product_id = $app->request->post('package_id');
                            $broadcaster_id = $app->request->post('broadcaster_id');
                            $api_product_id = $db->getKMSPackageID($product_id);
                            $data="target_level=".$target_level."&target=".$api_product_id."&stb_no=".$stb_no."&command_id=".$command_id."&product_no=".$product_no;
                            // Method is POST
                            $method ="POST";
                            $url = KMS_API."/Disable";
                            $hdr = array('Content-Type: application/x-www-form-urlencoded',API_AUTH_NAME .':'.API_AUTH);

                            //by this we are calling KMS API 
                            $apiresult = $obj->callAPI($method,$hdr,$url,$data);
        			        $kmsResp = json_decode($apiresult, true);
        			        $tx_id = $kmsResp['id'];
        			        $mq_response = $kmsResp['mq_response'];
        			        $mqError = $kmsResp['error'];
        			       	if($mq_response=="ACK")
        		            {
        		               $ack  = 1;
        		               $nack = -1; 
        		            }
        		            else
        		            {
        		               $ack = -1; 
        		               $nack = 1; 
        		            }
        		            if($mqError === false)
        			        {
        		                $command_id = 7;
                                $result_pkg = $db->getIdsForExpiryUpdate($product_id,$target);
                                if($result_pkg['error']=== true)
                                {
                                    foreach ($result_pkg as $key => $value)
                                    {
                                        $response[$key]=$value;
                                    }
                                    echoResponse(201, $response);
                                }
                                else
                                {      
                                    $result = $db->Disable_Package($stb_no,$tx_id,$target_level,$target,$transaction_id,$command_id,$product_no,$product_id,$stbMappedOperatorId,$broadcaster_id,$ack,$nack);
                                    if($result['error']=== true)
                                    {
                                        foreach ($result as $key => $value)
                                        {
                                        $response[$key]=$value;
                                        }
                                        echoResponse(201, $response);
                                    }
                                    else
                                    {
                                                  
                                        $resend_status = 0;
                                        $command_id = 7;
                                        $log_target_level = "Individual";
                                        $log_target = $stb_no;
                                        $command = "PACKAGE De-SUBS";
                                       
                                       $db->genericLogCommandsFunc($tx_id,$mq_response,$log_target_level,$log_target,$command_id,$resend_status,$stbMappedOperatorId,$operator_id,$product_id);
                                       foreach ($result as $key => $value)
                                        {
                                            $response[$key]=$value;
                                        }   
                                        echoResponse(201,$response);
                                       
                                    }
                                } 
                            }
                            $db->CaptureAndroidLogs("PACKAGE De-SUBS",$operator_id); 
                            break;
                    case 10  :
                            $product_no = $app->request->post('product_no');
                            $product_id = $app->request->post('product_id');
                            $broadcaster_id = $app->request->post('broadcaster_id');
                            $api_product_id = $db->getKMSProductID($product_id);
                            /*var_dump($stb_no."~".$target_level."~".$transaction_id."~".$command_id."~".$expiry."~".$operator_id."~".$product_no."~".$product_id."~".$broadcaster_id."~".$api_product_id);die;*/
                         
                            $data="target_level=".$target_level."&target=".$api_product_id."&stb_no=".$stb_no."&command_id=".$command_id."&product_no=".$product_no;
                            // Method is POST
                            $method ="POST";
                            $url = KMS_API."/Disable";
                            $hdr = array('Content-Type: application/x-www-form-urlencoded',API_AUTH_NAME .':'.API_AUTH);

                            //by this we are calling KMS API 
                            $apiresult = $obj->callAPI($method,$hdr,$url,$data);
                            $kmsResp = json_decode($apiresult, true);
        			        $tx_id = $kmsResp['id'];
        			        $mq_response = $kmsResp['mq_response'];
        			        $mqError = $kmsResp['error'];
        			       	if($mq_response=="ACK")
        		            {
        		               $ack  = 1;
        		               $nack = -1; 
        		            }
        		            else
        		            {
        		               $ack = -1; 
        		               $nack = 1; 
        		            }
        		            if($mqError === false)
        			        {
        		                $command_id = 11;
                                $result_prd = $db->getIdsForExpiryUpdateProduct($product_id,$target);
                                if($result_prd['error']=== true)
                                {
                                    foreach ($result_prd as $key => $value)
                                    {
                                        $response[$key]=$value;
                                    }
                                    echoResponse(201, $response);
                                }
                                else
                                {      
                                    $result = $db->Disable_Product($stb_no,$tx_id,$target_level,$target,$transaction_id,$command_id,$product_no,$product_id,$stbMappedOperatorId,$broadcaster_id,$ack,$nack);
                                    if($result['error']=== true)
                                    {
                                        foreach ($result as $key => $value)
                                        {
                                        $response[$key]=$value;
                                        }
                                        echoResponse(201, $response);
                                    }
                                    else
                                    {
                                                  
                                        $resend_status = 0;
                                        $command_id = 11;
                                        $log_target_level = "Individual";
                                        $log_target = $stb_no;
                                        $command = "A-LA-CARTE De-SUBS";
                                       
                                       $db->genericLogCommandsFunc($tx_id,$mq_response,$log_target_level,$log_target,$command_id,$resend_status,$stbMappedOperatorId,$operator_id,$product_id);
                                       foreach ($result as $key => $value)
                                        {
                                            $response[$key]=$value;
                                        }   
                                        echoResponse(201,$response);
                                       
                                    }
                                } 
                            }
                            $db->CaptureAndroidLogs("A-LA-CARTE De-SUBS",$operator_id); 
                            break;        
                        default :
                                    echo "command not found";    
                }
            }           
    }
});

$app->post('/SuspendResume' , 'authenticate', function() use ($app)
{
	$response = array();
    $error=array();
    $db = new DbHandler();
    $obj = new restapi();
    $type = 0;

    verifyRequiredParams(array('target_level','stb_no','state','user_id','target_level','operator_id'));
    $stb_no         = $app->request->post('stb_no');
    $state          = $app->request->post('state');
    $user_id        = $app->request->post('user_id');   
    $target_level   = $app->request->post('target_level');
    $operator_id    = $app->request->post('operator_id');

    $stb_flag = 0;                      //Handling Validate response. 
    $result = $db->isValidate($stb_no,$operator_id,$stb_flag);
    $hasPermission = $db->getCommandPermission(23,$operator_id); 
    if(!$hasPermission)
    {
        $response["error"] = true;
        $response['errorCode'] = 15;
        echoResponse(201, $response);
    }
    $suspend_status = $db->getSuspendStatus($stb_no,$operator_id); 
    if($result['error']=== true)
    {
        foreach ($result as $key => $value)
        {
        $response[$key]=$value;
        }
        echoResponse(201, $response);
    }
    else
    {   
        $stbMappedOperatorId = $db->getOperatorID($stb_no);
        $stbMappedOperatorId = $stbMappedOperatorId['operator_id'];
        /*var_dump($stbMappedOperatorId."!!!");die;*/
        $operator_status = $db->getStatusOfOperator($stbMappedOperatorId);
        if($operator_status==1)
        {
            $response["error"] = true;
            $response['errorCode'] = 6;
            echoResponse(201, $response);
        }    
        else if($state == 1)
        { 
            if($suspend_status == 1)
            {
                $response["error"] = true;
                $response['errorCode'] = 18;
                echoResponse(201, $response);
            }
            else
            {
            	$cmd_type = 1;
                $data="target_level=".$target_level."&target=".$stb_no."&type=".$type."&state=".$state;
                // Method is POST
                $method ="POST";
                $url = KMS_API."/SuspendResume";
                $hdr = array('Content-Type: application/x-www-form-urlencoded',API_AUTH_NAME .':'.API_AUTH);
                //by this we are calling KMS API 
                $apiresult = $obj->callAPI($method,$hdr,$url,$data);
		        $kmsResp = json_decode($apiresult, true);
		        $tx_id = $kmsResp['id'];
		        $mq_response = $kmsResp['mq_response'];
		        $mqError = $kmsResp['error'];
		       	if($mq_response=="ACK")
	            {
	               $ack  = 1;
	               $nack = -1; 
	            }
	            else
	            {
	               $ack = -1; 
	               $nack = 1; 
	            }
	            if($mqError === false)
		        {
                    $result = $db->Suspend_Resume_STB($stb_no,$user_id,$target_level,$tx_id,$type,$cmd_type,$state,$stbMappedOperatorId,$ack,$nack);
                    if($result['error']=== true)
                    {
                        foreach ($result as $key => $value)
                        {
                            $response[$key]=$value;
                        }
                        echoResponse(201, $response);
                    }
                    else
                    {
                        
                        $resend_status = 0;
                        $commandid = 23;
                        $log_target_level_numeric = 1;
                        $log_target_level = "Individual";
                        $log_target = $stb_no;

                        $db->genericLogCommandsFunc_suspend($tx_id,$mq_response,$log_target_level,$log_target,$state,$resend_status,$commandid,$log_target_level_numeric,$stbMappedOperatorId,$operator_id);
                       foreach ($result as $key => $value)
                        {
                            $response[$key]=$value;
                        }   
                        echoResponse(201,$response);
                    }
                }
            }
        }
        else
        {
            if($suspend_status == 0)
            {
                $response["error"] = true;
                $response['errorCode'] = 18;
                echoResponse(201, $response);
            }
            else
            {
                $cmd_type = 2;
                $data="target_level=".$target_level."&target=".$stb_no."&type=".$type."&state=".$state;
                // Method is POST
                $method ="POST";
                $url = KMS_API."/SuspendResume";
                $hdr = array('Content-Type: application/x-www-form-urlencoded',API_AUTH_NAME .':'.API_AUTH);

                //by this we are calling KMS API 
                $apiresult = $obj->callAPI($method,$hdr,$url,$data);
		        $kmsResp = json_decode($apiresult, true);
		        $tx_id = $kmsResp['id'];
		        $mq_response = $kmsResp['mq_response'];
		        $mqError = $kmsResp['error'];
		       	if($mq_response=="ACK")
	            {
	               $ack  = 1;
	               $nack = -1; 
	            }
	            else
	            {
	               $ack = -1; 
	               $nack = 1; 
	            }
	            if($mqError === false)
		        {
                    $result = $db->Suspend_Resume_STB($stb_no,$user_id,$target_level,$tx_id,$type,$cmd_type,$state,$stbMappedOperatorId,$ack,$nack);
                    if($result['error']=== true)
                    {
                        foreach ($result as $key => $value)
                        {
                        $response[$key]=$value;
                        }
                        echoResponse(201, $response);
                    }
                    else
                    {
                       
                        $resend_status = 0;
                        $commandid = 23;
                        $log_target_level_numeric = 1;
                        $log_target_level = "Individual";
                        $log_target = $stb_no;
                        
                        $db->genericLogCommandsFunc_suspend($tx_id,$mq_response,$log_target_level,$log_target,$state,$resend_status,$commandid,$log_target_level_numeric,$stbMappedOperatorId,$operator_id);
						foreach ($result as $key => $value)
                        {
                            $response[$key]=$value;
                        }   
                        echoResponse(201,$response);
                    }
                }
            }     
        }
    }
     $db->CaptureAndroidLogs("SuspendResume",$operator_id); 
});

/**
 * Fetching Network details.
 * url - /getNetworkDetails
 * method - POST
 * @param - none 
 */
$app->post('/getNetworkDetails' , 'authenticate', function() use ($app)
{
    $response = array();
    $error=array();
    $db = new DbHandler();
    if($error_encountered) 
    {
        $response["error"] = true;
        echoResponse(400, $response);
        $app->stop();
    }
    else
    {         
        $res = $db->getNetworkDetails();
        foreach ($res as $key => $value)
        {
            $response[$key]    = $value;
        }
        echoResponse(201, $response);
    }

});
/**
 * Fetching customer details.
 * url - /custDetails
 * method - POST
 * @param - String stb_no,Integer operator_id 
 */
$app->post('/getTaxRate' , 'authenticate', function() use ($app)
{
    $response = array();
    $error=array();
    $db = new DbHandler();
    $helper = new Helper();
    // check for required params
    verifyRequiredParams(array('stb_no','operator_id','customer_id','price','tax_class_id'));    
    // reading post params
    $stb_no = $app->request->post('stb_no');
    $operator_id = $app->request->post('operator_id');
    $customer_id = $app->request->post('customer_id');
    $price = $app->request->post('price');
    $tax_class_id = $app->request->post('tax_class_id');
    
    $error['stb_no']=$helper->verifyStbNo($stb_no,14); 
    $error['operator_id'] = $helper->verifyIntegerParams($operator_id,100);
    
    $error_encountered=0;
        foreach ($error as $key => $value) {
        if($value){
            $response[$key]=$value;
            $error_encountered=1;
        }
    }

    if($error_encountered)
    {
        $response["error"] = true;
        echoResponse(400, $response);
        $app->stop();
    }
    else
    {

        $res = $db->getTaxRate($stb_no,$operator_id,$customer_id,$price,$tax_class_id);

        foreach ($res as $key => $value)
        {
            $response[$key]    = $value;
        }
        echoResponse(201, $response);
  
    }
});
$app->run();
/*--------------------MASSAGE PACKAGE------------------------*/
class messagepacket
{
    function sendPacket($command_id,$payload)
    { 
        // Below lines added in version 2.5.16
        global $f;
        global $lock;
        //--------------------------------
        if (file_exists($lock))
        {   
            $cur_date = date("Y-m-d H:i:s");
            $file_creation_date = date("Y-m-d H:i:s", filemtime($lock));           
            $datediff = strtotime($cur_date) - strtotime($file_creation_date);
            if($datediff>60)
            {
                unlink($lock);
            }    
        }
        //---------------------------------

        $f = @fopen($lock, 'x');
        while($f === false)
        {
            $f = @fopen($lock, 'x');
        }
        $message = $command_id."`".$payload;
        $payload_with_escape =  escapeshellcmd($message);    
        $payload_with_escape = preg_replace('/\s/', '\ ', $payload_with_escape);
        // $var =  'ICAS_Message_Queue '.$payload_with_escape;
        $var =  'php ../../kms/v1/MQ/index.php '.$payload_with_escape;
        $output = exec($var." 2>&1 ");
        fclose($f);
        unlink($lock);
        return $output ;
    }
} 
?>