<?php echo $header; ?>
<div id="content">
  <div class="breadcrumb">
    <?php foreach ($breadcrumbs as $breadcrumb) { ?>
    <?php echo $breadcrumb['separator']; ?><a href="<?php echo $breadcrumb['href']; ?>"><?php echo $breadcrumb['text']; ?></a>
    <?php } ?>
  </div>
  <?php if ($error_warning) { ?>
  <div class="warning"><?php echo $error_warning; ?></div>
  <?php } ?>
  <div class="box">
    <div class="heading">
      <h1><img src="view/image/customer.png" alt="" /> <?php echo $heading_title; ?></h1>
      <div class="buttons"><a onclick="$('#form').submit();" class="button"><?php echo $button_save; ?></a><a href="<?php echo $cancel; ?>" class="button"><?php echo $button_cancel; ?></a></div>
    </div>
    <div class="content">
      <form action="<?php echo $action; ?>" method="post" enctype="multipart/form-data" id="form">
        <table class="form">
          <tr>
            <td><span class="required">*</span> <?php echo $column_country; ?></td>

              <td><select name="country_id" onchange="country(this, '1', '0');">
                  <option value=""><?php echo $text_select; ?></option>
                  <?php foreach ($countries as $country) { ?>
                  <?php if ($country['country_id'] == $country_id) { ?>
                  <option value="<?php echo $country['country_id']; ?>" selected="selected"><?php echo $country['name']; ?></option>
                  <?php } else { ?>
                  <option value="<?php echo $country['country_id']; ?>"><?php echo $country['name']; ?></option>
                  <?php } ?>
                  <?php } ?>
                  </select>
                  <?php if (isset($error_country)) { ?>
                  <span class="error"><?php echo $error_country; ?></span>
              <?php } ?>
              </td>
          </tr>
          <tr>             
              <td><span class="required">*</span> <?php echo $column_state; ?></td>
              <td><select name="zone_id">
              <?php if(isset($zones)){ ?> 
                  <option value="-1"><?php echo '---Please Select---'; ?></option>
                  <?php foreach ($zones as $value) {
                  if($value['zone_id']==$zone_id){?>
                  <option value="<?php echo $value['zone_id']; ?>" selected="selected"><?php echo $value['name']; ?></option>
                  <?php }else{ ?>
                  <option value="<?php echo $value['zone_id']; ?>"><?php echo $value['name']; ?></option>
                  <?php }}} ?>
                  </select>
                  <?php if (isset($error_zone)) { ?>
                  <span class="error"><?php echo $error_zone; ?></span>
                  <?php } ?>
              </td>
          </tr>
          <tr>
            <td><span class="required">*</span> <?php echo $column_name; ?></td>
                <td><input type="text" name="region" value="<?php echo $region; ?>"/>
                <?php if ($error_region) { ?>
              <span class="error"><?php echo $error_region; ?></span>
              <?php } ?>
                </td>
          </tr>
          <tr>
            <td><span class="required">*</span> <?php echo $column_pin; ?></td>
            <td><input type="text" name="pin" value="<?php if($pin!='')echo $pin;else echo ''; ?>" maxlength="6" <?php if($pin!='') echo 'readonly'; ?> />
              <?php if ($error_pin) { ?>
              <span class="error"><?php echo $error_pin; ?></span>
              <?php } ?></td>
          </tr>
        </table>
      </form>
    </div>
  </div>
</div>
<script type="text/javascript">
  
  function country(element, index, zone_id) { 
  if (element.value != '') { //alert(element.value);
    $.ajax({
      url: 'index.php?route=sale/region/country&token=<?php echo $token; ?>&country_id=' + element.value,
      dataType: 'json',
      success: function(json) {

        if (json['postcode_required'] == '1') {
          $('#postcode-required' + index).show();
        } else {
         // $('#postcode-required' + index).hide();
        }
        
        html = '<option value=""><?php echo $text_select; ?></option>';
        
        if (json['zone'] != '') {

          for (i = 0; i < json['zone'].length; i++) {
            
            html += '<option value="' + json['zone'][i]['zone_id'] + '"';
            
            if (json['zone'][i]['zone_id'] == zone_id) {
              html += ' selected="selected"';
            }
    
            html += '>' + json['zone'][i]['name'] + '</option>'; 
          }
        } else {
          html += '<option value="0"><?php echo "No States"; ?></option>';
        }
        $('select[name=\'zone_id\']').html(html);
        // $('select[name=\'zone_id\']').html(html);
      },
      error: function(xhr, ajaxOptions, thrownError) {
        alert(thrownError + "\r\n" + xhr.statusText + "\r\n" + xhr.responseText);
      }
    });
  }
}
</script>
<?php echo $footer; ?>