<?php echo $header; ?>
<div id="content">
  <div class="breadcrumb">
    <?php foreach ($breadcrumbs as $breadcrumb) { ?>
    <?php echo $breadcrumb['separator']; ?><a href="<?php echo $breadcrumb['href']; ?>"><?php echo $breadcrumb['text']; ?></a>
    <?php } ?>
  </div>
  <?php if ($error_warning) { ?>
  <div class="warning"><?php echo $error_warning; ?></div>
  <?php } ?>
  <div class="warning" id="error_generated" hidden="hidden"></div>
  <div class="success" id="success_generated" hidden="hidden"></div>
  <div class="box">
    <div class="heading">
      <h1><img src="view/image/customer.png" alt="" /> <?php echo $heading_title; ?></h1>
      <div class="buttons">
        <a onclick="filter();" class="button"><?php echo $button_filter; ?></a>
        <?php if ($customers) { ?>
        <a onclick="return printOption(); " class="button"><?php echo "Print"; ?></a>
        <?php } ?>
      <!-- <a onclick="$('#form').attr('target', '_blank'); $('form').submit();" class="button"><?php echo "Print"; ?></a> -->
      <!-- <a href='<?php echo $cancel; ?>' class="button"><?php echo "Cancel"; ?></a> -->

      </div>
        </div>
    <div class="content">
     <form action="<?php echo $printPdf; ?>" method="post" enctype="multipart/form-data" id="form" target="_blank">
      <table class="form">
        <tr>
          <td><span class="required">*</span>
            <input type="text" name="filter_from_date" value="<?php echo $filter_from_date; ?>" id="from_date" placeholder="From Date" readonly/>
             <?php if ($error_from_date) { ?>
                  <span class="error"><?php echo $error_from_date; ?></span>
            <?php } ?>
          </td>
          <td><span class="required">*</span>
            <input type="text" name="filter_date" value="<?php echo $filter_date; ?>" id="on_date" placeholder="To Date" readonly/>
             <?php if ($error_date) { ?>
                  <span class="error"><?php echo $error_date; ?></span>
            <?php } ?>
          </td>
          <td id="tabRegion" >
             <select name="filter_region" id="filter_region">
                <option value="-1" selected="true">Select Region</option>    
                <?php foreach ($regions as $key=>$value) { ?>                
                  <?php if($value['region_id'] == $filter_region){?>
                    <option value="<?php echo $value['region_id']; ?>"  selected><?php echo $value['region_name']; ?></option>
                  <?php }else{?>
                    <option value="<?php echo $value['region_id']; ?>"><?php echo $value['region_name']; ?></option>
                <?php }} ?>
            </select>
          </td>
          <td id="tabOperator" >
             <select name="filter_operator" id="filter_operator">
                <option value="-1" selected="true">Select LCO</option>    
                <?php foreach ($operators as $key=>$value) { ?>                
                  <?php if($value['user_id'] == $filter_operator){?>
                    <option value="<?php echo $value['user_id']; ?>"  selected><?php echo $value['username']; ?></option>
                  <?php }else{?>
                    <option value="<?php echo $value['user_id']; ?>"><?php echo $value['username']; ?></option>
                <?php }} ?>
            </select>
          </td>
        </tr>
      </table>
   
      <table class="list">
         <thead>
          <tr>       
          <td width="1" style="text-align: center;"><input id="checkAll" type="checkbox" onclick="$('input[name*=\'selected\']').attr('checked', this.checked);" /></td>
            <td class="left"><?php echo "Region Name"; ?></td>
            <td class="left"><?php echo "Operator Name"; ?></td>
            <td class="left"><?php echo $column_no; ?></td>
            <td class="left"><?php echo $column_name; ?></td>
            <td class="left"><?php echo $column_stb; ?></td>
            <!-- <td class="left"><?php echo $column_caf; ?></td> -->
            <td class="left"><?php echo $column_telephone; ?></td>
            <!-- <td class="left"><?php echo $column_address; ?></td> -->
            <!-- <td class="left"><?php echo $column_date_added; ?></td> -->
             <!-- <td class="left"><?php echo $column_active_date; ?></td> -->
            <td class="left"><?php echo $column_due_date; ?></td>
          </tr>
          </thead>
          <tbody>
            <?php if ($customers) { ?>
            <?php foreach ($customers as $customer) { ?>
            <tr>
            <td style="text-align: center;"><?php if ($customer['selected']) { ?>
                <input class="case" type="checkbox" name="selected[]" value="<?php echo $customer['customer_id']; ?>" checked="checked" />
                <?php } else { ?>
                <input class="case" type="checkbox" name="selected[]" value="<?php echo $customer['customer_id']; ?>" />
                <?php } ?></td>
              <td class="left"><?php echo $customer['region_name']; ?></td>
              <td class="left"><?php echo $customer['username']; ?></td>
              <td class="left"><?php echo $customer['customer_no']; ?></td>
              <td class="left"><?php echo $customer['name']; ?></td>
              <td class="left"><?php echo $customer['STBNO']; ?></td>
              <!-- <td class="left"><?php echo $customer['custom']; ?></td> -->
              <td class="left"><?php echo $customer['telephone']; ?></td>
<!--               <td class="left"><?php echo $customer['address']; ?></td> -->
              <!-- <td class="left"><?php echo $customer['date_added']; ?></td> -->
               <!-- <td class="left"><?php echo $customer['activation_date']; ?></td> -->
              <td class="left"><?php echo $customer['expiry_date']; ?></td>
            </tr>
            <?php } ?>
            <?php } else { ?>
            <tr>
              <td class="center" colspan="10"><?php echo $text_no_results; ?></td>
            </tr>
            <?php } ?>
          </tbody>
        </table>
      </form>
         <div class="pagination"><?php echo $pagination; ?></div>
    </div>
  </div>
</div>
<script type="text/javascript">
function printOption() {
   if(!$(".case").is(':checked')) {
        $('#error_generated').show();
        document.getElementById("error_generated").innerHTML = "Warning : Please select atleast one to process!"; 
        $('#success_generated').hide();
        return false;
    }

    $('form').submit();
    $('#error_generated').hide();
    $('#success_generated').show();
    document.getElementById("success_generated").innerHTML = "Success : Report printed Successfully!"; 
    return true;
}

$(function(){
      $("#checkAll").click(function () {
            $('.case').attr('checked', this.checked);
      });
   
      $(".case").click(function(){
   
          if($(".case").length == $(".case:checked").length) { 
             $("#checkAll").attr("checked", "checked"); //alert('click checkbox');
             $("#checkAll").prop("checked", true);
          } else {
             $("#checkAll").removeAttr("checked"); //alert('unclick checkbox');
          }
      });
  });
function filter() {
  url = 'index.php?route=bulk/customer_due_for_reactivation/filter&token=<?php echo $token; ?>';
  
  var filter_date = $('input[name=\'filter_date\']').attr('value');
  if (filter_date) {
    url += '&filter_date=' + encodeURIComponent(filter_date);
  }
  
  var filter_from_date = $('input[name=\'filter_from_date\']').attr('value');
  if (filter_from_date) {
    url += '&filter_from_date=' + encodeURIComponent(filter_from_date);
  }

  var filter_region = $('#filter_region').val();
  if(filter_region){
    url += '&filter_region=' + encodeURIComponent(filter_region);
  }

  var filter_operator = $('#filter_operator').val();
  if(filter_operator){
    url += '&filter_operator=' + encodeURIComponent(filter_operator);
  }

  location = url;
}

$(document).ready(function() {
  $('#on_date').datepicker({dateFormat: 'yy-mm-dd',
      showOn: 'both',buttonText: 'Show Date',buttonImageOnly: true,
      buttonImage: 'view/image/calendar.png'});
});
$(document).ready(function() {
  $('#from_date').datepicker({dateFormat: 'yy-mm-dd',
      showOn: 'both',buttonText: 'Show Date',buttonImageOnly: true,
      buttonImage: 'view/image/calendar.png'});
});
</script>
<?php echo $footer; ?> 
