<?php
	/*
	@File user_command_permission.php(MODEL)
	USER:	 USER_COMMAND_PERMISSION PAGE
	    This class queries,adds and updates the user_group details to the database for the backend page.

	@Author Ravi Ranjan 
	@date 16th Dec. 2016
	*/
class ModelUserUserCommandPermission extends Model {
		/*
		FUNCTION NAME 		-	validateUserGroup
		DESCRIPTION 		-	Queries to get the total number of user_group_name in the database.
		INPUT PARAMETER 	-	void
		OUTPUT PARAMETER 	- 	returns a row with column total containing count retrieved.

		*/	
		public function validateUserGroup($user_group_name){

			$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "user_group WHERE name='".$user_group_name."'");
			
			return $query->row['total'];
		}
		
		/*
		FUNCTION NAME 		-	editUserGroup
		DESCRIPTION 		-	Updates the given user_group detail to the database.
		INPUT PARAMETER 	-	data array containing the user_group details, user_group_id
		OUTPUT PARAMETER 	- 	Updates the database and returns to the user_group list page.
		*/		
		public function editUserGroup($operator_id, $data) {
			$this->db->query("DELETE FROM " . DB_PREFIX . "app_commands WHERE operator_id = '" . (int)$operator_id . "'");
			if(isset($data['permission'])){
				foreach ($data["permission"] as $id) {
					if($id==12)
						$name="Account Information";
					elseif($id==6)
						$name="Package Subscription";
					elseif($id==10)
						$name="NVOD Subscription";
					elseif($id==23)
						$name="Suspend";
					else
						$name="Box Activation";		
					$this->db->query("INSERT INTO " . DB_PREFIX . "app_commands SET operator_id = '" .$operator_id. "', command_id = '" .$id . "',command_name='".$name."'");
				}
			}
		}
		/*
		FUNCTION NAME 		-	deleteUserGroup
		DESCRIPTION 		-	Deletes the user_group for the given user_group_id
		INPUT PARAMETER 	-	user_group_id
		OUTPUT PARAMETER 	- 	Deletes the user_group and returns to the list page.
		*/	
		public function deleteUserGroup($user_group_id) {
			$this->db->query("DELETE FROM " . DB_PREFIX . "app_commands WHERE operator_id = '" . (int)$user_group_id . "'");
		}
		/*
		FUNCTION NAME 		-	addPermission
		DESCRIPTION 		-	Adds user page access permission for the given user
		INPUT PARAMETER 	-	user_id, type variable, page
		OUTPUT PARAMETER 	- 	Adds permission and returns
		*/
		public function addPermission($user_id, $type, $page) {
			$user_query = $this->db->query("SELECT DISTINCT user_group_id FROM " . DB_PREFIX . "user WHERE user_id = '" . (int)$user_id . "'");
			
			if ($user_query->num_rows) {
				$user_group_query = $this->db->query("SELECT DISTINCT * FROM " . DB_PREFIX . "user_group WHERE user_group_id = '" . (int)$user_query->row['user_group_id'] . "'");
			
				if ($user_group_query->num_rows) {
					$data = unserialize($user_group_query->row['permission']);
			
					$data[$type][] = $page;
			
					$this->db->query("UPDATE " . DB_PREFIX . "user_group SET permission = '" . serialize($data) . "' WHERE user_group_id = '" . (int)$user_query->row['user_group_id'] . "'");
				}
			}
		}
		/*
		FUNCTION NAME 		-	getUserGroup
		DESCRIPTION 		-	Retrieves the user_group details for the given user_group_id
		INPUT PARAMETER 	-	user_group_id
		OUTPUT PARAMETER 	- 	Returns the row retrieved containing the user_group detials.
		*/	
		public function getUserGroup($user_group_id) {
			$query = $this->db->query("SELECT command_id,command_name,operator_id FROM " . DB_PREFIX . "app_commands WHERE operator_id = '" . (int)$user_group_id . "' AND command_id!='-1'");
			return $query->rows;
		}
		/*
		FUNCTION NAME 		-	getUserGroups
		DESCRIPTION 		-	Retrieves all the user_group details
		INPUT PARAMETER 	-	data array containing the filter options if any
		OUTPUT PARAMETER 	- 	Returns all the rows retrieved containing the user_group detials.
		*/	
			public function getUserGroups($data = array()) {
				/*$sql = "SELECT DISTINCT(u.user_id),u.username FROM " . DB_PREFIX . "app_commands ac left join " . DB_PREFIX . "user u on(u.user_id=ac.operator_id)  WHERE user_id !=1";*/
				$sql = "SELECT u.user_id,u.username FROM " . DB_PREFIX . "user u  inner join ".DB_PREFIX."user_group ug 
				on u.user_group_id = ug.user_group_id WHERE ug.user_group_id!=1";
				
				if (isset($data['start']) || isset($data['limit'])) {
					if ($data['start'] < 0) {
						$data['start'] = 0;
					}			

					if ($data['limit'] < 1) {
						$data['limit'] = 20;
					}	
					
					$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
				}
			// var_dump($sql);die;		
				$query = $this->db->query($sql);
				
				return $query->rows;
			}
		/*
		FUNCTION NAME 		-	getTotalUserGroups
		DESCRIPTION 		-	Queries to get the total number of user_goups in the database.
		INPUT PARAMETER 	-	void
		OUTPUT PARAMETER 	- 	returns a row with column total containing count for the user_group table.
		*/		
		public function getTotalUserGroups() {
			/*$query = $this->db->query("SELECT COUNT(DISTINCT(ac.operator_id)) AS total FROM " . DB_PREFIX . "app_commands ac left join " . DB_PREFIX . "user u on(u.user_id=ac.operator_id)  WHERE user_id !=1");*/

			$query = $this->db->query("SELECT count(*) as total FROM " . DB_PREFIX . "user u  inner join ".DB_PREFIX."user_group ug on u.user_group_id = ug.user_group_id WHERE ug.user_group_id!=1");
			return $query->row['total'];
		}
		/*
		FUNCTION NAME 		-	isUserTopadmin
		DESCRIPTION 		-	Queries to get the user_group_id from the database.
		INPUT PARAMETER 	-	void
		OUTPUT PARAMETER 	- 	returns a user_group_id from the user_group table.
		*/
		public function isUserTopadmin($user_id)
		{
			$query = $this->db->query("SELECT user_group_id FROM " . DB_PREFIX . "user WHERE user_id like '" . $user_id . "'");	
			return ($query->row['user_group_id']==1)?true:false;
		}
			/*
		FUNCTION NAME 		-	getTotalUserGroups
		DESCRIPTION 		-	Queries to get the total number of user_goups in the database.
		INPUT PARAMETER 	-	void
		OUTPUT PARAMETER 	- 	returns a row with column total containing count for the user_group table.
		*/		
		public function getOperatorList($operator_id) {
	      	$query = $this->db->query("SELECT user_id,username FROM " . DB_PREFIX . "user where user_id=".$operator_id);
			
			return $query->rows;
		}

}
?>