<?php
/*
@File user.php(MODEL)
USER:	 USER PAGE
    This class queries,adds and updates the user details to the database for the backend page.

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ModelUserUser extends Model {
/*
FUNCTION NAME 		-	addUser
DESCRIPTION 		-	Adds new user detail to the database.
INPUT PARAMETER 	-	data array containing the user description.
OUTPUT PARAMETER 	- 	Adds to the database and returns to 
						the user list page with a success notification
*/	
	public function addUser($data) {			
		$this->db->query("INSERT INTO `" . DB_PREFIX . "user` SET username = '" . $this->db->escape($data['username']) . "', salt = '" . $this->db->escape($salt = substr(md5(uniqid(rand(), true)), 0, 9)) . "', password = '" . $this->db->escape(sha1($salt . sha1($salt . sha1($data['password'])))) . "', firstname = '" . $this->db->escape($data['firstname']) . "', lastname = '" . $this->db->escape($data['lastname']) . "', email = '" . $this->db->escape($data['email']) . "', user_group_id = '" . (int)$data['user_group_id'] . "', status = '" . (int)$data['status'] . "',sdk_enabled = '" . (int)$data['sdk_status'] . "', date_added = NOW(),mobile_no = '".$data['mobileno']."',address = '".$data['address']."'");
		return $this->db->getLastId();
	}
/*
FUNCTION NAME 		-	editUser
DESCRIPTION 		-	Updates the given user detail to the database.
INPUT PARAMETER 	-	data array containing the user details, user_id
OUTPUT PARAMETER 	- 	Updates the database and returns to the user list page.
*/	
	public function editUser($user_id, $data) {
		$this->db->query("UPDATE `" . DB_PREFIX . "user` SET username = '" . $this->db->escape($data['username']) . "', firstname = '" . $this->db->escape($data['firstname']) . "', lastname = '" . $this->db->escape($data['lastname']) . "', email = '" . $this->db->escape($data['email']) . "', user_group_id = '" . (int)$data['user_group_id'] . "', status = '" . (int)$data['status'] . "',sdk_enabled = '" . (int)$data['sdk_status'] . "',mobile_no = '".$data['mobileno']."',address = '".$data['address']."' WHERE user_id = '" . (int)$user_id . "' ");
		
		if ($data['password']) {
			$this->db->query("UPDATE `" . DB_PREFIX . "user` SET salt = '" . $this->db->escape($salt = substr(md5(uniqid(rand(), true)), 0, 9)) . "', password = '" . $this->db->escape(sha1($salt . sha1($salt . sha1($data['password'])))) . "' WHERE user_id = '" . (int)$user_id . "'");
		}
	}
/*
FUNCTION NAME 		-	editPassword
DESCRIPTION 		-	Updates the given password for the given user_id
INPUT PARAMETER 	-	user_id, password.
OUTPUT PARAMETER 	- 	Updates the database and returns to the user list page.
*/
	public function editPassword($user_id, $password) {
		$this->db->query("UPDATE `" . DB_PREFIX . "user` SET salt = '" . $this->db->escape($salt = substr(md5(uniqid(rand(), true)), 0, 9)) . "', password = '" . $this->db->escape(sha1($salt . sha1($salt . sha1($password)))) . "', code = '' WHERE user_id = '" . (int)$user_id . "'");
	}
/*
FUNCTION NAME 		-	editCode
DESCRIPTION 		-	Updates the given code for the given email
INPUT PARAMETER 	-	email id, code
OUTPUT PARAMETER 	- 	Updates the database and returns to the user list page.
*/
	public function editCode($email, $code) {
		$this->db->query("UPDATE `" . DB_PREFIX . "user` SET code = '" . $this->db->escape($code) . "' WHERE LCASE(email) = '" . $this->db->escape(utf8_strtolower($email)) . "'");
	}
/*
FUNCTION NAME 		-	deleteUser
DESCRIPTION 		-	Deletes the user for the given user_id
INPUT PARAMETER 	-	user_id
OUTPUT PARAMETER 	- 	Deletes the user and returns to the list page.
*/			
	public function deleteUser($user_id) {
		$this->db->query("DELETE FROM `" . DB_PREFIX . "user` WHERE user_id = '" . (int)$user_id . "'");
	}
/*
FUNCTION NAME 		-	getUser
DESCRIPTION 		-	Retrieves the user details for the given user_id
INPUT PARAMETER 	-	user_id
OUTPUT PARAMETER 	- 	Returns the row retrieved containing the user detials.
*/	
	public function getUser($user_id) {
		$query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "user` WHERE user_id = '" . (int)$user_id . "'");
	
		return $query->row;
	}
/*
FUNCTION NAME 		-	getUserByName
DESCRIPTION 		-	Retrieves the user details for the given username
INPUT PARAMETER 	-	username
OUTPUT PARAMETER 	- 	Returns the row retrieved containing the user detials.
*/	
	public function getUserByUsername($username) {
		$query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "user` WHERE username = '" . $this->db->escape($username) . "'");
	
		return $query->row;
	}
/*
FUNCTION NAME 		-	getUserByCode
DESCRIPTION 		-	Retrieves the user details for the given user code
INPUT PARAMETER 	-	user code
OUTPUT PARAMETER 	- 	Returns the row retrieved containing the user detials.
*/		
	public function getUserByCode($code) {
		$query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "user` WHERE code = '" . $this->db->escape($code) . "' AND code != ''");
	
		return $query->row;
	}
/*
FUNCTION NAME 		-	getUsers
DESCRIPTION 		-	Retrieves all the user details
INPUT PARAMETER 	-	data array containing the filter options if any
OUTPUT PARAMETER 	- 	Returns all the rows retrieved containing the user detials.
*/		
	public function getUsers($data = array()) {
		$sql = "SELECT * FROM `" . DB_PREFIX . "user`";
			
		$sort_data = array(
			'username',
			'status',
			'date_added'
		);	
			
		if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
			$sql .= " ORDER BY " . $data['sort'];	
		} else {
			$sql .= " ORDER BY username";	
		}
			
		if (isset($data['order']) && ($data['order'] == 'DESC')) {
			$sql .= " DESC";
		} else {
			$sql .= " ASC";
		}
		
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}			
			
			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}	
			
			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}
			
		$query = $this->db->query($sql);
	
		return $query->rows;
	}
/*
FUNCTION NAME 		-	getTotalUsers
DESCRIPTION 		-	Queries to get the total number of users in the database.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	returns a row with column total containing count for the user table.
*/	
	public function getTotalUsers() {
      	$query = $this->db->query("SELECT COUNT(*) AS total FROM `" . DB_PREFIX . "user`");
		
		return $query->row['total'];
	}
/*
FUNCTION NAME 		-	getTotalUsersByGroupId
DESCRIPTION 		-	Queries to get the total number of users matching user_group_id from the database.
INPUT PARAMETER 	-	user_group_id
OUTPUT PARAMETER 	- 	returns a row with column total containing count retrieved.
*/	
	public function getTotalUsersByGroupId($user_group_id) {
      	$query = $this->db->query("SELECT COUNT(*) AS total FROM `" . DB_PREFIX . "user` WHERE user_group_id = '" . (int)$user_group_id . "'");
		
		return $query->row['total'];
	}
/*
FUNCTION NAME 		-	getTotalUsersByEmail
DESCRIPTION 		-	Queries to get the total number of users matching email_id from the database.
INPUT PARAMETER 	-	email
OUTPUT PARAMETER 	- 	returns a row with column total containing count retrieved
*/		
	public function getTotalUsersByEmail($email) {
      	$query = $this->db->query("SELECT COUNT(*) AS total FROM `" . DB_PREFIX . "user` WHERE LCASE(email) = '" . $this->db->escape(utf8_strtolower($email)) . "'");
		
		return $query->row['total'];
	}	

	public function enableUser($user_id) {
		$this->db->query("UPDATE `" . DB_PREFIX . "user` SET status=1 WHERE user_id = '" . (int)$user_id . "'");
	}

	public function disableUser($user_id) {
		$this->db->query("UPDATE `" . DB_PREFIX . "user` SET status=0 WHERE user_id = '" . (int)$user_id . "'");
	}

	public function getUserGroups($data = array()) {
		$sql = "SELECT * FROM " . DB_PREFIX . "user_group ";//where user_group_id !=1";			
		$query = $this->db->query($sql);
		
		return $query->rows;
	}

	public function getUserByEmail($email){
		$query = $this->db->query("SELECT email FROM ".DB_PREFIX."user WHERE email='".$email."' ");
		if($query->row!=NULL)
		return $query->row['email'];
	}
}
?>