<?php
/*
@File backup.php(MODEL)
TOOL:	 BACKUP PAGE
    This class creates the backup for the database, queries all the tables for selective backup and 
    restore the database from the backup file.

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ModelToolBackup extends Model {
/*
FUNCTION NAME 		-	restore
DESCRIPTION 		-	Loads the backup file and runs the query to restore the database.
INPUT PARAMETER 	-	sql query to retore.
OUTPUT PARAMETER 	- 	deletes the cache and returns with a success notification.
*/		
	public function restore($sql) {
		foreach (explode(";\n", $sql) as $sql) {
    		$sql = trim($sql);
    		
			if ($sql) {
      			$this->db->query($sql);
    		}
  		}
		
		$this->cache->delete('*');
	}
/*
FUNCTION NAME 		-	getTables
DESCRIPTION 		-	Retrieves all the tables from the database for selective backup.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns all the table from the database.
*/		
	public function getTables() {
		$table_data = array();
		
		$query = $this->db->query("SHOW TABLES FROM `" . DB_DATABASE . "`");
		
		foreach ($query->rows as $result) {
			if (utf8_substr($result['Tables_in_' . DB_DATABASE], 0, strlen(DB_PREFIX)) == DB_PREFIX) {
				if (isset($result['Tables_in_' . DB_DATABASE])) {
					$table_data[] = $result['Tables_in_' . DB_DATABASE];
				}
			}
		}
		
		return $table_data;
	}
/*
FUNCTION NAME 		-	backup
DESCRIPTION 		-	Generates a backup file for the database.
INPUT PARAMETER 	-	table array containing the database tables.
OUTPUT PARAMETER 	- 	Returns the backup file.
*/		
	public function backup($tables) {
		$output = '';

		foreach ($tables as $table) {
			if (DB_PREFIX) {
				if (strpos($table, DB_PREFIX) === false) {
					$status = false;
				} else {
					$status = true;
				}
			} else {
				$status = true;
			}
			
			if ($status) {
				$output .= 'TRUNCATE TABLE `' . $table . '`;' . "\n\n";
			
				$query = $this->db->query("SELECT * FROM `" . $table . "`");
				
				foreach ($query->rows as $result) {
					$fields = '';
					
					foreach (array_keys($result) as $value) {
						$fields .= '`' . $value . '`, ';
					}
					
					$values = '';
					
					foreach (array_values($result) as $value) {
						$value = str_replace(array("\x00", "\x0a", "\x0d", "\x1a"), array('\0', '\n', '\r', '\Z'), $value);
						$value = str_replace(array("\n", "\r", "\t"), array('\n', '\r', '\t'), $value);
						$value = str_replace('\\', '\\\\',	$value);
						$value = str_replace('\'', '\\\'',	$value);
						$value = str_replace('\\\n', '\n',	$value);
						$value = str_replace('\\\r', '\r',	$value);
						$value = str_replace('\\\t', '\t',	$value);			
						
						$values .= '\'' . $value . '\', ';
					}
					
					$output .= 'INSERT INTO `' . $table . '` (' . preg_replace('/, $/', '', $fields) . ') VALUES (' . preg_replace('/, $/', '', $values) . ');' . "\n";
				}
				
				$output .= "\n\n";
			}
		}

		return $output;	
	}
}
?>