<?php
/*
@File store.php(MODEL)
SETTING:	 STORE PAGE
    This class queries,adds and updates the currency details to the database for the store.

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ModelSettingStore extends Model {
/*
FUNCTION NAME 		-	addStore
DESCRIPTION 		-	Inserts a new store description to the database.
INPUT PARAMETER 	-	data array containing the store description values.
OUTPUT PARAMETER 	- 	Returns the store_id for the new store added.
*/		
	public function addStore($data) {
		$this->db->query("INSERT INTO " . DB_PREFIX . "store SET name = '" . $this->db->escape($data['config_name']) . "', `url` = '" . $this->db->escape($data['config_url']) . "', `ssl` = '" . $this->db->escape($data['config_ssl']) . "'");
		
		$this->cache->delete('store');
		
		return $this->db->getLastId();
	}
/*
FUNCTION NAME 		-	editStore
DESCRIPTION 		-	Updates the store description values with the given values
INPUT PARAMETER 	-	data array containing the store description values, store_id
OUTPUT PARAMETER 	- 	Updates the detail and returns to the list page.
*/	
	public function editStore($store_id, $data) {
		$this->db->query("UPDATE " . DB_PREFIX . "store SET name = '" . $this->db->escape($data['config_name']) . "', `url` = '" . $this->db->escape($data['config_url']) . "', `ssl` = '" . $this->db->escape($data['config_ssl']) . "' WHERE store_id = '" . (int)$store_id . "'");
						
		$this->cache->delete('store');
	}
/*
FUNCTION NAME 		-	deleteStore
DESCRIPTION 		-	Deletes the store for the given store_id
INPUT PARAMETER 	-	store_id
OUTPUT PARAMETER 	- 	Deletes the store from database and returns to the list page.
*/	
	public function deleteStore($store_id) {
		$this->db->query("DELETE FROM " . DB_PREFIX . "store WHERE store_id = '" . (int)$store_id . "'");
			
		$this->cache->delete('store');
	}	
/*
FUNCTION NAME 		-	getStore
DESCRIPTION 		-	Queries the stores description for the given store_id from the database.
INPUT PARAMETER 	-	store_id
OUTPUT PARAMETER 	- 	Return the querired store details.
*/	
	public function getStore($store_id) {
		$query = $this->db->query("SELECT DISTINCT * FROM " . DB_PREFIX . "store WHERE store_id = '" . (int)$store_id . "'");
		
		return $query->row;
	}
/*
FUNCTION NAME 		-	getStores
DESCRIPTION 		-	Queries all the store description from the database.
INPUT PARAMETER 	-	data array containing the store description values.
OUTPUT PARAMETER 	- 	Returns all the queried rows
*/	
	public function getStores($data = array()) {
		$store_data = $this->cache->get('store');
	
		if (!$store_data) {
			$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "store ORDER BY url");

			$store_data = $query->rows;
		
			$this->cache->set('store', $store_data);
		}
	 
		return $store_data;
	}
/*
FUNCTION NAME 		-	getTotalStores
DESCRIPTION 		-	Queries to get the total number of stores in the database.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	returns a row with column total containing count for the store table.
*/	
	public function getTotalStores() {
      	$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "store");
		
		return $query->row['total'];
	}	
/*
FUNCTION NAME 		-	getTotalStoresByLayoutId
DESCRIPTION 		-	Queries to get the total number of stores matching the layout_id from the database.
INPUT PARAMETER 	-	layout_id
OUTPUT PARAMETER 	- 	returns a row with column total containing count retrieved.
*/		
	public function getTotalStoresByLayoutId($layout_id) {
      	$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "setting WHERE `key` = 'config_layout_id' AND `value` = '" . (int)$layout_id . "' AND store_id != '0'");
		
		return $query->row['total'];		
	}
/*
FUNCTION NAME 		-	getTotalStoresByLanguage
DESCRIPTION 		-	Queries to get the total number of stores matching the language from the database.
INPUT PARAMETER 	-	language varibale
OUTPUT PARAMETER 	- 	returns a row with column total containing count retrieved.
*/			
	public function getTotalStoresByLanguage($language) {
      	$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "setting WHERE `key` = 'config_language' AND `value` = '" . $this->db->escape($language) . "' AND store_id != '0'");
		
		return $query->row['total'];		
	}
/*
FUNCTION NAME 		-	getTotalStoresByCurrency
DESCRIPTION 		-	Queries to get the total number of stores matching the currency from the database.
INPUT PARAMETER 	-	currency variable
OUTPUT PARAMETER 	- 	returns a row with column total containing count retrieved.
*/		
	public function getTotalStoresByCurrency($currency) {
      	$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "setting WHERE `key` = 'config_currency' AND `value` = '" . $this->db->escape($currency) . "' AND store_id != '0'");
		
		return $query->row['total'];		
	}
/*
FUNCTION NAME 		-	getTotalStoresByCountryId
DESCRIPTION 		-	Queries to get the total number of stores matching the country_id from the database.
INPUT PARAMETER 	-	country_id
OUTPUT PARAMETER 	- 	returns a row with column total containing count retrieved.
*/			
	public function getTotalStoresByCountryId($country_id) {
      	$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "setting WHERE `key` = 'config_country_id' AND `value` = '" . (int)$country_id . "' AND store_id != '0'");
		
		return $query->row['total'];		
	}
/*
FUNCTION NAME 		-	getTotalStoresByZoneId
DESCRIPTION 		-	Queries to get the total number of stores matching the zone_id from the database.
INPUT PARAMETER 	-	zone_id
OUTPUT PARAMETER 	- 	returns a row with column total containing count retrieved.
*/			
	public function getTotalStoresByZoneId($zone_id) {
      	$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "setting WHERE `key` = 'config_zone_id' AND `value` = '" . (int)$zone_id . "' AND store_id != '0'");
		
		return $query->row['total'];		
	}
/*
FUNCTION NAME 		-	getTotalStoresByCustomerGroupId
DESCRIPTION 		-	Queries to get the total number of stores matching the customer_group_id from the database.
INPUT PARAMETER 	-	customer_group_id
OUTPUT PARAMETER 	- 	returns a row with column total containing count retrieved.
*/			
	public function getTotalStoresByCustomerGroupId($customer_group_id) {
      	$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "setting WHERE `key` = 'config_customer_group_id' AND `value` = '" . (int)$customer_group_id . "' AND store_id != '0'");
		
		return $query->row['total'];		
	}	
/*
FUNCTION NAME 		-	getTotalStoresByInformationId
DESCRIPTION 		-	Queries to get the total number of stores matching the information_id from the database.
INPUT PARAMETER 	-	information_id
OUTPUT PARAMETER 	- 	returns a row with column total containing count retrieved.
*/			
	public function getTotalStoresByInformationId($information_id) {
      	$account_query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "setting WHERE `key` = 'config_account_id' AND `value` = '" . (int)$information_id . "' AND store_id != '0'");
      	
		$checkout_query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "setting WHERE `key` = 'config_checkout_id' AND `value` = '" . (int)$information_id . "' AND store_id != '0'");
		
		return ($account_query->row['total'] + $checkout_query->row['total']);
	}
/*
FUNCTION NAME 		-	getTotalStoresByOrderStatusId
DESCRIPTION 		-	Queries to get the total number of stores matching the order_status_id from the database.
INPUT PARAMETER 	-	order_status_id
OUTPUT PARAMETER 	- 	returns a row with column total containing count retrieved.
*/			
	public function getTotalStoresByOrderStatusId($order_status_id) {
      	$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "setting WHERE `key` = 'config_order_status_id' AND `value` = '" . (int)$order_status_id . "' AND store_id != '0'");
		
		return $query->row['total'];		
	}	
}
?>