<?php
/*
@File extension.php(MODEL)
SETTING:	 EXTENSION PAGE
    This class queries,adds and deletes the extension modules for the store.

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ModelSettingExtension extends Model {
/*
FUNCTION NAME 		-	getInstalled
DESCRIPTION 		-	Queries all the extension from the database for the given type.
INPUT PARAMETER 	-	type variable containing the extension type to be queried.
OUTPUT PARAMETER 	- 	Returns an array conataining the code for the matched extension type.
*/	
	public function getInstalled($type) {
		$extension_data = array();
		
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "extension WHERE `type` = '" . $this->db->escape($type) . "'");
		
		foreach ($query->rows as $result) {
			$extension_data[] = $result['code'];
		}
		
		return $extension_data;
	}
/*
FUNCTION NAME 		-	install
DESCRIPTION 		-	Adds the extension to the database if installed button is pressed.
INPUT PARAMETER 	-	type variable containing the extension type, code variable containing the extension code.
OUTPUT PARAMETER 	- 	Inserts the data and returns to the list.
*/		
	public function install($type, $code) {
		$this->db->query("INSERT INTO " . DB_PREFIX . "extension SET `type` = '" . $this->db->escape($type) . "', `code` = '" . $this->db->escape($code) . "'");
	}
/*
FUNCTION NAME 		-	uninstall
DESCRIPTION 		-	Deletes the extension from the database if uninstall button is pressed.
INPUT PARAMETER 	-	type variable containing the extension type, code variable containing the extension code.
OUTPUT PARAMETER 	- 	Deletes the data and returns to the list.
*/	
	public function uninstall($type, $code) {
		$this->db->query("DELETE FROM " . DB_PREFIX . "extension WHERE `type` = '" . $this->db->escape($type) . "' AND `code` = '" . $this->db->escape($code) . "'");
	}
/*
FUNCTION NAME 		-	sql
DESCRIPTION 		-	
INPUT PARAMETER 	-	
OUTPUT PARAMETER 	- 	
*/	
	public function sql($sql) {
			$query = '';

			foreach($lines as $line) {
				if ($line && (substr($line, 0, 2) != '--') && (substr($line, 0, 1) != '#')) {
					$query .= $line;
  
					if (preg_match('/;\s*$/', $line)) {
						$query = str_replace("DROP TABLE IF EXISTS `oc_", "DROP TABLE IF EXISTS `" . $data['db_prefix'], $query);
						$query = str_replace("CREATE TABLE `oc_", "CREATE TABLE `" . $data['db_prefix'], $query);
						$query = str_replace("INSERT INTO `oc_", "INSERT INTO `" . $data['db_prefix'], $query);
						
						$result = mysql_query($query, $connection); 
  
						if (!$result) {
							die(mysql_error());
						}
	
						$query = '';
					}
				}
			}		
	}
}
?>