<?php 
/*
@File voucher_theme.php(MODEL)
SALE:	 VOUCHER_THEME PAGE
    Manages the voucher theme by inserting, deleting and updating the voucher theme informations. 
    It also retrieves the voucher theme details if requiered.

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ModelSaleVoucherTheme extends Model {
/*
FUNCTION NAME 		-	addVoucherTheme
DESCRIPTION 		-	Adds new voucher theme to the database.
INPUT PARAMETER 	-	data array containing the details of the voucher theme.
OUTPUT PARAMETER 	- 	Inserts the voucher theme to the database and returns.
*/		
	public function addVoucherTheme($data) {
		$this->db->query("INSERT INTO " . DB_PREFIX . "voucher_theme SET image = '" . $this->db->escape(html_entity_decode($data['image'], ENT_QUOTES, 'UTF-8')) . "'");
		
		$voucher_theme_id = $this->db->getLastId();
		
		foreach ($data['voucher_theme_description'] as $language_id => $value) {
			$this->db->query("INSERT INTO " . DB_PREFIX . "voucher_theme_description SET voucher_theme_id = '" . (int)$voucher_theme_id . "', language_id = '" . (int)$language_id . "', name = '" . $this->db->escape($value['name']) . "'");
		}
		
		$this->cache->delete('voucher_theme');
	}
/*
FUNCTION NAME 		-	editVoucherTheme
DESCRIPTION 		-	Updates the voucher theme information based on the new values given in the array.
INPUT PARAMETER 	-	voucher_id, data array containing the information of the voucher theme
OUTPUT PARAMETER 	- 	Returns after updating the voucher theme
*/	
	public function editVoucherTheme($voucher_theme_id, $data) {
		$this->db->query("UPDATE " . DB_PREFIX . "voucher_theme SET image = '" . $this->db->escape(html_entity_decode($data['image'], ENT_QUOTES, 'UTF-8')) . "' WHERE voucher_theme_id = '" . (int)$voucher_theme_id . "'");
		
		$this->db->query("DELETE FROM " . DB_PREFIX . "voucher_theme_description WHERE voucher_theme_id = '" . (int)$voucher_theme_id . "'");

		foreach ($data['voucher_theme_description'] as $language_id => $value) {
			$this->db->query("INSERT INTO " . DB_PREFIX . "voucher_theme_description SET voucher_theme_id = '" . (int)$voucher_theme_id . "', language_id = '" . (int)$language_id . "', name = '" . $this->db->escape($value['name']) . "'");
		}
				
		$this->cache->delete('voucher_theme');
	}
/*
FUNCTION NAME 		-	deleteVoucherTheme
DESCRIPTION 		-	Deletes the voucher theme for the given voucher_theme_id
INPUT PARAMETER 	-	voucher_theme_id
OUTPUT PARAMETER 	- 	Returns after deleting the voucher theme
*/			
	public function deleteVoucherTheme($voucher_theme_id) {
		$this->db->query("DELETE FROM " . DB_PREFIX . "voucher_theme WHERE voucher_theme_id = '" . (int)$voucher_theme_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "voucher_theme_description WHERE voucher_theme_id = '" . (int)$voucher_theme_id . "'");
	
		$this->cache->delete('voucher_theme');
	}
/*
FUNCTION NAME 		-	getCustomer
DESCRIPTION 		-	Retrieves the customer details for the given customer_id
INPUT PARAMETER 	-	customer_id
OUTPUT PARAMETER 	- 	Returns the row retrieved.
*/			
	public function getVoucherTheme($voucher_theme_id) {
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "voucher_theme vt LEFT JOIN " . DB_PREFIX . "voucher_theme_description vtd ON (vt.voucher_theme_id = vtd.voucher_theme_id) WHERE vt.voucher_theme_id = '" . (int)$voucher_theme_id . "' AND vtd.language_id = '" . (int)$this->config->get('config_language_id') . "'");
		
		return $query->row;
	}
/*
FUNCTION NAME 		-	getVoucherThemes
DESCRIPTION 		-	Retrieves all the voucher themes from the database
INPUT PARAMETER 	-	data array containing filter options if any
OUTPUT PARAMETER 	- 	Returns all the rows retrieved.
*/		
	public function getVoucherThemes($data = array()) {
      	if ($data) {
			$sql = "SELECT * FROM " . DB_PREFIX . "voucher_theme vt LEFT JOIN " . DB_PREFIX . "voucher_theme_description vtd ON (vt.voucher_theme_id = vtd.voucher_theme_id) WHERE vtd.language_id = '" . (int)$this->config->get('config_language_id') . "' ORDER BY vtd.name";	
			
			if (isset($data['order']) && ($data['order'] == 'DESC')) {
				$sql .= " DESC";
			} else {
				$sql .= " ASC";
			}
			
			if (isset($data['start']) || isset($data['limit'])) {
				if ($data['start'] < 0) {
					$data['start'] = 0;
				}				

				if ($data['limit'] < 1) {
					$data['limit'] = 20;
				}	
			
				$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
			}	
			
			$query = $this->db->query($sql);
			
			return $query->rows;
		} else {
			$voucher_theme_data = $this->cache->get('voucher_theme.' . (int)$this->config->get('config_language_id'));
		
			if (!$voucher_theme_data) {
				$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "voucher_theme vt LEFT JOIN " . DB_PREFIX . "voucher_theme_description vtd ON (vt.voucher_theme_id = vtd.voucher_theme_id) WHERE vtd.language_id = '" . (int)$this->config->get('config_language_id') . "' ORDER BY vtd.name");
	
				$voucher_theme_data = $query->rows;
			
				$this->cache->set('voucher_theme.' . (int)$this->config->get('config_language_id'), $voucher_theme_data);
			}	
	
			return $voucher_theme_data;				
		}
	}
/*
FUNCTION NAME 		-	getVoucherThemeDescriptions
DESCRIPTION 		-	Retrieves the voucher theme description for the given voucher_theme_id
INPUT PARAMETER 	-	voucher_theme_id
OUTPUT PARAMETER 	- 	Returns the description for the given voucher theme.
*/	
	public function getVoucherThemeDescriptions($voucher_theme_id) {
		$voucher_theme_data = array();
		
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "voucher_theme_description WHERE voucher_theme_id = '" . (int)$voucher_theme_id . "'");
		
		foreach ($query->rows as $result) {
			$voucher_theme_data[$result['language_id']] = array('name' => $result['name']);
		}
		
		return $voucher_theme_data;
	}
/*
FUNCTION NAME 		-	getTotalVoucherThemes
DESCRIPTION 		-	Retrieves the total count for all the voucher themes from the database.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns the total count.
*/		
	public function getTotalVoucherThemes() {
      	$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "voucher_theme");
		
		return $query->row['total'];
	}	
}
?>