<?php
/*
@File voucher.php(MODEL)
SALE:	 VOUCHER PAGE
    Manages the voucher by inserting, deleting and updating the voucher informations. 
    It also retrieves the voucher details if requiered.

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ModelSaleVoucher extends Model {
/*
FUNCTION NAME 		-	addVoucher
DESCRIPTION 		-	Adds new voucher option to the database.
INPUT PARAMETER 	-	data array containing the details of the voucher.
OUTPUT PARAMETER 	- 	Inserts the voucher details to the database and returns.
*/		
	public function addVoucher($data) {
      	$this->db->query("INSERT INTO " . DB_PREFIX . "voucher SET code = '" . $this->db->escape($data['code']) . "', from_name = '" . $this->db->escape($data['from_name']) . "', from_email = '" . $this->db->escape($data['from_email']) . "', to_name = '" . $this->db->escape($data['to_name']) . "', to_email = '" . $this->db->escape($data['to_email']) . "', voucher_theme_id = '" . (int)$data['voucher_theme_id'] . "', message = '" . $this->db->escape($data['message']) . "', amount = '" . (float)$data['amount'] . "', status = '" . (int)$data['status'] . "', date_added = NOW()");
	}
/*
FUNCTION NAME 		-	editVoucher
DESCRIPTION 		-	Updates the voucher information based on the new values given in the array.
INPUT PARAMETER 	-	data array containing the information of the voucher
OUTPUT PARAMETER 	- 	Returns after updating the voucher
*/	
	public function editVoucher($voucher_id, $data) {
      	$this->db->query("UPDATE " . DB_PREFIX . "voucher SET code = '" . $this->db->escape($data['code']) . "', from_name = '" . $this->db->escape($data['from_name']) . "', from_email = '" . $this->db->escape($data['from_email']) . "', to_name = '" . $this->db->escape($data['to_name']) . "', to_email = '" . $this->db->escape($data['to_email']) . "', voucher_theme_id = '" . (int)$data['voucher_theme_id'] . "', message = '" . $this->db->escape($data['message']) . "', amount = '" . (float)$data['amount'] . "', status = '" . (int)$data['status'] . "' WHERE voucher_id = '" . (int)$voucher_id . "'");
	}
/*
FUNCTION NAME 		-	deleteVoucher
DESCRIPTION 		-	Deletes the voucher for the given voucher_id
INPUT PARAMETER 	-	voucher_id
OUTPUT PARAMETER 	- 	Returns after deleting the voucher
*/		
	public function deleteVoucher($voucher_id) {
      	$this->db->query("DELETE FROM " . DB_PREFIX . "voucher WHERE voucher_id = '" . (int)$voucher_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "voucher_history WHERE voucher_id = '" . (int)$voucher_id . "'");
	}
/*
FUNCTION NAME 		-	getVoucher
DESCRIPTION 		-	Retrieves the voucher details for the given voucher_id
INPUT PARAMETER 	-	voucher_id
OUTPUT PARAMETER 	- 	Returns the row retrieved.
*/		
	public function getVoucher($voucher_id) {
      	$query = $this->db->query("SELECT DISTINCT * FROM " . DB_PREFIX . "voucher WHERE voucher_id = '" . (int)$voucher_id . "'");
		
		return $query->row;
	}
/*
FUNCTION NAME 		-	getVoucherByCode
DESCRIPTION 		-	Retrieves the voucher details for the given voucher code
INPUT PARAMETER 	-	voucher code
OUTPUT PARAMETER 	- 	Returns the row retrieved.
*/	
	public function getVoucherByCode($code) {
      	$query = $this->db->query("SELECT DISTINCT * FROM " . DB_PREFIX . "voucher WHERE code = '" . $this->db->escape($code) . "'");
		
		return $query->row;
	}
/*
FUNCTION NAME 		-	getVouchers
DESCRIPTION 		-	Retrieves all the vouchers from the database.
INPUT PARAMETER 	-	data array containing filter options if any.
OUTPUT PARAMETER 	- 	Returns all the rows retrieved.
*/			
	public function getVouchers($data = array()) {
		$sql = "SELECT v.voucher_id, v.code, v.from_name, v.from_email, v.to_name, v.to_email, (SELECT vtd.name FROM " . DB_PREFIX . "voucher_theme_description vtd WHERE vtd.voucher_theme_id = v.voucher_theme_id AND vtd.language_id = '" . (int)$this->config->get('config_language_id') . "') AS theme, v.amount, v.status, v.date_added FROM " . DB_PREFIX . "voucher v";
		
		$sort_data = array(
			'v.code',
			'v.from_name',
			'v.from_email',
			'v.to_name',
			'v.to_email',
			'v.theme',
			'v.amount',
			'v.status',
			'v.date_added'
		);	
			
		if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
			$sql .= " ORDER BY " . $data['sort'];	
		} else {
			$sql .= " ORDER BY v.date_added";	
		}
			
		if (isset($data['order']) && ($data['order'] == 'DESC')) {
			$sql .= " DESC";
		} else {
			$sql .= " ASC";
		}
		
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}			

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}	
			
			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}		
		
		$query = $this->db->query($sql);
		
		return $query->rows;
	}
/*
FUNCTION NAME 		-	sendVoucher
DESCRIPTION 		-	Sends voucher with given voucher_id to the specific 
						email given in the voucher details
INPUT PARAMETER 	-	voucher_id
OUTPUT PARAMETER 	- 	Returns after sending the voucher.
*/			
	public function sendVoucher($voucher_id) {
		$voucher_info = $this->getVoucher($voucher_id);
		
		if ($voucher_info) {
			if ($voucher_info['order_id']) {
				$order_id = $voucher_info['order_id'];
			} else {
				$order_id = 0;
			}
			
			$this->load->model('sale/order');
			
			$order_info = $this->model_sale_order->getOrder($order_id);
			
			// If voucher belongs to an order
			if ($order_info) {
				$this->load->model('localisation/language');
				
				$language = new Language($order_info['language_directory']);
				$language->load($order_info['language_filename']);	
				$language->load('mail/voucher');
				
				// HTML Mail
				$template = new Template();				
				
				$template->data['title'] = sprintf($language->get('text_subject'), $voucher_info['from_name']);
				
				$template->data['text_greeting'] = sprintf($language->get('text_greeting'), $this->currency->format($voucher_info['amount'], $order_info['currency_code'], $order_info['currency_value']));
				$template->data['text_from'] = sprintf($language->get('text_from'), $voucher_info['from_name']);
				$template->data['text_message'] = $language->get('text_message');
				$template->data['text_redeem'] = sprintf($language->get('text_redeem'), $voucher_info['code']);
				$template->data['text_footer'] = $language->get('text_footer');	
				
				$this->load->model('sale/voucher_theme');
					
				$voucher_theme_info = $this->model_sale_voucher_theme->getVoucherTheme($voucher_info['voucher_theme_id']);
				
				if ($voucher_info && file_exists(DIR_IMAGE . $voucher_theme_info['image'])) {
					$template->data['image'] = HTTP_CATALOG . 'image/' . $voucher_theme_info['image'];
				} else {
					$template->data['image'] = '';
				}
				
				$template->data['store_name'] = $order_info['store_name'];
				$template->data['store_url'] = $order_info['store_url'];
				$template->data['message'] = nl2br($voucher_info['message']);
	
				$mail = new Mail(); 
				$mail->protocol = $this->config->get('config_mail_protocol');
				$mail->parameter = $this->config->get('config_mail_parameter');
				$mail->hostname = $this->config->get('config_smtp_host');
				$mail->username = $this->config->get('config_smtp_username');
				$mail->password = $this->config->get('config_smtp_password');
				$mail->port = $this->config->get('config_smtp_port');
				$mail->timeout = $this->config->get('config_smtp_timeout');			
				$mail->setTo($voucher_info['to_email']);
				$mail->setFrom($this->config->get('config_email'));
				$mail->setSender($order_info['store_name']);
				$mail->setSubject(html_entity_decode(sprintf($language->get('text_subject'), $voucher_info['from_name']), ENT_QUOTES, 'UTF-8'));
				$mail->setHtml($template->fetch('mail/voucher.tpl'));				
				$mail->send();
			
			// If voucher does not belong to an order				
			}  else {
				$this->language->load('mail/voucher');
				
				$template = new Template();		
				
				$template->data['title'] = sprintf($this->language->get('text_subject'), $voucher_info['from_name']);
				
				$template->data['text_greeting'] = sprintf($this->language->get('text_greeting'), $this->currency->format($voucher_info['amount'], $order_info['currency_code'], $order_info['currency_value']));
				$template->data['text_from'] = sprintf($this->language->get('text_from'), $voucher_info['from_name']);
				$template->data['text_message'] = $this->language->get('text_message');
				$template->data['text_redeem'] = sprintf($this->language->get('text_redeem'), $voucher_info['code']);
				$template->data['text_footer'] = $this->language->get('text_footer');					
			
				$this->load->model('sale/voucher_theme');
					
				$voucher_theme_info = $this->model_sale_voucher_theme->getVoucherTheme($voucher_info['voucher_theme_id']);
				
				if ($voucher_info && file_exists(DIR_IMAGE . $voucher_theme_info['image'])) {
					$template->data['image'] = HTTP_CATALOG . 'image/' . $voucher_theme_info['image'];
				} else {
					$template->data['image'] = '';
				}
				
				$template->data['store_name'] = $this->config->get('config_name');
				$template->data['store_url'] = HTTP_CATALOG;
				$template->data['message'] = nl2br($voucher_info['message']);
	
				$mail = new Mail(); 
				$mail->protocol = $this->config->get('config_mail_protocol');
				$mail->parameter = $this->config->get('config_mail_parameter');
				$mail->hostname = $this->config->get('config_smtp_host');
				$mail->username = $this->config->get('config_smtp_username');
				$mail->password = $this->config->get('config_smtp_password');
				$mail->port = $this->config->get('config_smtp_port');
				$mail->timeout = $this->config->get('config_smtp_timeout');			
				$mail->setTo($voucher_info['to_email']);
				$mail->setFrom($this->config->get('config_email'));
				$mail->setSender($this->config->get('config_name'));
				$mail->setSubject(html_entity_decode(sprintf($this->language->get('text_subject'), $voucher_info['from_name']), ENT_QUOTES, 'UTF-8'));
				$mail->setHtml($template->fetch('mail/voucher.tpl'));
				$mail->send();				
			}
		}
	}
/*
FUNCTION NAME 		-	getTotalVouchers
DESCRIPTION 		-	Retrieves the total count for all the vouchers from the database.
INPUT PARAMETER 	-	void 
OUTPUT PARAMETER 	- 	Returns the total count.
*/				
	public function getTotalVouchers() {
      	$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "voucher");
		
		return $query->row['total'];
	}	
/*
FUNCTION NAME 		-	getTotalVouchersByVoucherThemeId
DESCRIPTION 		-	Retrieves the total count for all the vouchers for the given 
						voucher_theme_id from the database.
INPUT PARAMETER 	-	voucher_theme_id
OUTPUT PARAMETER 	- 	Returns the total count.
*/		
	public function getTotalVouchersByVoucherThemeId($voucher_theme_id) {
      	$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "voucher WHERE voucher_theme_id = '" . (int)$voucher_theme_id . "'");
		
		return $query->row['total'];
	}	
/*
FUNCTION NAME 		-	getVoucherHistories
DESCRIPTION 		-	Retrieves all the voucher histories for the given 
						voucher_id
INPUT PARAMETER 	-	voucher_id, start, limit to retrieve in blocks
OUTPUT PARAMETER 	- 	Returns all the rows retrieved.
*/	
	public function getVoucherHistories($voucher_id, $start = 0, $limit = 10) {
		if ($start < 0) {
			$start = 0;
		}
		
		if ($limit < 1) {
			$limit = 10;
		}	
				
		$query = $this->db->query("SELECT vh.order_id, CONCAT(o.firstname, ' ', o.lastname) AS customer, vh.amount, vh.date_added FROM " . DB_PREFIX . "voucher_history vh LEFT JOIN `" . DB_PREFIX . "order` o ON (vh.order_id = o.order_id) WHERE vh.voucher_id = '" . (int)$voucher_id . "' ORDER BY vh.date_added ASC LIMIT " . (int)$start . "," . (int)$limit);

		return $query->rows;
	}
/*
FUNCTION NAME 		-	getTotalVoucherHistories
DESCRIPTION 		-	Retrieves the total count for all the voucher histories for the given 
						voucher_id from the database.
INPUT PARAMETER 	-	voucher_id
OUTPUT PARAMETER 	- 	Returns the total count.
*/		
	public function getTotalVoucherHistories($voucher_id) {
	  	$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "voucher_history WHERE voucher_id = '" . (int)$voucher_id . "'");

		return $query->row['total'];
	}			
}
?>