<?php
/*
@File stb.php(MODEL)
DESIGN:	 STB PAGE
    This class retrieves the stb number detials along with their activation.

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ModelsaleRegion extends Model {
/*
FUNCTION NAME 		-	getDetail
DESCRIPTION 		-	Retrieves all the mapping between cas number, stb number and customer id.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns all the rows retrieved by the query.
*/		
		public function getDetail($data) {
		//$this->db->query("select c.name c.stbno c.casno a.city from customer c  ");
		$sql ="SELECT * FROM  " . DB_PREFIX . "region";
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}				

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}	
		
			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}	
		$query = $this->db->query($sql);//var_dump($sql);exit();
		return $query->rows;
		}
		/*
FUNCTION NAME 		-	getTotalRegion
DESCRIPTION 		-	Retrieves all the mapping between cas number, stb number and customer id.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns all the rows retrieved by the query.
*/		
		public function getTotalRegion() {
		//$this->db->query("select c.name c.stbno c.casno a.city from customer c  ");
		$query = $this->db->query("SELECT COUNT(*) AS Total FROM  " . DB_PREFIX . "region");
		return $query->row['Total'];
		}

/*
FUNCTION NAME 		-	addCustomerBanIp
DESCRIPTION 		-	Adds new customer_ban_ip to the database.
INPUT PARAMETER 	-	data array containing the details of the customer_ban_ip.
OUTPUT PARAMETER 	- 	Inserts the customer_ban_ip details to the database and returns.
*/	
	public function addRegion($data) {
		$query = $this->db->query("SELECT *  FROM  " . DB_PREFIX . "region");
		$isRegionTableEmpty = !$query->num_rows;

		$sql = "INSERT INTO `" . DB_PREFIX . "region` SET region_name = '" . $this->db->escape($data['region']) . "',pin = '" . $this->db->escape($data['pin']) . "',country_id = '" . $this->db->escape($data['country_id']) . "',zone_id = '" . $this->db->escape($data['zone_id']) . "' ";
		if($isRegionTableEmpty)
			$sql .= ", is_default=1";
		$this->db->query($sql);
		return $this->db->getLastId();
	}		

/*
FUNCTION NAME 		-	editCustomerBanIp
DESCRIPTION 		-	Updates the customer ban ip for the given customer ban ip id
INPUT PARAMETER 	-	customer_ban_ip_id
OUTPUT PARAMETER 	- 	Retuns after updaing the ban ip
*/	
	public function editRegion($region_id, $data) {
		$this->db->query("UPDATE `" . DB_PREFIX . "region` SET `region_name` = '" . $this->db->escape($data['region']) . "', pin = '".$this->db->escape($data['pin'])."', country_id = '".$this->db->escape($data['country_id'])."' , zone_id = '".$this->db->escape($data['zone_id'])."' WHERE region_id = '" . (int)$region_id . "'");
	}
//---------
	/*
	FUNCTION NAME 		-	defaultCustomerGroup
	DESCRIPTION 		-	Updates the customer group for the given customer_group_id
	INPUT PARAMETER 	-	customer_group_id
	OUTPUT PARAMETER 	- 	Retuns after updaing the customer_group
*/	
	public function defaultCustomerRegion($region_pin) {
		$this->db->query("UPDATE " . DB_PREFIX . "region SET is_default =0");
		 if ((int)$region_pin) {
		 	$this->db->query("UPDATE " . DB_PREFIX . "region SET is_default =1 WHERE pin = '" . (int)$region_pin . "'");
		//  	$query1 = $this->db->query("SELECT  CONCAT(name, "."\" (default)\"".") AS name FROM " .  DB_PREFIX . "customer_group_description  WHERE customer_group_id = '" . (int)$customer_group_id . "'");
		// return $query1->row;
		  } 
	}
	public function getCustomerRegionStatus($region_id) {
			$query1 = $this->db->query("SELECT  is_default FROM " .  DB_PREFIX . "region  WHERE region_id = '" . (int)$region_id . "'");
		return $query1->row;
	}

	public function isCustomerRegionDefault($region_pin) {
			$query1 = $this->db->query("SELECT  * FROM " .  DB_PREFIX . "region  WHERE pin = '" . (int)$region_pin . "' AND is_default =1");
		return $query1->num_rows;
	}


//---------


/*
FUNCTION NAME 		-	deleteCustomerBanIp
DESCRIPTION 		-	Deletes the customer ban ip for the given customer ban ip id
INPUT PARAMETER 	-	customer_ban_ip_id
OUTPUT PARAMETER 	- 	Returns after deleting the ban ip
*/		
	public function deleteRegion($region_pin) {
		$this->db->query("DELETE FROM `" . DB_PREFIX . "region` WHERE pin = '" . (int)$region_pin . "'");
		// $this->db->query("DELETE FROM `" . DB_PREFIX . "sms_kms_region` WHERE region_id = '" . (int)$region_id . "'");
	}


	public function isRegionMapped($region_pin){
		$query = $this->db->query("SELECT * FROM `".DB_PREFIX."address` WHERE region_id = (select region_id from  `".DB_PREFIX."region` WHERE pin = ".(int)$region_pin.")" );
		return $query->num_rows;

	}
/*
FUNCTION NAME 		-	getDetail
DESCRIPTION 		-	Retrieves all the mapping between cas number, stb number and customer id.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns all the rows retrieved by the query.
*/		
	public function getRegion($region_id) 
		{
		$query = $this->db->query("SELECT  * FROM " . DB_PREFIX . "region where region_id='".$region_id."'");
		return $query->row;
		}
	public function getRegionId($region_name) {
		$query = $this->db->query("SELECT  region_id FROM " . DB_PREFIX . "region where region_name='".$region_name."'");
		return $query->row;
		}
	
	public function addApiResponceId($kms_region_id,$sms_region_id)
	{
	 	$this->db->query("INSERT INTO " . DB_PREFIX . "sms_kms_region SET region_id = '" . (int)$sms_region_id . "', kms_region_id = '" . (int)$kms_region_id . "'");

	}
	

	public function getApiResponceId($region_id)
	{
	 	// $this->db->query("INSERT INTO " . DB_PREFIX . "user_api_response SET user_id = '" . (int)$user_id . "', api_user_id = '" . (int)$apiuser_id . "'");
	 	$query = $this->db->query("SELECT kms_region_id FROM `" . DB_PREFIX . "sms_kms_region` WHERE region_id = '" . (int)$region_id . "'");
	
		return $query->row;
	}

	public function isRegionExist($region_name,$regionId)
	{
	 	$query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "region` WHERE region_name = '" . $region_name . "' AND region_id != '".$regionId."' " );
		return ($query->num_rows>0);
	}
	
	public function isRegionNameExist($region_name)
	{
	 	$query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "region` WHERE region_name like '" . $region_name."'" );
		return ($query->num_rows>0);
	}
	public function isRegionPinExist($region_pin)
	{
	 	$query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "region` WHERE pin = '" . $region_pin."'" );
		return ($query->num_rows>0);
	}

	public function CheckCategoryNameByid($category_id){
		$query = $this->db->query("SELECT name FROM " . DB_PREFIX . "category_description WHERE `category_id` = '" . $category_id . "'");

		return $query->row;
	}
	/*
FUNCTION NAME 		-	getTotalCustomersByCustomerRegionId
DESCRIPTION 		-	Retrieves the total count for all the customers for the given 
						customer_region_id from the database.
INPUT PARAMETER 	-	customer_region_id
OUTPUT PARAMETER 	- 	Returns the total count.
*/
	public function getTotalCustomersByCustomerRegionId($customer_region_id) {
		$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "customer WHERE customer_region_id = '" . (int)$customer_region_id . "'");
		
		return $query->row['total'];
	}
	
	public function CheckRegionNameByid($customer_region_id){
		$query = $this->db->query("SELECT region_name FROM " . DB_PREFIX . "region WHERE `region_id` = '" . $customer_region_id . "'");

		return $query->num_rows;
	}

}
?>