<?php
/*
@File mobile_request.php(MODEL)
SALE:	 
    Manages the retrieves the mobile requests if requiered.

@Author Mahesh Yallure
@date 2nd Nov. 2015
*/
class ModelSaleMobileRequest extends Model {
	
/*
FUNCTION NAME 		-	getMobileRequests
DESCRIPTION 		-	Retrieves all the Mobile requests from the database.
INPUT PARAMETER 	-	data array containing filter options if any.
OUTPUT PARAMETER 	- 	Returns the Mobile requests.
*/
	public function getMobileRequests($data = array()) {
		$flag=false;
		$sql = "SELECT * FROM " . DB_PREFIX . "mobile_request";


		if (isset($data['filter_mobile_no']) && !is_null($data['filter_mobile_no'])) {
			$sql .= " WHERE mobile_no LIKE '" . (int)$data['filter_mobile_no'] . "%'";
			$flag=true;
		}
		if (isset($data['filter_recievedon']) && !is_null($data['filter_recievedon'])) {
			if($flag)
				$sql .= " AND date LIKE '%" . $data['filter_recievedon'] . "%'";
			else
				$sql .= " WHERE date LIKE '%" .$data['filter_recievedon'] . "%'";
		}
		if (isset($data['filter_message']) && !is_null($data['filter_message'])) {
			if($flag)
				$sql .= " AND message LIKE '%" . $this->db->escape($data['filter_message']) . "%'";
			else
				$sql .= " WHERE message LIKE '%" .$this->db->escape($data['filter_message']) . "%'";
		}
		

		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}

			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}

		$query = $this->db->query($sql);

		return $query->rows;
	}

/*
FUNCTION NAME 		-	getTotalRequests
DESCRIPTION 		-	Retrieves the total count for all the Mobile requests from the database.
INPUT PARAMETER 	-	data array containing filter options if any.
OUTPUT PARAMETER 	- 	Returns the total count.
*/	
	public function getTotalRequests($data = array()) {
		$flag=false;
      	$sql = "SELECT COUNT(*) AS total FROM `" . DB_PREFIX . "mobile_request`";

		if (isset($data['filter_mobile_no']) && !is_null($data['filter_mobile_no'])) {
			$sql .= " WHERE mobile_no LIKE '" . (int)$data['filter_mobile_no'] . "%'";
			$flag=true;
		}
		if (isset($data['filter_recievedon']) && !is_null($data['filter_recievedon'])) {
			if($flag)
				$sql .= " AND date LIKE '" . (int)$data['filter_recievedon'] . "%'";
			else
				$sql .= " WHERE date LIKE '" . (int)$data['filter_recievedon'] . "%'";
		}
		
		$query = $this->db->query($sql);

		return $query->row['total'];
	}

}
?>